/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bd.assistant.plugin.basedata.BankAccountSaveValidator;
import kd.bd.assistant.plugin.basedata.BankAcctVirtualValidator;
import kd.bd.assistant.plugin.enums.BankFuncEnum;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.collections.CollectionUtils;

public class BankAccountSaveOp
extends AbstractOperationServicePlugIn {
    private static final String[] bankFunc = new String[]{BankFuncEnum.QUERY.getValue(), BankFuncEnum.PAY.getValue(), BankFuncEnum.RECEIPT.getValue(), BankFuncEnum.ECD.getValue(), BankFuncEnum.PROXYINQUIRY.getValue()};

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BankAccountSaveValidator());
        e.addValidator((AbstractValidator)new BankAcctVirtualValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("opendate");
        fieldKeys.add("finorgtype");
        fieldKeys.add("bank");
        fieldKeys.add("currency");
        fieldKeys.add("defaultcurrency");
        fieldKeys.add("org");
        fieldKeys.add("bankaccountnumber");
        fieldKeys.add("ismulcurrency");
        fieldKeys.add("createorg");
        fieldKeys.add("virtualentity");
        fieldKeys.add("virtualentity.seq");
        fieldKeys.add("virtualentity.virtualaccount");
        fieldKeys.add("virtualentity.openbank");
        fieldKeys.add("virtualentity.virtualbankaccount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        ArrayList<String> currencyNames = null;
        for (DynamicObject bankAcct : args.getDataEntities()) {
            DynamicObjectCollection currencys = bankAcct.getDynamicObjectCollection("currency");
            DynamicObject defCurrency = bankAcct.getDynamicObject("defaultcurrency");
            currencyNames = new ArrayList<String>(currencys.size());
            currencyNames.add(defCurrency.getString("name"));
            for (DynamicObject currency : currencys) {
                if (((DynamicObject)currency.get("fbasedataid")).getPkValue().equals(defCurrency.getPkValue())) continue;
                currencyNames.add(((DynamicObject)currency.get("fbasedataid")).getString("name"));
            }
            if (CollectionUtils.isEmpty((Collection)currencys) || currencys.size() == 1) {
                bankAcct.set("ismulcurrency", (Object)Boolean.FALSE);
            } else {
                bankAcct.set("ismulcurrency", (Object)Boolean.TRUE);
            }
            String currencyName = StringUtils.join((Object[])currencyNames.toArray(new String[0]), (String)",");
            bankAcct.set("currencyname", (Object)currencyName);
            bankAcct.set("org", bankAcct.get("company"));
            bankAcct.set("createorg", bankAcct.get("company"));
            bankAcct.set("number", bankAcct.get("bankaccountnumber"));
            String bebankfunc = bankAcct.getString("bebankfunc");
            DynamicObjectCollection entries = bankAcct.getDynamicObjectCollection("entry");
            boolean tag = bankAcct.getBoolean("issetbankinterface");
            Date openDate = bankAcct.getDate("opendate");
            if (tag) {
                if (entries.isEmpty()) {
                    for (int i = 0; i < 5; ++i) {
                        DynamicObject entry = entries.addNew();
                        entry.set("e_bankfunction", (Object)bankFunc[i]);
                        entry.set("seq", (Object)(i + 1));
                        entry.set("e_enable", (Object)(!StringUtils.isBlank((CharSequence)bebankfunc) && bebankfunc.contains(bankFunc[i]) ? 1 : 0));
                        if (StringUtils.isBlank((CharSequence)bebankfunc) || !bebankfunc.contains(bankFunc[i])) continue;
                        entry.set("e_predictopendate", (Object)openDate);
                    }
                    continue;
                }
                for (DynamicObject entry : entries) {
                    entry.set("e_enable", (Object)(!StringUtils.isBlank((CharSequence)bebankfunc) && bebankfunc.contains(entry.getString("e_bankfunction")) ? 1 : 0));
                }
                continue;
            }
            entries.clear();
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] bankAccts;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject bankAcct : bankAccts = e.getDataEntities()) {
            long companyId = bankAcct.getDynamicObject("company").getLong("id");
            String key = "am_accountbank" + companyId;
            String type = BaseDataCtrlCacheMrg.getType4BaseDataFilter();
            BaseDataCtrlCacheMrg.clearCache((String)type, (String)key);
            BaseDataCtrlCache.clearBaseDataUseRange((String)"am_accountbank", (Long)companyId);
        }
    }
}

