/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.List;
import kd.bd.assistant.plugin.basedata.FinTreeDeleteValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class FinTreeDeleteOp
extends AbstractOperationServicePlugIn {
    public static final String PARENT = "parent";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add(PARENT);
        fieldKeys.add("longnumber");
        fieldKeys.add("level");
        fieldKeys.add("is_leaf");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinTreeDeleteValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ORM orm = ORM.create();
        ArrayList<String> finOrgNoList = new ArrayList<String>(10);
        for (DynamicObject data : e.getDataEntities()) {
            DynamicObject parentRef = data.getDynamicObject(PARENT);
            finOrgNoList.add(data.getString("number"));
            if (parentRef == null) continue;
            DynamicObject parent = BusinessDataServiceHelper.loadSingleFromCache((Object)parentRef.getPkValue(), (String)parentRef.getDataEntityType().getName());
            QFilter parentFilter = new QFilter(PARENT, "=", parent.getPkValue());
            boolean existsChild = orm.exists(parent.getDataEntityType().getName(), new QFilter[]{parentFilter});
            if (existsChild) continue;
            parent.set("is_leaf", (Object)Boolean.TRUE);
            orm.update(parent);
        }
        try {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"tmbrm", (String)"syncFinOrgService", (String)"deleteFinOrg", (Object[])new Object[]{finOrgNoList});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

