/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.List;
import kd.bd.assistant.helper.FinTreeHelper;
import kd.bd.assistant.plugin.basedata.FinTreeSaveValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinTreeSaveOp
extends AbstractOperationServicePlugIn {
    public static final String IS_LEAF = "is_leaf";
    public static final String LONGNUMBER = "longnumber";
    public static final String LEVEL = "level";
    public static final String PARENT = "parent";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(PARENT);
        fieldKeys.add(LEVEL);
        fieldKeys.add(LONGNUMBER);
        fieldKeys.add(IS_LEAF);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinTreeSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ORM orm = ORM.create();
        for (DynamicObject data : e.getDataEntities()) {
            boolean isFromDb = data.getDataEntityState().getFromDatabase();
            if (isFromDb && FinTreeHelper.isParentChanged(data)) {
                this.doUpdate(data);
            }
            DynamicObject parentRef = data.getDynamicObject(PARENT);
            String number = data.getString("number");
            boolean pIsLeaf = false;
            DynamicObject parent = null;
            if (!isFromDb && null != parentRef) {
                parent = BusinessDataServiceHelper.loadSingle((Object)parentRef.getPkValue(), (String)parentRef.getDataEntityType().getName());
                int pLevel = parent.getInt(LEVEL);
                String pLongNumber = parent.getString(LONGNUMBER);
                pIsLeaf = parent.getBoolean(IS_LEAF);
                data.set(LEVEL, (Object)(pLevel + 1));
                data.set(IS_LEAF, (Object)Boolean.TRUE);
                data.set(LONGNUMBER, (Object)(pLongNumber + "!" + number));
            }
            if (pIsLeaf && null != parent) {
                parent.set(IS_LEAF, (Object)Boolean.FALSE);
                orm.update(parent);
            }
            if (isFromDb || null != parentRef) continue;
            data.set(LEVEL, (Object)1);
            data.set(IS_LEAF, (Object)Boolean.TRUE);
            data.set(LONGNUMBER, (Object)number);
        }
    }

    private void doUpdate(DynamicObject data) {
        int newLevel;
        String newLongNumber;
        ORM orm = ORM.create();
        DynamicObject parentRef = data.getDynamicObject(PARENT);
        String number = data.getString("number");
        if (parentRef != null) {
            DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentRef.getPkValue(), (String)parentRef.getDataEntityType().getName());
            int pLevel = parent.getInt(LEVEL);
            boolean pIsLeaf = parent.getBoolean(IS_LEAF);
            String pLongNumber = parent.getString(LONGNUMBER);
            newLongNumber = pLongNumber + "!" + number;
            newLevel = pLevel + 1;
            if (pIsLeaf) {
                parent.set(IS_LEAF, (Object)Boolean.FALSE);
                orm.update(parent);
            }
        } else {
            newLongNumber = number;
            newLevel = 1;
        }
        String currLongNumber = data.getString(LONGNUMBER);
        int currLevel = data.getInt(LEVEL);
        int levelDiff = newLevel - currLevel;
        data.set(LONGNUMBER, (Object)newLongNumber);
        data.set(LEVEL, (Object)newLevel);
        QFilter childFilter = new QFilter(LONGNUMBER, "like", (Object)String.format("%s%%", currLongNumber));
        QFilter notMeFilter = new QFilter("id", "!=", data.getPkValue());
        DynamicObjectCollection resultList = orm.query(data.getDataEntityType().getName(), new QFilter[]{childFilter, notMeFilter});
        for (DynamicObject child : resultList) {
            int cLevel = child.getInt(LEVEL);
            String cLongNumber = child.getString(LONGNUMBER);
            child.set(LEVEL, (Object)(cLevel + levelDiff));
            child.set(LONGNUMBER, (Object)cLongNumber.replaceFirst(currLongNumber, newLongNumber));
        }
        orm.update((List)resultList);
        DynamicObject prevData = BusinessDataServiceHelper.loadSingle((Object)data.getPkValue(), (String)data.getDataEntityType().getName());
        DynamicObject prevDataParentRef = prevData.getDynamicObject(PARENT);
        if (prevDataParentRef != null) {
            DynamicObject prevParent = BusinessDataServiceHelper.loadSingleFromCache((Object)prevDataParentRef.getPkValue(), (String)prevDataParentRef.getDataEntityType().getName());
            QFilter parentFilter = new QFilter(PARENT, "=", prevParent.getPkValue());
            QFilter notMeFiler = new QFilter("id", "!=", data.getPkValue());
            boolean existsChild = orm.exists(prevParent.getDataEntityType().getName(), new QFilter[]{parentFilter, notMeFiler});
            if (!existsChild) {
                prevParent.set(IS_LEAF, (Object)Boolean.TRUE);
                orm.update(prevParent);
            }
        }
    }
}

