/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class NetBankAcctDelOp
extends AbstractOperationServicePlugIn {
    public static final String BANKACCT = "bankAcct";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(BANKACCT);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject data : e.getDataEntities()) {
            if (null == data.getDynamicObject(BANKACCT)) continue;
            DynamicObject parentBank = BusinessDataServiceHelper.loadSingle((Object)data.getDynamicObject(BANKACCT).getPkValue(), (String)"bd_accountbanks");
            DynamicObjectCollection onlineBanks = parentBank.getDynamicObjectCollection("netbank");
            HashMap entryMap = onlineBanks.stream().collect(Collectors.toMap(v -> v.getDynamicObject("fbasedataid").getPkValue(), o -> o, (o1, o2) -> o1, HashMap::new));
            DynamicObject oldNetBank = (DynamicObject)entryMap.get(data.getPkValue());
            onlineBanks.remove((Object)oldNetBank);
            parentBank.set("netbank", (Object)onlineBanks);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentBank});
        }
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, DynamicObject ... objs) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity.getDataEntityType().getName());
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(propName);
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("pkid", obj.getPkValue());
            newObj.set("fbasedataid", (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }
}

