/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.cal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class MaterialCalInfoUniqueValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> masterids = new HashSet<Long>(16);
        HashMap<Long, Set> masterid2InfoMap = new HashMap<Long, Set>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            String ctrlstrategy = info.getString("ctrlstrategy");
            Long masterid = info.getLong("masterid_id");
            if (!"7".equals(ctrlstrategy)) continue;
            masterids.add(masterid);
            Set set = masterid2InfoMap.computeIfAbsent(masterid, k -> new HashSet(4));
            set.add(dataEntity);
        }
        if (masterids.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)"5");
        filter.and("masterid", "in", masterids);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialcalinfo", (String)"masterid", (QFilter[])filter.toArray(), null);){
            for (Row row : ds) {
                Long masterid = row.getLong("masterid");
                Set set = (Set)masterid2InfoMap.get(masterid);
                for (ExtendedDataEntity extendedDataEntity : set) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u5168\u5c40\u5171\u4eab\u7684\u7269\u6599\u6838\u7b97\u4fe1\u606f", (String)"MaterialCalInfoUniqueValidator_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

