/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashSet;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AuxPropUnAuditValidator
extends AbstractValidator {
    private Log log = LogFactory.getLog(AuxPropUnAuditValidator.class);

    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AuxPropUnAuditValidator", (String)"checkReferences");){
            this.checkReferences(this.dataEntities);
        }
    }

    private void checkReferences(ExtendedDataEntity[] dataEntities) {
        HashSet<Object> auxPropIdSet = new HashSet<Object>(dataEntities.length);
        String entityNumber = "";
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object auxPropId;
            if (StringUtils.isBlank((CharSequence)entityNumber)) {
                entityNumber = dataEntity.getDataEntity().getDataEntityType().getName();
            }
            if (StringUtils.isBlank((Object)(auxPropId = dataEntity.getDataEntity().getPkValue()))) continue;
            auxPropIdSet.add(auxPropId);
        }
        this.log.info("[AuxPropUnAuditValidator.checkReferences]:entityNumber=" + entityNumber + ",auxPropIdSet=" + auxPropIdSet);
        if (auxPropIdSet.isEmpty()) {
            return;
        }
        Map checkReferenceResult = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])auxPropIdSet.toArray(new Object[0]), null, null, null);
        StringBuilder logBuilder = new StringBuilder("[AuxPropUnAuditValidator.checkReferences]:checkReferenceResult=");
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object auxPropId = dataEntity.getDataEntity().getPkValue();
            BaseDataCheckRefrenceResult referenceResult = (BaseDataCheckRefrenceResult)checkReferenceResult.get(auxPropId);
            logBuilder.append(" {auxPropId=").append(auxPropId).append(",isRefence=").append(referenceResult == null ? "null" : Boolean.valueOf(referenceResult.isRefence())).append('}');
            if (referenceResult == null || !referenceResult.isRefence()) continue;
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)referenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = "";
            String refCol = referenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refCol)) {
                    fieldName = ((IFieldHandle)property).getDisplayName().toString();
                    break;
                }
                if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refCol, (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)referenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                fieldName = ((MulBasedataProp)property).getDisplayName().toString();
                break;
            }
            String errMsg = String.format(ResManager.loadKDString((String)"[%1$s]\u7684\u5b57\u6bb5[%2$s]\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"AuxPropUnAuditValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]), billName, fieldName);
            this.addMessage(dataEntity, errMsg);
        }
        this.log.info(logBuilder.toString());
    }
}

