/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class MaterialMftValidator
extends AbstractValidator {
    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "submit": {
                this.checkMaterial();
                this.checkData();
                break;
            }
            case "audit": {
                this.checkMaterial();
                this.checkUniqueMaterial();
                break;
            }
            case "save": {
                this.checkMaterial();
                this.checkUnit();
                break;
            }
            case "enable": {
                this.checkUniqueMaterial();
                break;
            }
        }
    }

    private void checkData() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            HashSet<Object> set = new HashSet<Object>();
            for (int j = 0; j < obj.getDynamicObjectCollection("mftcontrolentry").size(); ++j) {
                if (((DynamicObject)obj.getDynamicObjectCollection("mftcontrolentry").get(j)).get("bizgroup") != null) {
                    set.add(((DynamicObject)obj.getDynamicObjectCollection("mftcontrolentry").get(j)).getDynamicObject("bizgroup").getPkValue());
                    continue;
                }
                set.add(null);
            }
            if (set.size() == obj.getDynamicObjectCollection("mftcontrolentry").size()) continue;
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u62e9\u4e00\u4e2a\u76f8\u540c\u4e1a\u52a1\u5206\u7ec4\u7684\u7269\u6599\u63a7\u5236\u7ec4\u3002", (String)"MaterialMftValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkUniqueMaterial() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject material = (DynamicObject)obj.get("masterid");
            DynamicObject createorg = (DynamicObject)obj.get("createorg");
            if (material == null || createorg == null) {
                return;
            }
            QFilter qFilter = new QFilter("masterid", "=", material.getPkValue());
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)createorg.getLong("id"));
            qFilter.and(baseDataFilter);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            DynamicObject queryone = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_materialmftinfo", (String)"createorg,masterid", (QFilter[])new QFilter[]{qFilter});
            if (queryone == null) continue;
            DynamicObject existsmaterial = queryone.getDynamicObject("masterid");
            DynamicObject existsorg = queryone.getDynamicObject("createorg");
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801%1$s +\u7ec4\u7ec7 %2$s \u5df2\u5b58\u5728\u3002", (String)"MaterialMftValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]), existsmaterial.getString("number"), existsorg.getString("name")));
        }
    }

    private void checkMaterial() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject material = (DynamicObject)obj.get("masterid");
            if (material == null) {
                return;
            }
            boolean isproduct = material.getBoolean("enableproduct");
            if (isproduct) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801%s \u5728\u3010\u7269\u6599\u3011\u57fa\u7840\u8d44\u6599\u4e2d\u4e1a\u52a1\u63a7\u5236\u672a\u8bbe\u7f6e\u53ef\u751f\u4ea7\u5c5e\u6027\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialMftValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]), material.getString("number")));
        }
    }

    private void checkUnit() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            Long buid;
            DynamicObject obj = this.dataEntities[i].getDataEntity();
            DynamicObject matDO = (DynamicObject)obj.get("masterid");
            DynamicObject mftUnitDO = (DynamicObject)obj.get("mftunit");
            if (mftUnitDO == null) continue;
            DynamicObject baseunitDO = matDO.getDynamicObject("baseunit");
            Long mid = matDO.getLong("id");
            List fixconunitlist = BaseDataServiceHelper.getAssistMUListResult((Long)mid, (Long)(buid = Long.valueOf(baseunitDO.getLong("id"))), (String)"1", (Boolean)Boolean.FALSE);
            if (fixconunitlist.contains(mftUnitDO.getLong("id"))) continue;
            this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u751f\u4ea7\u8ba1\u91cf\u5355\u4f4d\u4e0e\u57fa\u672c\u5355\u4f4d\u65e0\u6362\u7b97\u5173\u7cfb\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialMftValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }
}

