/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bd.sbd.enums.ErrorType;
import kd.bd.sbd.errorcode.SbdBaseErrorCode;
import kd.bd.sbd.errorcode.ScmErrorCode;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class OperatorGrpSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkSameUser(entity);
        }
    }

    private void checkSameUser(ExtendedDataEntity entity) {
        DynamicObjectCollection operCol = entity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (null == operCol || operCol.size() == 0) {
            return;
        }
        HashMap map = new HashMap();
        operCol.forEach(p -> {
            DynamicObject operator = p.getDynamicObject("operator");
            if (operator != null) {
                HashSet<Integer> index = map.get(operator.getPkValue()) == null ? new HashSet<Integer>() : (Set)map.get(operator.getPkValue());
                index.add(p.getInt("seq"));
                map.put(operator.getPkValue(), index);
            }
        });
        Collection sameIndexs = map.values();
        ScmErrorCode err = null;
        for (Set set : sameIndexs) {
            if (set.size() < 2) continue;
            err = new SbdBaseErrorCode().getErrorInfo(ErrorType.MSG_Same_Operator);
            String msg = String.format(err.getErrorCode().getMessage(), set);
            this.addMessage(entity, msg, ErrorLevel.Error);
        }
    }
}

