/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.bom;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.macc.common.helper.OrgHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public abstract class BaseManuorgListPlugin
extends AbstractListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private BeforeCreateListColumnsArgs beforeCreateListColumnsArgs = null;
    private static String changeManuorgFlag = "changeManuorgFlag";
    private List<IListColumn> iListColumns = null;
    private Boolean isDeleteFlag = false;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.filterContainerInitArgs = args;
        Iterator iterator = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        while (iterator.hasNext()) {
            String useOrg;
            FilterColumn filterColumn = (FilterColumn)iterator.next();
            String orgId = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith(String.format("%s.", this.getOrgFileName())) && kd.bos.util.StringUtils.isEmpty((String)orgId)) {
                List<ComboItem> comboItem = this.getORGComboItemList();
                orgId = comboItem == null || comboItem.isEmpty() ? "0" : comboItem.get(0).getValue();
                this.putOrgCache(orgId);
            }
            if (!fieldName.startsWith("manuorg.") || !StringUtils.isNotBlank((CharSequence)(useOrg = this.getPageCache().get(changeManuorgFlag))) || this.getPageCache().get("flag") != null && !this.isDeleteFlag.booleanValue() || OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(useOrg))) continue;
            iterator.remove();
        }
        this.getPageCache().put("flag", "notnull");
    }

    protected String getOrgFileName() {
        return "org";
    }

    private String getOrgCache() {
        String orgId = this.getPageCache().get(changeManuorgFlag);
        return orgId;
    }

    private void putOrgCache(String vals) {
        this.getPageCache().put(changeManuorgFlag, vals);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        Iterator iterator = customfilter.iterator();
        Boolean isMatchFileName = false;
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            List names = (List)map.get("FieldName");
            if (!String.format("%s.id", this.getOrgFileName()).equals(String.valueOf(names.get(0)))) continue;
            isMatchFileName = true;
            List vals = (List)map.get("Value");
            if (CollectionUtils.isEmpty((Collection)vals)) {
                this.putOrgCache("0");
            } else {
                this.putOrgCache(String.valueOf(vals.get(0)));
            }
            this.isDeleteFlag = true;
            if (this.beforeCreateListColumnsArgs != null) {
                this.beforeCreateListColumns(this.beforeCreateListColumnsArgs);
            }
            this.filterContainerInit(this.filterContainerInitArgs);
            this.isDeleteFlag = false;
        }
        if (!isMatchFileName.booleanValue()) {
            String createOrg = this.getView().getPageCache().get("createOrg");
            createOrg = kd.bos.util.StringUtils.isEmpty((String)createOrg) ? "0" : createOrg;
            this.putOrgCache(createOrg);
            this.isDeleteFlag = true;
            if (this.beforeCreateListColumnsArgs != null) {
                this.beforeCreateListColumns(this.beforeCreateListColumnsArgs);
            }
            this.filterContainerInit(this.filterContainerInitArgs);
            this.isDeleteFlag = false;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("refresh".equals(operateKey)) {
            this.isDeleteFlag = true;
            if (this.beforeCreateListColumnsArgs != null) {
                this.beforeCreateListColumns(this.beforeCreateListColumnsArgs);
            }
            this.isDeleteFlag = false;
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.beforeCreateListColumnsArgs = args;
        String orgId = this.getOrgCache();
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId));
            if (!OrgHelper.isOrgEnableMultiFactory((Long)Long.valueOf(orgId))) {
                this.iListColumns = this.hiddenListColumn(args, Sets.newHashSet((Object[])new String[]{"manuorg.number", "manuorg.name", "prdorg.number", "prdorg.name"}));
                this.getPageCache().put("notHidden", "N");
            }
            if (this.isDeleteFlag.booleanValue() && !orgEnableMultiFactory) {
                this.hiddenListColumn(args, Sets.newHashSet((Object[])new String[]{"manuorg.number", "manuorg.name", "prdorg.number", "prdorg.name"}));
                this.getPageCache().put("notHidden", "");
            } else if (this.isDeleteFlag.booleanValue() && orgEnableMultiFactory && "N".equals(this.getPageCache().get("notHidden"))) {
                if (this.iListColumns != null) {
                    args.setListColumns(this.iListColumns);
                }
                this.getPageCache().put("notHidden", "");
            } else if (this.isDeleteFlag.booleanValue()) {
                this.getPageCache().put("notHidden", "");
            }
        }
    }

    private List<IListColumn> hiddenListColumn(BeforeCreateListColumnsArgs beforeCreateListColumnsArgs, Set<String> hiddenKeys) {
        List listColumns = beforeCreateListColumnsArgs.getListColumns();
        ArrayList<IListColumn> retrunData = new ArrayList<IListColumn>();
        for (IListColumn listColumn2 : listColumns) {
            retrunData.add(listColumn2);
        }
        listColumns.removeIf(listColumn -> hiddenKeys.contains(listColumn.getListFieldKey()));
        beforeCreateListColumnsArgs.setListColumns(listColumns);
        return retrunData;
    }

    private List<ComboItem> getORGComboItemList() {
        return this.getOrgComboItems(this.getBillEntityId());
    }

    private String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public List<ComboItem> getOrgComboItems(String entityId) {
        List<Long> permCalOrgIds = BaseManuorgListPlugin.getCurrAccountOrg(entityId);
        QFilter filter = new QFilter("id", "in", permCalOrgIds);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    public static List<Long> getCurrAccountOrg(String entityId) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (allOrgIds != null && !allOrgIds.isEmpty()) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }
}

