/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.costtype;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.macc.common.constant.CommonConstant;
import kd.bd.macc.common.helper.CostTypeHelper;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bd.macc.common.utils.ListViewUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CostTypeListEditPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
        if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Object filterValue = args.getFilterValue("useorg.id");
        if (filterValue != null) {
            this.getPageCache().put("useorg", String.valueOf(filterValue));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
            return;
        }
        List listColumns = args.getListColumns();
        listColumns.forEach(e -> {
            String fieldKey = e.getListFieldKey();
            if ("type".equals(fieldKey)) {
                e.setColumnOrderAndFilter(false);
            }
        });
        ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)args, (Set)Sets.newHashSet((Object[])new String[]{"isupdate", "costtypeattr", "costtype.name"}));
    }

    public void afterCreateNewData(EventObject e) {
        String appNum = this.getView().getFormShowParameter().getAppId();
        if ("aca".equalsIgnoreCase(appNum)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"relation"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("relation".equals(operateKey)) {
            HashSet<Long> ids = new HashSet<Long>(10);
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            for (ListSelectedRow listSelectedDatum : listSelectedData) {
                ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
            }
            if (ids.size() != 1) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u4e2d\u4e00\u6761\u6570\u636e\u8fdb\u884c\u5173\u8054\u64cd\u4f5c\u3002", (String)"CostTypeListEditPlugin_0", (String)"bd-macc-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Long id : ids) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
                if ("1".equals(dynamicObject.getString("type"))) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u62df\u6210\u672c\u4e0d\u652f\u6301\u5173\u8054\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u6838\u7b97\u6210\u672c\u5173\u8054\u5bf9\u5e94\u7684\u6a21\u62df\u6210\u672c\u3002", (String)"CostTypeListEditPlugin_1", (String)"bd-macc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showCostTypeSetting(id);
            }
        }
    }

    private void showCostTypeSetting(Long id) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cad_costtypesetting");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("useorg", this.getPageCache().get("useorg"));
        map.put("type", dynamicObject.getString("type"));
        map.put("id", dynamicObject.getLong("id"));
        map.put("currey", dynamicObject.getLong("currency.id"));
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("costtypeentry");
        for (DynamicObject dyn : dynamicObjects) {
            String type = dyn.getString("costtypeattr");
            Long costId = dyn.getLong("costtype.id");
            if (CadEmptyUtils.isEmpty((Long)costId)) continue;
            if ("0".equals(type)) {
                map.put("accountcost", costId);
            }
            if ("1".equals(type)) {
                map.put("simulationcost", costId);
            }
            if (!"2".equals(type)) continue;
            map.put("plancost", costId);
        }
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "costTypeRelationBack"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        super.closedCallBack(e);
        if ("costTypeRelationBack".equals(e.getActionId()) && (returnData = (Map)e.getReturnData()) != null) {
            HashSet<Long> idSet = new HashSet<Long>(5);
            for (Map.Entry entry : returnData.entrySet()) {
                Long value = (Long)entry.getValue();
                if (CadEmptyUtils.isEmpty((Long)value)) continue;
                idSet.add(value);
            }
            HashSet<Long> simulationCostSet = new HashSet<Long>(2);
            this.clearRelationType((Long)returnData.get("id"), simulationCostSet);
            Map<Long, String> attrMap = this.getAttrMap(idSet);
            for (Long id : idSet) {
                HashSet<Long> ids = new HashSet<Long>(5);
                for (Long relationId : idSet) {
                    if (id.longValue() == relationId.longValue()) continue;
                    ids.add(relationId);
                }
                if (ids.isEmpty()) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
                if ("1".equals(dynamicObject.getString("type"))) {
                    simulationCostSet.add(id);
                    continue;
                }
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("costtypeentry");
                for (Long reId : ids) {
                    DynamicObject reObj = entry.addNew();
                    reObj.set("costtype", (Object)reId);
                    reObj.set("costtypeattr", (Object)attrMap.get(reId));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
            this.dealSimulationCostType(simulationCostSet);
            this.getView().invokeOperation("refresh");
        }
    }

    private void dealSimulationCostType(Set<Long> simulationCostSet) {
        if (!CadEmptyUtils.isEmpty(simulationCostSet)) {
            for (Long simulationCostId : simulationCostSet) {
                QFilter qFilter = new QFilter("costtypeentry.costtype", "=", (Object)simulationCostId);
                DynamicObject simulationCostDy = BusinessDataServiceHelper.loadSingle((Object)simulationCostId, (String)"cad_costtype");
                DynamicObjectCollection entry = simulationCostDy.getDynamicObjectCollection("costtypeentry");
                entry.clear();
                DynamicObjectCollection costTypeDc = QueryServiceHelper.query((String)"cad_costtype", (String)"id,type", (QFilter[])qFilter.toArray());
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costTypeDc)) {
                    for (DynamicObject reDy : costTypeDc) {
                        DynamicObject reObj = entry.addNew();
                        reObj.set("costtype", (Object)reDy.getLong("id"));
                        reObj.set("costtypeattr", (Object)reDy.getString("type"));
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{simulationCostDy});
            }
        }
    }

    private Map<Long, String> getAttrMap(Set<Long> idSet) {
        HashMap<Long, String> map = new HashMap<Long, String>(5);
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,type", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getLong("id"), dynamicObject.getString("type"));
        }
        return map;
    }

    private void clearRelationType(Long id, Set<Long> simulationCostSet) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"cad_costtype");
        DynamicObjectCollection relationTypes = dynamicObject.getDynamicObjectCollection("costtypeentry");
        for (DynamicObject relationType : relationTypes) {
            long reId = relationType.getLong("costtype.id");
            if (CadEmptyUtils.isEmpty((Long)reId)) continue;
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)reId, (String)"cad_costtype");
            DynamicObjectCollection entryCol = dyn.getDynamicObjectCollection("costtypeentry");
            if ("1".equals(dyn.getString("type"))) {
                simulationCostSet.add(reId);
                continue;
            }
            entryCol.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
        relationTypes.clear();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

