/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.costtype;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CostTypeSettingEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl("btnok");
        confirm.addClickListener((ClickListener)this);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            BasedataEdit accountCost = (BasedataEdit)this.getControl("accountcost");
            accountCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"0"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
            BasedataEdit planCost = (BasedataEdit)this.getControl("plancost");
            planCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"2"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
            BasedataEdit simulationCost = (BasedataEdit)this.getControl("simulationcost");
            simulationCost.addBeforeF7SelectListener(evt -> {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(new QFilter("type", "=", (Object)"1"));
                qFilters.add(new QFilter("currency", "=", params.get("currey")));
                QFilter baseDataFilter = CostTypeSettingEditPlugin.getCtrlBaseDataFilter(params);
                if (baseDataFilter != null) {
                    qFilters.add(baseDataFilter);
                }
            });
        }
    }

    private static QFilter getCtrlBaseDataFilter(Map<String, Object> params) {
        Object useOrg = params.get("useorg");
        Long currAcctOrg = useOrg != null ? Long.valueOf(Long.parseLong(String.valueOf(useOrg))) : Long.valueOf(RequestContext.getOrCreate().getOrgId());
        return BaseDataServiceHelper.getBaseDataFilter((String)"cad_costtype", (Long)currAcctOrg);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null) {
            Object planCost;
            Object simulationCost;
            IDataModel model = this.getModel();
            String type = params.get("type").toString();
            Object id = params.get("id");
            Object accountCost = params.get("accountcost");
            if (accountCost != null) {
                model.setValue("accountcost", accountCost);
                this.getView().setEnable(Boolean.valueOf(!this.costTypeHasUsed(Long.parseLong(accountCost.toString()), "0")), new String[]{"accountcost"});
            }
            if ((simulationCost = params.get("simulationcost")) != null) {
                model.setValue("simulationcost", simulationCost);
            }
            if ((planCost = params.get("plancost")) != null) {
                model.setValue("plancost", planCost);
                this.getView().setEnable(Boolean.valueOf(!this.costTypeHasUsed(Long.parseLong(planCost.toString()), "1")), new String[]{"plancost"});
            }
            if ("0".equals(type)) {
                model.setValue("accountcost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountcost"});
            } else if ("1".equals(type)) {
                model.setValue("simulationcost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"simulationcost"});
            } else {
                model.setValue("plancost", id);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"plancost"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            IDataModel model = this.getModel();
            HashMap<String, Long> returnMap = new HashMap<String, Long>(5);
            Map params = this.getView().getFormShowParameter().getCustomParams();
            Long id = (Long)params.get("id");
            returnMap.put("accountCost", model.getDataEntity().getLong("accountcost.id"));
            returnMap.put("planCost", model.getDataEntity().getLong("plancost.id"));
            returnMap.put("simulationCost", model.getDataEntity().getLong("simulationcost.id"));
            returnMap.put("id", id);
            if (this.uniquenessCheck(params)) {
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        }
    }

    private boolean uniquenessCheck(Map<String, Object> params) {
        IDataModel model = this.getModel();
        Long accountId = model.getDataEntity().getLong("accountcost.id");
        Long planId = model.getDataEntity().getLong("plancost.id");
        String type = params.get("type").toString();
        HashSet<Long> ids = new HashSet<Long>(5);
        ids.add(planId);
        ids.add(accountId);
        boolean checkPass = true;
        if (!CadEmptyUtils.isEmpty((Long)accountId) && !CadEmptyUtils.isEmpty((Long)planId)) {
            QFilter filter = null;
            filter = "0".equals(type) ? new QFilter("costtypeentry.costtype", "=", (Object)planId) : ("1".equals(type) ? new QFilter("costtypeentry.costtype", "in", ids) : new QFilter("costtypeentry.costtype", "=", (Object)accountId));
            filter.and("id", "not in", ids);
            filter.and("type", "!=", (Object)"1");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,number,name,type,costtypeentry.costtype.name costTypeName", (QFilter[])new QFilter[]{filter});
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                checkPass = false;
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    sb.append(String.format(ResManager.loadKDString((String)"%1$s\u5df2\u88ab\u3010%2$s/%3$s\u3011\u6210\u672c\u7c7b\u578b\u7ed1\u5b9a\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u6210\u672c\u7c7b\u578b\u3002", (String)"CostTypeSettingEditPlugin_0", (String)"bd-macc-formplugin", (Object[])new Object[0]), dynamicObject.getString("costTypeName"), dynamicObject.getString("number"), dynamicObject.getString("name")));
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)sb.toString(), (String)"uniquenessCheck", (String)"CostTypeSettingEditPlugin_1", (Object[])new Object[0]));
            }
        }
        return checkPass;
    }

    private boolean costTypeHasUsed(long costType, String type) {
        String entityNum = "";
        QFilter filter = null;
        if ("0".equals(type)) {
            entityNum = "cad_calceffectiveresult";
            filter = new QFilter("costtype", "=", (Object)costType);
        } else {
            entityNum = "sca_plancostcalclog";
            filter = new QFilter("plancosttype", "=", (Object)costType);
        }
        return QueryServiceHelper.exists((String)entityNum, (QFilter[])new QFilter[]{filter});
    }
}

