/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.element;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bd.macc.formplugin.element.ElementTreeListView;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ElementTreeListPlugin
extends StandardTreeListPlugin
implements AfterSearchClickListener {
    private static final String ID_ROOTNODE = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    protected static final String BARITEM_ASSIGNPERM = "baritem_assignperm";
    protected static final String BARITEM_COPYPERM = "btn_copyperm";
    protected static final String BARITEM_BATCHGROUP = "btn_batchgroup";
    protected static final String BARITEM_SHARE = "tbn_share";
    private ElementTreeListView treeListView = new ElementTreeListView();

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.treeListView);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        if (tree != null) {
            tree.focusNode(new TreeNode("", ID_ROOTNODE, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ElementTreeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), true));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addAfterSearchClickListener((AfterSearchClickListener)this);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
    }

    public void treeToolbarClick(EventObject eo) {
        super.treeToolbarClick(eo);
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        if (focusNode == null || !ID_ROOTNODE.equals(focusNode.get("id"))) {
            // empty if block
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        boolean isExists;
        TreeView.TreeState treeState;
        Map focusNode;
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        e.setChildNodes(this.loadAppNodes(root.getId()));
        TreeView treeView = (TreeView)this.getControl("treeview");
        if (treeView != null && (focusNode = (treeState = treeView.getTreeState()).getFocusNode()) != null && !ID_ROOTNODE.equals(focusNode.get("id")) && !(isExists = QueryServiceHelper.exists((String)"cad_element", focusNode.get("id")))) {
            treeView.focusNode(new TreeNode("", ID_ROOTNODE, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ElementTreeListPlugin_0", (String)"bos-permission-formplugin", (Object[])new Object[0]), true));
        }
    }

    private List<TreeNode> loadAppNodes(String currNodeId) {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(16);
        List<TreeNode> cloudNode4 = this.getReTreeData(currNodeId);
        for (TreeNode node : cloudNode4) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return cloudNode4;
    }

    private List<TreeNode> getReTreeData(String currNodeId) {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        DynamicObjectCollection eles = QueryServiceHelper.query((String)"cad_element", (String)"id,number,name", (QFilter[])new QFilter[0], (String)"number asc");
        for (DynamicObject ele : eles) {
            TreeNode node = new TreeNode();
            node.setText(ele.getString("name"));
            node.setParentid(currNodeId);
            node.setId(ele.getString("id"));
            cloudNode.add(node);
        }
        return cloudNode;
    }

    protected QFilter nodeClickFilter() {
        QFilter resultFilter = super.nodeClickFilter();
        TreeView userGroupTree = (TreeView)this.getControl("treeview");
        String focusNodeId = userGroupTree.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusNodeId) || ID_ROOTNODE.equals(focusNodeId)) {
            return null;
        }
        QFilter groupFilter = new QFilter("type", "=", (Object)"-1");
        DynamicObjectCollection details = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{new QFilter("element", "=", (Object)Long.parseLong(focusNodeId))});
        if (details == null || details.isEmpty()) {
            return this.addFilter(resultFilter, groupFilter);
        }
        ArrayList subIds = new ArrayList();
        details.forEach(s -> subIds.add(s.get("subelement")));
        if (Utils.isListNotEmpty(subIds)) {
            groupFilter = new QFilter("id", "in", subIds);
        }
        return this.addFilter(resultFilter, groupFilter);
    }

    private QFilter addFilter(QFilter resultFilter, QFilter groupFilter) {
        resultFilter = resultFilter == null ? groupFilter : resultFilter.and(groupFilter);
        return resultFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("disable".equals(operate.getOperateKey())) {
            ListView view = (ListView)this.getView();
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            if (selectedRows == null || selectedRows.size() == 0) {
                return;
            }
            Object[] pkValues = selectedRows.getPrimaryKeyValues();
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"cad_subelement", (String)"id,number,name,defaultvalue", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (!dynamicObject.getBoolean("defaultvalue")) continue;
                args.setCancel(true);
                String tip = String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\u3002\u6210\u672c\u5b50\u8981\u7d20\u201c%1$s/%2$s\u201d\u52fe\u9009\u4e86\uff1a\u9ed8\u8ba4\u503c\uff0c\u8bf7\u5207\u6362\u9ed8\u8ba4\u503c\uff0c\u518d\u8fdb\u884c\u7981\u7528\u3002", (String)"ElementTreeListPlugin_2", (String)"bd-macc-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), dynamicObject.getString("name"));
                this.getView().showTipNotification(tip);
                return;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        super.beforeItemClick(e);
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        String itemKey = e.getItemKey();
        if (focusNode != null && ID_ROOTNODE.equals(focusNode.get("id")) && "tblnew".equals(itemKey)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u6210\u672c\u8981\u7d20\u503c\u3002", (String)"ElementTreeListPlugin_1", (String)"bd-macc-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        switch (e.getItemKey()) {
            case "bar_delete": {
                break;
            }
            case "tblrefresh": {
                BillList billListTemp = (BillList)this.getControl("billlistap");
                billListTemp.clearSelection();
                billListTemp.refreshData();
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillList billList;
        ListSelectedRow row;
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        Map<String, Object> focusNode = this.getTreeData();
        Long elementId = null;
        if (focusNode != null && !ID_ROOTNODE.equals(focusNode.get("id"))) {
            elementId = Optional.ofNullable(focusNode.get("id")).map(s -> Long.parseLong(s.toString())).orElse(0L);
        }
        if (elementId != null) {
            DynamicObject ele = BusinessDataServiceHelper.loadSingle(elementId, (String)"cad_element");
            String type = ele.getString("type");
            Object elementtype = ele.getDynamicObject("elementtype").getPkValue();
            bsp.setCustomParam("element", (Object)elementId);
            bsp.setCustomParam("elementtype", elementtype);
            bsp.setCustomParam("type", (Object)type);
        }
        if ((row = (billList = (BillList)this.getControl("billlistap")).getCurrentSelectedRowInfo()) != null) {
            bsp.setCustomParam("subId", row.getPrimaryKeyValue());
            if (!"".equals(bsp.getCustomParam("type"))) {
                DynamicObject subEle = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cad_subelement");
                String type = subEle.getString("type");
                bsp.setCustomParam("type", (Object)type);
            }
        }
        bsp.getOpenStyle().setShowType(ShowType.Modal);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        Map<String, Object> focusNode = this.getTreeData();
        Long elementId = null;
        String type = "";
        if (focusNode != null && !ID_ROOTNODE.equals(focusNode.get("id"))) {
            elementId = Optional.ofNullable(focusNode.get("id")).map(s -> Long.parseLong(s.toString())).orElse(0L);
        }
        if (elementId != null) {
            DynamicObject ele = QueryServiceHelper.queryOne((String)"cad_element", (String)"type", (QFilter[])new QFilter[]{new QFilter("id", "=", elementId)});
            String string = type = ele == null ? "" : ele.getString("type");
        }
        if ("".equals(type) || type.equals("002")) {
            return;
        }
        List listColumns = o.getListColumns();
        listColumns = o.getListColumns();
        for (IListColumn columns : listColumns) {
            if (!columns.toString().equals("supmaterielcount")) continue;
            columns.setVisible(0);
        }
    }

    private Map<String, Object> getTreeData() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        if (treeView == null) {
            return null;
        }
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        return focusNode;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            // empty if block
        }
    }

    public void click(SearchClickEvent arg0) {
    }
}

