/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class CustomerUserList
extends AbstractTreeListPlugin {
    private Log log = LogFactory.getLog(CustomerUserList.class);
    private static final String USER_TYPE = "usertype";
    private static final String BTN_DELETE = "tbldel";
    private static final String BTN_DODEL = "dodel";
    private static final String DELETEDRPUSER_CALLBACK_MARK = "deleteDrpUserCallBack";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm_delete_drp_user";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter(USER_TYPE, "like", (Object)"%4%").or(new QFilter(USER_TYPE, "like", (Object)"%2%")));
        e.setOrderBy("createtime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "delete": {
                this.drpCustomerUserDeleteHandler(e);
            }
        }
    }

    private void drpCustomerUserDeleteHandler(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        ListSelectedRowCollection selectedData = e.getListSelectedData();
        int size = selectedData.size();
        ArrayList<Object> primaryKeys = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            primaryKeys.add(selectedData.get(i).getPrimaryKeyValue());
        }
        DynamicObjectCollection drpUsers = QueryServiceHelper.query((String)"drp_customer_user", (String)"customerinfo,user,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", primaryKeys)});
        ArrayList<Long> sysUserIds = new ArrayList<Long>(drpUsers.size());
        for (DynamicObject drpUser : drpUsers) {
            sysUserIds.add(drpUser.getLong("user"));
        }
        DynamicObjectCollection customers = QueryServiceHelper.query((String)"dbd_drp_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("sysuser", "in", sysUserIds), new QFilter("owner", ">", (Object)0)}, (String)"id", (int)1);
        if (!CollectionUtils.isEmpty((Collection)customers)) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(DELETEDRPUSER_CALLBACK_MARK, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u6e20\u9053\u7528\u6237\uff0c\u662f\u5426\u5220\u9664\uff1f", (String)"CustomerUserList_0", (String)"bd-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, callBackListener);
                e.setCancel(true);
            }
        }
        operate.getOption().setVariableValue(OPPARAM_AFTERCONFIRM, "true");
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "deleteDrpUserCallBack": {
                this.doDeleteDrpCustomerUser(e, result);
            }
        }
    }

    private void doDeleteDrpCustomerUser(MessageBoxClosedEvent e, MessageBoxResult result) {
        if (MessageBoxResult.Yes.equals((Object)result)) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation(BTN_DODEL, operateOption);
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = e.getOperateKey()) {
            case "dodel": 
            case "delete": {
                if (!e.getOperationResult().isSuccess()) break;
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"CustomerUserList_1", (String)"bd-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

