/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.list;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PbdStrategyHyperLinkList
extends AbstractListPlugin {
    private static final Map<String, String> PRO_SCHEMA_MAP = new HashMap<String, String>();

    public void billListHyperLinkClick(HyperLinkClickArgs hyperClick) {
        super.billListHyperLinkClick(hyperClick);
        HyperLinkClickEvent event = hyperClick.getHyperLinkClickEvent();
        if (event instanceof BillListHyperLinkClickEvent && event.getSource() instanceof BillList) {
            BillList billList = (BillList)event.getSource();
            String billFormId = billList.getBillFormId();
            ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)event).getCurrentRow();
            Object entryPrimaryKeyValue = currentRow.getEntryPrimaryKeyValue();
            Object primaryKeyValue = currentRow.getPrimaryKeyValue();
            String fieldName = event.getFieldName();
            switch (billFormId) {
                case "bd_centralpurchaselist": {
                    if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"orgsch_name")) break;
                    hyperClick.setCancel(true);
                    this.showDetail(billFormId, entryPrimaryKeyValue, "entryentity.orgsch", "entryentity.id");
                    break;
                }
                case "bd_purstrategy": 
                case "bd_srcstrategy": {
                    if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)"schema_name")) break;
                    hyperClick.setCancel(true);
                    this.showDetail(billFormId, primaryKeyValue, "schema", "id");
                    break;
                }
            }
        }
    }

    private void showDetail(String billFormId, Object primaryKeyValue, String selectField, String entryId) {
        Object orgsch;
        String schemaEntity = PRO_SCHEMA_MAP.get(billFormId);
        DynamicObject info = QueryServiceHelper.queryOne((String)billFormId, (String)selectField, (QFilter[])new QFilter[]{new QFilter(entryId, "=", primaryKeyValue)});
        if (info != null && (orgsch = info.get(selectField)) != null) {
            BillShowParameter param = new BillShowParameter();
            param.setFormId(schemaEntity);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setStatus(OperationStatus.VIEW);
            param.setPkId(orgsch);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    static {
        PRO_SCHEMA_MAP.put("bd_centralpurchaselist", "bd_purchaseorg_sch");
        PRO_SCHEMA_MAP.put("bd_purstrategy", "bd_purstrategy_sch");
        PRO_SCHEMA_MAP.put("bd_srcstrategy", "bd_srcstrategy_sch");
    }
}

