/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.consistency;

import com.alibaba.fastjson.JSONArray;
import java.util.Map;
import kd.bd.master.mservice.MasterDataStandardService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UpdateMasterDataGroupService
extends EventualConsistencyService {
    private static Log logger = LogFactory.getLog(UpdateMasterDataGroupService.class);

    public DtxResponse execute(Object param, Object lastParam) throws Exception {
        logger.info("call UpdateMasterDataGroupService");
        CommonDtxResponse result = new CommonDtxResponse();
        if (!(param instanceof CommonParam)) {
            throw new KDBizException("invalid parameter");
        }
        Map map = ((CommonParam)param).getAll();
        Object entityParam = map.get("entity");
        Object dataIdParam = map.get("dataIds");
        Object groupIdParam = map.get("groupId");
        Object groupStrandIdParam = map.get("groupStrandId");
        if (StringUtils.isBlank(entityParam) || dataIdParam == null || groupIdParam == null || groupStrandIdParam == null) {
            throw new KDBizException("parameter should not be null");
        }
        String entity = (String)entityParam;
        JSONArray dataIds = (JSONArray)dataIdParam;
        Long groupId = Long.parseLong(groupIdParam.toString());
        Long groupStrandId = Long.parseLong(groupStrandIdParam.toString());
        DynamicObject[] datas = new DynamicObject[dataIds.size()];
        DynamicObject data = null;
        logger.info("call UpdateMasterDataGroupService:dataIdSize=" + dataIds.size() + ",groupId=" + groupId + ",groupStrandId=" + groupStrandId);
        int len = dataIds.size();
        for (int i = 0; i < len; ++i) {
            data = BusinessDataServiceHelper.newDynamicObject((String)entity);
            data.set("id", dataIds.get(i));
            datas[i] = data;
        }
        MasterDataStandardService masterDataStandardSrv = new MasterDataStandardService();
        ApiResult updateGrpResult = masterDataStandardSrv.updateGroupStandard(datas, groupId, groupStrandId);
        boolean isSuccess = updateGrpResult.getSuccess();
        String msg = updateGrpResult.getMessage();
        if (!isSuccess) {
            throw new KDBizException(msg);
        }
        result.put((Object)"success", (Object)isSuccess);
        result.put((Object)"message", (Object)msg);
        return result;
    }
}

