/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.update;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AddressDataUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID,FCREATEORG,FSUPPLIER,FCUSTOMER,FSUPPLIERID,FCUSTOMERID FROM T_BD_SUPPLIERADDRESS");
        sql.append(" WHERE FSUPPLIER=0 AND FCUSTOMER=0");
        DBRoute dbRoute = new DBRoute(dbKey);
        DataSet ds = DB.queryDataSet((String)(this.getClass().getName() + UUID.randomUUID()), (DBRoute)dbRoute, (String)sql.toString(), null);
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        ArrayList<Long> customerIds = new ArrayList<Long>();
        DataSet dsCopy = ds.copy();
        if (ds != null) {
            UpgradeResult supplierid;
            Object row2;
            SqlParameter[] params = null;
            ArrayList<SqlObject> sqlObjs = new ArrayList<SqlObject>();
            ArrayList<SqlObject> sqlObjs1 = new ArrayList<SqlObject>();
            ArrayList<SqlObject> sqlObjs2 = new ArrayList<SqlObject>();
            for (Object row2 : ds) {
                String customerid = row2.getString("FCUSTOMERID") == null ? " " : row2.getString("FCUSTOMERID");
                String string = supplierid = row2.getString("FSUPPLIERID") == null ? " " : row2.getString("FSUPPLIERID");
                if (!"".equals(customerid)) {
                    params = new SqlParameter[]{new SqlParameter("FCUSTOMERID", -9, (Object)customerid), new SqlParameter("FID", -5, (Object)row2.getLong("FID"))};
                    sqlObjs.add(new SqlObject("UPDATE T_BD_SUPPLIERADDRESS SET FCUSTOMER=? WHERE FID=? ", params));
                    customerIds.add(Long.parseLong(customerid));
                }
                if ("".equals(supplierid)) continue;
                params = new SqlParameter[]{new SqlParameter("FSUPPLIERID", -9, supplierid), new SqlParameter("FID", -5, (Object)row2.getLong("FID"))};
                sqlObjs2.add(new SqlObject("UPDATE T_BD_SUPPLIERADDRESS SET FSUPPLIER=? WHERE FID=? ", params));
                supplierIds.add(Long.parseLong((String)supplierid));
            }
            TXHandle h = TX.required((String)this.getClass().getName());
            row2 = null;
            try {
                try {
                    ArrayList<SqlParameter[]> paramList;
                    if (sqlObjs.size() > 0) {
                        paramList = new ArrayList<SqlParameter[]>(sqlObjs.size());
                        for (SqlObject sqlObject : sqlObjs) {
                            paramList.add(sqlObject.getParams());
                        }
                        DB.executeBatch((DBRoute)dbRoute, (String)((SqlObject)sqlObjs.get(0)).getSql(), paramList);
                    }
                    if (sqlObjs2.size() > 0) {
                        paramList = new ArrayList(sqlObjs2.size());
                        for (SqlObject sqlObject : sqlObjs2) {
                            paramList.add(sqlObject.getParams());
                        }
                        DB.executeBatch((DBRoute)dbRoute, (String)((SqlObject)sqlObjs2.get(0)).getSql(), paramList);
                    }
                }
                catch (Throwable e) {
                    h.markRollback();
                    result.setSuccess(false);
                    result.setErrorInfo("database execution failed,errorInfo" + e.getMessage());
                    result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                    supplierid = result;
                    if (h != null) {
                        if (row2 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable sqlObject) {
                                ((Throwable)row2).addSuppressed(sqlObject);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return supplierid;
                }
            }
            catch (Throwable e) {
                row2 = e;
                throw e;
            }
            finally {
                if (h != null) {
                    if (row2 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable e) {
                            ((Throwable)row2).addSuppressed(e);
                        }
                    } else {
                        h.close();
                    }
                }
            }
            Map<Long, Long> supplierMap = null;
            Map<Long, Long> customerMap = null;
            if (customerIds.size() > 0) {
                customerMap = this.getCustomerOrg(customerIds);
            }
            if (supplierIds.size() > 0) {
                supplierMap = this.getSupplierOrg(supplierIds);
            }
            for (Row row3 : dsCopy) {
                String supplierid2;
                String customerid = row3.getString("FCUSTOMERID") == null ? " " : row3.getString("FCUSTOMERID");
                String string = supplierid2 = row3.getString("FSUPPLIERID") == null ? " " : row3.getString("FSUPPLIERID");
                if (!"".equals(customerid)) {
                    params = new SqlParameter[]{new SqlParameter("FCREATEORG", -5, (Object)customerMap.get(Long.parseLong(customerid))), new SqlParameter("FID", -5, (Object)row3.getLong("FID"))};
                    sqlObjs1.add(new SqlObject("UPDATE T_BD_SUPPLIERADDRESS SET FCREATEORG=? WHERE FID=? ", params));
                }
                if ("".equals(supplierid2)) continue;
                params = new SqlParameter[]{new SqlParameter("FCREATEORG", -5, (Object)supplierMap.get(Long.parseLong(supplierid2))), new SqlParameter("FID", -5, (Object)row3.getLong("FID"))};
                sqlObjs1.add(new SqlObject("UPDATE T_BD_SUPPLIERADDRESS SET FCREATEORG=? WHERE FID=? ", params));
            }
            try (TXHandle h2 = TX.required((String)this.getClass().getName());){
                try {
                    if (sqlObjs.size() > 0) {
                        ArrayList<SqlParameter[]> paramList = new ArrayList<SqlParameter[]>(sqlObjs.size());
                        for (SqlObject sqlObj : sqlObjs1) {
                            paramList.add(sqlObj.getParams());
                        }
                        DB.executeBatch((DBRoute)dbRoute, (String)((SqlObject)sqlObjs1.get(0)).getSql(), paramList);
                    }
                }
                catch (Throwable e) {
                    h2.markRollback();
                    result.setSuccess(false);
                    result.setErrorInfo("database execution failed,errorInfo" + e.getMessage());
                    result.setLog("database execution failed,errorMsgInfo" + e.getMessage());
                    UpgradeResult upgradeResult = result;
                    if (h2 != null) {
                        if (var19_22 != null) {
                            try {
                                h2.close();
                            }
                            catch (Throwable throwable) {
                                var19_22.addSuppressed(throwable);
                            }
                        } else {
                            h2.close();
                        }
                    }
                    return upgradeResult;
                }
            }
            result.setLog("update address end.");
        }
        result.setSuccess(true);
        return result;
    }

    private Map<Long, Long> getCustomerOrg(List<Long> customerIds) {
        int pointsDataLimit = 1000;
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ArrayList<Long> newList = new ArrayList<Long>(pointsDataLimit);
        for (int i = 0; i < customerIds.size(); ++i) {
            newList.add(customerIds.get(i));
            if (pointsDataLimit != newList.size() && i != customerIds.size() - 1) continue;
            Map datas = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("id", "in", newList)});
            if (datas != null && datas.size() > 0) {
                for (Map.Entry m : datas.entrySet()) {
                    map.put(Long.parseLong(m.getKey().toString()), ((DynamicObject)m.getValue()).getDynamicObject("createorg") == null ? 0L : ((DynamicObject)m.getValue()).getDynamicObject("createorg").getLong("id"));
                }
            }
            newList.clear();
        }
        return map;
    }

    private Map<Long, Long> getSupplierOrg(List<Long> supplierIds) {
        int pointsDataLimit = 1000;
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        ArrayList<Long> newList = new ArrayList<Long>(pointsDataLimit);
        for (int i = 0; i < supplierIds.size(); ++i) {
            newList.add(supplierIds.get(i));
            if (pointsDataLimit != newList.size() && i != supplierIds.size() - 1) continue;
            Map datas = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", newList)});
            if (datas != null && datas.size() > 0) {
                for (Map.Entry m : datas.entrySet()) {
                    map.put(Long.parseLong(m.getKey().toString()), ((DynamicObject)m.getValue()).getDynamicObject("createorg") == null ? 0L : ((DynamicObject)m.getValue()).getDynamicObject("createorg").getLong("id"));
                }
            }
            newList.clear();
        }
        return map;
    }
}

