/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.update;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class TaxRateUpgradeService
implements IUpgradeService {
    private Log log = LogFactory.getLog(TaxRateUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String message = "";
        try {
            message = this.update();
        }
        catch (Exception e) {
            this.log.error("update data fail.errorMsgInfo:" + e.getMessage());
            result.setSuccess(false);
            result.setLog("data update fail." + e.getMessage());
            return result;
        }
        result.setSuccess(true);
        result.setLog(message);
        return result;
    }

    private String update() {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(" select a.fid as TAXRATEID ");
        selectSql.append(" from t_bd_taxrate a,t_bd_taxationsys b ");
        selectSql.append(" where a.fcountry = b.fcountryid and b.fcountryid  is not null and b.fcountryid !=0 and b.fenable = '1'and a.ftaxationsys != b.fid ");
        selectSql.append(" group by a.fid having count(1) = 1 ");
        List taxrateids = (List)DB.query((DBRoute)DBRoute.basedata, (String)selectSql.toString(), (ResultSetHandler)new ResultSetHandler<List<Object>>(){

            public List<Object> handle(ResultSet resultSet) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>(32);
                while (resultSet.next()) {
                    list.add(resultSet.getLong("TAXRATEID"));
                }
                return list;
            }
        });
        if (ObjectUtils.isEmpty((Object)taxrateids)) {
            return String.format("dataUpdate total:%s ,success: %s, fail: %s ", 0, 0, 0);
        }
        SqlBuilder selSql = new SqlBuilder();
        selSql.append(" select a.fid as TAXRATEID, b.fid as TAXATIONSYSID", new Object[0]);
        selSql.append(" from t_bd_taxrate a,t_bd_taxationsys b ", new Object[0]);
        selSql.append(" where a.fcountry = b.fcountryid and b.fcountryid  is not null and b.fcountryid !=0 and b.fenable = '1'and a.ftaxationsys != b.fid ", new Object[0]);
        selSql.appendIn(" and a.fid", taxrateids);
        try (DataSet ds = DB.queryDataSet((String)(this.getClass().getCanonicalName() + ".beforeExecuteSqlWithResult"), (DBRoute)DBRoute.basedata, (SqlBuilder)selSql);){
            for (Row row : ds) {
                Object taxationsysid = row.get("TAXATIONSYSID");
                Object taxrateid = row.get("TAXRATEID");
                paramList.add(new Object[]{taxationsysid, taxrateid});
            }
        }
        String insertSql = "update t_bd_taxrate set ftaxationsys = ?  where fid = ? ";
        int[] total = DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramList);
        return String.format("dataUpdate total:%s ,success: %s, fail: %s ", taxrateids.size(), total.length, taxrateids.size() - total.length);
    }
}

