/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bd.macc.common.helper.CadLangHelper;
import kd.bd.macc.common.helper.CostTypeHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BomRouterHelper {
    public static String getMatBizCtrl(DynamicObject mat) {
        String bizCtrlName = "";
        if (mat.getBoolean("enableproduct")) {
            bizCtrlName = String.format(ResManager.loadKDString((String)"%s\u53ef\u751f\u4ea7,", (String)"BomRouterHelper_0", (String)"macc-cad-common", (Object[])new Object[0]), bizCtrlName);
        }
        if (mat.getBoolean("enablepur")) {
            bizCtrlName = String.format(ResManager.loadKDString((String)"%s\u53ef\u91c7\u8d2d,", (String)"BomRouterHelper_1", (String)"macc-cad-common", (Object[])new Object[0]), bizCtrlName);
        }
        if (StringUtils.isNotEmpty((String)bizCtrlName)) {
            return bizCtrlName.substring(0, bizCtrlName.length() - 1);
        }
        return bizCtrlName;
    }

    public static DynamicObject[] getAllCostTypes() {
        return CostTypeHelper.getCostTypesBy(null);
    }

    public static boolean isAnalogCostType(String costTypeId) {
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", (Object)costTypeId), new QFilter("type", "=", (Object)"1")};
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])qfilters);
    }

    public static boolean isEnableMatversion(DynamicObject mat) {
        if (mat == null) {
            return false;
        }
        return mat.getBoolean("isenablematerialversion");
    }

    public static boolean isEnableAuxprop(DynamicObject mat) {
        if (mat == null || !mat.getBoolean("isuseauxpty")) {
            return false;
        }
        if (mat != null && mat.getBoolean("isuseauxpty")) {
            DynamicObjectCollection auxprops = mat.getDynamicObjectCollection("auxptyentry");
            if (auxprops == null) {
                return false;
            }
            for (DynamicObject auxprop : auxprops) {
                if (!auxprop.getBoolean("isaffectprice")) continue;
                return true;
            }
        }
        return false;
    }

    private static Boolean isAuxptyMustInput(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String validateAuxptyMustInput(DynamicObject mat, DynamicObject auxpty) {
        if (mat == null) {
            return null;
        }
        Boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
        if (!isUseAuxpty.booleanValue()) {
            return null;
        }
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        boolean isAuxprop = false;
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (!price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
            isAuxprop = true;
        }
        if (isAuxprop) {
            if (auxpty == null) {
                return CadLangHelper.getAuptyMustinput();
            }
            Boolean notAuxpty = BomRouterHelper.isAuxptyMustInput(auxptyIdSet, (String)auxpty.get(1));
            if (notAuxpty.booleanValue()) {
                return CadLangHelper.getAuptyMustinput();
            }
        }
        return null;
    }
}

