/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashSet;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CalcDimenHelper {
    private static final Log logger = LogFactory.getLog(CalcDimenHelper.class);

    public static Long getAffectAuxpty(Object material, Object auxpty) {
        if (material == null || auxpty == null) {
            return 0L;
        }
        DynamicObject matObj = null;
        if (material instanceof Long) {
            matObj = CalcDimenHelper.getMaterialById(Long.parseLong(material.toString()));
        } else if (material instanceof DynamicObject) {
            matObj = (DynamicObject)material;
        }
        if (matObj != null && !matObj.getBoolean("isuseauxpty")) {
            return 0L;
        }
        DynamicObject auxptyObj = null;
        if (auxpty instanceof Long) {
            auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(auxpty.toString()), (String)"bd_flexauxprop");
        } else if (auxpty instanceof DynamicObject) {
            auxptyObj = (DynamicObject)auxpty;
        }
        return CalcDimenHelper.getEffectCostAuxpty(matObj, auxptyObj);
    }

    private static Long getEffectCostAuxpty(DynamicObject mat, DynamicObject srcAuxpty) {
        DynamicObject[] auxproperty;
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat == null ? "null" : mat.getPkValue(), srcAuxpty == null ? "null" : srcAuxpty.getPkValue());
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        if (srcAuxpty == null || mat == null) {
            return 0L;
        }
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
        }
        if (CadEmptyUtils.isEmpty(isaffectprices)) {
            return 0L;
        }
        if (CadEmptyUtils.isEmpty(auxptyIdSet)) {
            return srcAuxpty.getLong("id");
        }
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027-\u79fb\u9664\u4e0d\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat.getPkValue(), srcAuxpty.getPkValue());
        String auxStr = (String)srcAuxpty.get(1);
        JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
        for (DynamicObject aux : auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)})) {
            auxptyJsonObject.remove((Object)aux.getString("flexfield"));
        }
        if (auxptyJsonObject.size() == 0) {
            return 0L;
        }
        String jsonString = auxptyJsonObject.toJSONString();
        DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_flexauxprop", (String)"id", (QFilter[])new QFilter[]{new QFilter("value", "=", (Object)jsonString)});
        if (auxptyObj != null) {
            return auxptyObj.getLong("id");
        }
        auxptyObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_flexauxprop");
        auxptyObj.set("id", (Object)DB.genLongId((String)"t_bd_flexauxpropdata"));
        auxptyObj.set("value", (Object)jsonString);
        auxptyObj.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{auxptyObj});
        return auxptyObj.getLong("id");
    }

    public static DynamicObject getMaterialById(Long matId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)matId, (String)"bd_material");
    }
}

