/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ItemInfoSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("barcodenumber");
        fieldKeys.add("barcode");
        fieldKeys.add("currency");
        fieldKeys.add("retailprice");
        fieldKeys.add("memberprice");
        fieldKeys.add("retailunit");
        fieldKeys.add("material");
        fieldKeys.add("materialmasterid");
        fieldKeys.add("attrname");
        fieldKeys.add("attrnumber");
        fieldKeys.add("easnumber");
        fieldKeys.add("attrvalue");
        fieldKeys.add("hasattr");
        fieldKeys.add("itemclassentity.classstandardid");
        fieldKeys.add("itemclassentity.goodsclasssid");
        fieldKeys.add("itemclass");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List dataList = e.getValidExtDataEntities();
        DynamicObject item = null;
        DynamicObject material = null;
        for (ExtendedDataEntity data : dataList) {
            item = data.getDataEntity();
            material = item.getDynamicObject("material");
            if (material == null) continue;
            Object materialMasterId = material.get("masterid");
            item.set("materialmasterid", materialMasterId);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        DynamicObject goodsClassDynObj = null;
        DynamicObject classStandardDynObj = null;
        DynamicObjectCollection entryItemClassColl = null;
        ArrayList<DynamicObject> itemClassObjList = new ArrayList<DynamicObject>();
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject item = itemDynObjs[i];
            entryItemClassColl = item.getDynamicObjectCollection("itemclassentity");
            if (!CommonUtils.isNull((Object)entryItemClassColl)) {
                for (DynamicObject entryClassDynObj : entryItemClassColl) {
                    if (CommonUtils.isNull((Object)entryClassDynObj.getDynamicObject("goodsclasssid"))) continue;
                    itemClassObjList.add(entryClassDynObj);
                    classStandardDynObj = entryClassDynObj.getDynamicObject("classstandardid");
                    if (classStandardDynObj.getLong("id") == 1L) {
                        goodsClassDynObj = entryClassDynObj.getDynamicObject("goodsclasssid");
                    }
                    if (goodsClassDynObj != null) continue;
                    goodsClassDynObj = entryClassDynObj.getDynamicObject("goodsclasssid");
                }
                entryItemClassColl.clear();
                for (DynamicObject itemClassObj : itemClassObjList) {
                    entryItemClassColl.add((Object)itemClassObj);
                }
                item.set("itemclassentity", (Object)entryItemClassColl);
            }
            item.set("itemclass", goodsClassDynObj);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] itemDynObjs = e.getDataEntities();
        if (itemDynObjs == null || itemDynObjs.length <= 0) {
            return;
        }
        HashSet<Object> itemIdSet = new HashSet<Object>();
        for (int i = 0; i < itemDynObjs.length; ++i) {
            DynamicObject item = itemDynObjs[i];
            boolean hasattr = item.getBoolean("hasattr");
            if (hasattr) {
                this.saveAttrVaule(item);
                continue;
            }
            itemIdSet.add(item.getPkValue());
        }
        if (itemIdSet.size() > 0) {
            QFilter q = new QFilter("item", "in", itemIdSet);
            DeleteServiceHelper.delete((String)"mdr_item_attrvalue", (QFilter[])q.toArray());
        }
    }

    private void saveAttrVaule(DynamicObject item) {
        DynamicObjectCollection attrEntry = item.getDynamicObjectCollection("attrvalueentry");
        DynamicObjectCollection itemAttrs = item.getDynamicObjectCollection("attrentry");
        int attrsSize = 0;
        if (itemAttrs != null) {
            attrsSize = itemAttrs.size();
        }
        HashSet<Object> attrvalueIds = new HashSet<Object>();
        ArrayList<DynamicObject> newItemAttrvalues = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> oldItemAttrvalues = new ArrayList<DynamicObject>();
        int seq = 0;
        for (DynamicObject attrs : attrEntry) {
            String attrName = attrs.getString("attrname");
            String attrNumber = attrs.getString("attrnumber");
            String easNumber = attrs.getString("easnumber");
            ++seq;
            DynamicObject attrvalue = attrs.getDynamicObject("attrvalue");
            if (attrvalue != null) {
                Object attrvalueId = attrvalue.get("id");
                attrvalueIds.add(attrvalueId);
                DynamicObject itemAttrvalue = BusinessDataServiceHelper.loadSingle((Object)attrvalueId, (String)"mdr_item_attrvalue", (String)"id,attrseq,easnumber");
                itemAttrvalue.set("attrseq", (Object)seq);
                itemAttrvalue.set("easnumber", (Object)easNumber);
                oldItemAttrvalues.add(itemAttrvalue);
                continue;
            }
            DynamicObject itemAttrvalue = BusinessDataServiceHelper.newDynamicObject((String)"mdr_item_attrvalue");
            itemAttrvalue.set("name", (Object)attrName);
            itemAttrvalue.set("number", (Object)attrNumber);
            itemAttrvalue.set("easnumber", (Object)easNumber);
            itemAttrvalue.set("item", item.get("id"));
            itemAttrvalue.set("attrseq", (Object)seq);
            DynamicObjectCollection attrentity = itemAttrvalue.getDynamicObjectCollection("attrentity");
            for (int i = 0; i < attrsSize; ++i) {
                DynamicObject attr = attrentity.addNew();
                attr.set("attrvalue", attrs.get("attrvalue" + (i + 1)));
                attr.set("seq", (Object)i);
            }
            newItemAttrvalues.add(itemAttrvalue);
        }
        if (attrvalueIds.size() > 0 || newItemAttrvalues.size() > 0) {
            QFilter q = new QFilter("item", "=", item.get("id"));
            q.and("id", "not in", attrvalueIds);
            DeleteServiceHelper.delete((String)"mdr_item_attrvalue", (QFilter[])q.toArray());
        }
        if (newItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])newItemAttrvalues.toArray(new DynamicObject[0]));
        }
        if (oldItemAttrvalues.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])oldItemAttrvalues.toArray(new DynamicObject[0]));
        }
    }
}

