/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class AddressServiceHelper {
    private static final Log logger = LogFactory.getLog(AddressServiceHelper.class);

    public static ApiResult saveCustomerAddress(List<DynamicObject> customerAddressDatas) {
        StringBuilder sb = new StringBuilder();
        if (customerAddressDatas == null || customerAddressDatas.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u4fdd\u5b58\u7684\u5ba2\u6237\u5730\u5740\u6570\u636e\u3002", (String)"AddressServiceHelper_1", (String)"bd-master-business", (Object[])new Object[0]));
        }
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(customerAddressDatas.size());
        for (DynamicObject customerAddress : customerAddressDatas) {
            if (customerAddress.getDynamicObject("customer") == null) {
                sb.append("number:");
                sb.append(customerAddress.getString("number"));
                sb.append(ResManager.loadKDString((String)"\u5bf9\u5e94\u5730\u5740\u5173\u8054\u7684\u5ba2\u6237\u4e0d\u5b58\u5728\u3002", (String)"AddressServiceHelper_2", (String)"bd-master-business", (Object[])new Object[0]));
                continue;
            }
            datas.add(customerAddress);
        }
        if (customerAddressDatas.size() != datas.size()) {
            return ApiResult.fail((String)sb.toString());
        }
        try {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bd_address", (DynamicObject[])datas.toArray(new DynamicObject[datas.size()]), (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                return ApiResult.success(datas);
            }
            List errorInfoList = result.getAllErrorOrValidateInfo();
            for (IOperateInfo ipinfo : errorInfoList) {
                sb.append(ipinfo.getMessage());
                sb.append(';');
            }
            return ApiResult.fail((String)sb.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return ApiResult.ex((Throwable)e);
        }
    }

    public static Map<Object, DynamicObject> getCustomerAddress(List<QFilter> qfs) {
        QFilter qf = new QFilter("isdeliveryaddress", "=", (Object)"1");
        if (qfs.size() > 0) {
            qfs.add(qf);
        }
        Map datas = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[qfs.size()]);
        return datas;
    }

    public static ApiResult deleteCustomerAddress(List<Long> ids) {
        StringBuilder sb = new StringBuilder();
        if (ids == null || ids.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u9700\u8981\u5220\u9664\u7684\u5ba2\u6237\u5730\u5740\u7684id\u96c6\u5408\u3002", (String)"AddressServiceHelper_3", (String)"bd-master-business", (Object[])new Object[0]));
        }
        OperateOption op = OperateOption.create();
        op.setVariableValue("ischeck", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"bd_address", (Object[])ids.toArray(new Long[ids.size()]), (OperateOption)op);
        if (result.isSuccess()) {
            return ApiResult.success(ids);
        }
        List errorInfoList = result.getAllErrorOrValidateInfo();
        for (IOperateInfo ipinfo : errorInfoList) {
            sb.append(ipinfo.getMessage());
            sb.append(';');
        }
        return ApiResult.fail((String)sb.toString());
    }
}

