/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.vo.MaterialUnitExportVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MaterialUnitQueryHelper {
    private static final String MATERIAL_SELECTS = "id,measureunitid.id,denominator,numerator,converttype,appscen,precision,materialid";
    private static final String QUERY_SELECTFIELDS = "id,name,number";
    private MaterialUnitExportVo materialUnitExportVo = new MaterialUnitExportVo();

    public void getMaterialUnit(String type, DynamicObject[] queryValues, DynamicObjectType materialType, DynamicObjectType measureunitType, Set<Long> ids) {
        Map<Object, List<DynamicObject>> materialUnitDetail = this.materialUnitExportVo.getMaterialUnitDetail();
        Map<Object, DynamicObject> materialUnit = this.materialUnitExportVo.getMaterialUnit();
        QFilter[] filters = new QFilter[]{new QFilter("materialid", "in", ids)};
        if (materialType.getProperty("entryentity") != null) {
            HashSet<Object> unitIds = new HashSet<Object>();
            List<DynamicObject> unitDetail = null;
            Map loads = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)MATERIAL_SELECTS, (QFilter[])filters);
            for (DynamicObject multimeasureunit : loads.values()) {
                Object materialId = multimeasureunit.getDynamicObject("materialid").getPkValue();
                unitDetail = materialUnitDetail.get(materialId);
                if (unitDetail == null) {
                    unitDetail = new ArrayList<DynamicObject>();
                }
                unitDetail.add(multimeasureunit);
                materialUnitDetail.put(materialId, unitDetail);
                if (measureunitType.getProperty("measureunitid") == null || materialUnit.containsKey(multimeasureunit.get("measureunitid.id"))) continue;
                unitIds.add(multimeasureunit.get("measureunitid.id"));
            }
            if (!unitIds.isEmpty()) {
                Map units = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)QUERY_SELECTFIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", unitIds)});
                materialUnit.putAll(units);
            }
        }
    }

    public void setExportMaterialUnit(DynamicObjectType materialType, DynamicObjectType measureunitType, DynamicObject material) {
        DynamicObject measureunit = null;
        if (materialType.getProperty("entryentity") != null) {
            Object materialId = material.getPkValue();
            Map<Object, List<DynamicObject>> materialUnitDetail = this.materialUnitExportVo.getMaterialUnitDetail();
            Map<Object, DynamicObject> materialUnit = this.materialUnitExportVo.getMaterialUnit();
            List<DynamicObject> unitDetail = materialUnitDetail.get(materialId);
            DynamicObjectCollection measureunitCollections = material.getDynamicObjectCollection("entryentity");
            if (unitDetail != null && unitDetail.size() > 0) {
                for (DynamicObject data : unitDetail) {
                    measureunit = new DynamicObject(measureunitType);
                    DynamicObject unit = materialUnit.get(data.get("measureunitid.id"));
                    if (measureunitType.getProperty("id") != null) {
                        measureunit.set("id", data.get("id"));
                    }
                    if (measureunitType.getProperty("measureunitid") != null) {
                        measureunit.set("measureunitid", (Object)unit);
                    }
                    if (measureunitType.getProperty("denominator") != null) {
                        measureunit.set("denominator", data.get("denominator"));
                    }
                    if (measureunitType.getProperty("numerator") != null) {
                        measureunit.set("numerator", data.get("numerator"));
                    }
                    if (measureunitType.getProperty("desmuid") != null) {
                        measureunit.set("desmuid", (Object)material.getDynamicObject("baseunit"));
                    }
                    if (measureunitType.getProperty("converttype") != null) {
                        measureunit.set("converttype", data.get("converttype"));
                    }
                    if (measureunitType.getProperty("appscen") != null) {
                        measureunit.set("appscen", data.get("appscen"));
                    }
                    measureunitCollections.add((Object)measureunit);
                }
            }
        }
    }
}

