/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.enums.MasterUniquenessError;
import kd.bd.master.enums.QFilterType;
import kd.bd.master.util.CaseInsensitiveSet;
import kd.bd.master.util.MapUtil;
import kd.bd.master.util.ValidatorConstructUtil;
import kd.bd.master.vo.ErrorVo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class CheckDataUtil {
    private static final String CHARACTERCODE = "*";

    public List<ErrorVo> constructExitData(List<Long> ids, Map<Object, Set<String>> numbers, Map<Object, Set<String>> names, ExtendedDataEntity extendedDataEntity, boolean checkName, String op) {
        ArrayList<ErrorVo> result = new ArrayList<ErrorVo>();
        DynamicObject data = extendedDataEntity.getDataEntity();
        ids.add(data.getLong("id"));
        this.constructData(numbers, names, extendedDataEntity, result, checkName, op);
        return result;
    }

    public List<ErrorVo> constructPersonTypeData(Map<Object, Set<String>> numbers, Map<ExtendedDataEntity, String> nameAndIdnos, ExtendedDataEntity extendedDataEntity, String op) {
        ArrayList<ErrorVo> result = new ArrayList<ErrorVo>();
        this.constructPersonTypeData(numbers, nameAndIdnos, extendedDataEntity, result, op);
        return result;
    }

    private void constructPersonTypeData(Map<Object, Set<String>> numbers, Map<ExtendedDataEntity, String> nameAndIdnos, ExtendedDataEntity extendedDataEntity, List<ErrorVo> result, String op) {
        DynamicObject data = null;
        String number = null;
        String name = null;
        String idno = null;
        Long masterid = null;
        DynamicObject createOrg = null;
        HashSet<String> numberSet = null;
        Set<String> checkNumberSet = null;
        data = extendedDataEntity.getDataEntity();
        number = data.getString("number");
        createOrg = data.getDynamicObject("createorg");
        name = data.getLocaleString("name").getLocaleValue();
        idno = data.getString("idno");
        masterid = data.getLong("masterid");
        if (createOrg == null) {
            result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNOEXIST));
        } else {
            if (numbers.containsKey(createOrg.getPkValue())) {
                checkNumberSet = numbers.get(createOrg.getPkValue());
                if (checkNumberSet.contains(number)) {
                    if (op.equals("save")) {
                        result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNUMBEREXIT));
                    } else {
                        result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNUMBEREXITSUMBIT));
                    }
                } else {
                    checkNumberSet.add(number);
                }
            } else {
                numberSet = new HashSet<String>();
                numberSet.add(number);
                numbers.put(createOrg.getPkValue(), numberSet);
            }
            if (StringUtils.isEmpty((String)idno)) {
                result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.IDCARDNOEXIST));
            } else if (MapUtil.containsValueIgnoreCase(nameAndIdnos, idno + CHARACTERCODE + name + CHARACTERCODE + masterid)) {
                if (op.equals("save")) {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.NAMEANDIDCARDEXIT));
                } else {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.NAMEANDIDCARDEXITSUMBIT));
                }
            } else {
                nameAndIdnos.put(extendedDataEntity, idno + CHARACTERCODE + name + CHARACTERCODE + masterid);
            }
        }
    }

    public List<ErrorVo> constructNewData(Map<Object, Set<String>> numbers, Map<Object, Set<String>> names, ExtendedDataEntity extendedDataEntity, String op) {
        ArrayList<ErrorVo> result = new ArrayList<ErrorVo>();
        this.constructData(numbers, names, extendedDataEntity, result, true, op);
        return result;
    }

    private void constructData(Map<Object, Set<String>> numbers, Map<Object, Set<String>> names, ExtendedDataEntity extendedDataEntity, List<ErrorVo> result, boolean checkName, String op) {
        DynamicObject data = null;
        String number = null;
        String name = null;
        DynamicObject createOrg = null;
        HashSet<String> numberSet = null;
        HashSet<String> nameSet = null;
        Set<String> checkNumberSet = null;
        Set<String> checkNameSet = null;
        data = extendedDataEntity.getDataEntity();
        number = data.getString("number");
        name = data.getLocaleString("name").getLocaleValue();
        createOrg = data.getDynamicObject("createorg");
        if (createOrg == null) {
            result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNOEXIST));
        } else if (numbers.containsKey(createOrg.getPkValue())) {
            checkNumberSet = numbers.get(createOrg.getPkValue());
            checkNameSet = names.get(createOrg.getPkValue());
            CaseInsensitiveSet lowerNameSet = new CaseInsensitiveSet();
            for (String ckName : checkNameSet) {
                lowerNameSet.add(ckName);
            }
            if (checkNumberSet.contains(number)) {
                if (op.equals("save")) {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNUMBEREXIT));
                } else {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNUMBEREXITSUMBIT));
                }
            } else if (checkName && lowerNameSet != null && lowerNameSet.size() > 0 && lowerNameSet.contains(name)) {
                if (op.equals("save")) {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNAMEEXIT));
                } else {
                    result.add(new ErrorVo(extendedDataEntity, MasterUniquenessError.ORGNAMEEXITSUMBIT));
                }
            } else {
                checkNumberSet.add(number);
                checkNameSet.add(name);
            }
        } else {
            numberSet = new HashSet<String>();
            numberSet.add(number);
            numbers.put(createOrg.getPkValue(), numberSet);
            nameSet = new HashSet<String>();
            nameSet.add(name);
            names.put(createOrg.getPkValue(), nameSet);
        }
    }

    public List<ErrorVo> queryDuplicatedData(Map.Entry<Object, Set<String>> entry, List<ExtendedDataEntity> exitDatas, List<Long> ids, QFilterType type, String entitykey, String propertyName, MasterUniquenessError errorType) {
        QFilter[] filters = null;
        switch (type) {
            case ExitNAME: {
                filters = ValidatorConstructUtil.getNameQFilter(entry.getValue(), entry.getKey());
                break;
            }
            case EXITNUMBER: {
                filters = ValidatorConstructUtil.getNumberQFilter(entry.getValue(), entry.getKey());
                break;
            }
        }
        Map datas = BusinessDataServiceHelper.loadFromCache((String)entitykey, filters);
        return this.getErrorInfo(exitDatas, datas, propertyName, errorType, ids);
    }

    public List<ErrorVo> queryNameAndIdnoDuplicatedData(Map<ExtendedDataEntity, String> nameAndIdnos, List<Long> ids, List<ExtendedDataEntity> exitDatas, String entitykey, MasterUniquenessError errorType) {
        ArrayList<ErrorVo> result = new ArrayList<ErrorVo>();
        for (Map.Entry<ExtendedDataEntity, String> enameAndIdno : nameAndIdnos.entrySet()) {
            result.addAll(this.check(entitykey, errorType, enameAndIdno, exitDatas, ids));
        }
        return result;
    }

    private List<ErrorVo> check(String entitykey, MasterUniquenessError errorType, Map.Entry<ExtendedDataEntity, String> enameAndIdno, List<ExtendedDataEntity> exitDatas, List<Long> ids) {
        String[] arr = null;
        ArrayList<ErrorVo> result = new ArrayList<ErrorVo>();
        arr = enameAndIdno.getValue().split("\\*");
        HashMap<Object, DynamicObject> newDatas = null;
        if (arr != null && arr.length == 3) {
            Map datas = BusinessDataServiceHelper.loadFromCache((String)entitykey, (QFilter[])ValidatorConstructUtil.getNameAndIdnoQFilter(arr[arr.length - 3], arr[arr.length - 2]));
            String masterid = arr[arr.length - 1];
            if (datas != null && datas.size() > 0) {
                newDatas = new HashMap<Object, DynamicObject>(datas.size());
                for (Map.Entry m : datas.entrySet()) {
                    if (masterid.equals(((DynamicObject)m.getValue()).getString("masterid"))) continue;
                    newDatas.put(m.getKey(), (DynamicObject)m.getValue());
                }
                result.addAll(this.getPersonErrorInfo(exitDatas, newDatas, errorType, ids));
            }
        }
        return result;
    }

    private List<ErrorVo> getPersonErrorInfo(List<ExtendedDataEntity> extendedDataEntitys, Map<Object, DynamicObject> datas, MasterUniquenessError errorType, List<Long> ids) {
        ArrayList<ErrorVo> result;
        block8: {
            block7: {
                result = new ArrayList<ErrorVo>();
                ArrayList objects = new ArrayList();
                if (ids != null && ids.size() > 0) {
                    for (Map.Entry entry : datas.entrySet()) {
                        if (ids.contains(Long.parseLong(entry.getKey().toString()))) continue;
                        objects.add(entry.getValue());
                    }
                    if (objects.size() == 0) {
                        return result;
                    }
                }
                if (objects.size() <= 0) break block7;
                for (DynamicObject dynamicObject : objects) {
                    for (ExtendedDataEntity ex : extendedDataEntitys) {
                        if (!dynamicObject.getString("name").equalsIgnoreCase(ex.getDataEntity().getString("name")) || !dynamicObject.getString("idno").equals(ex.getDataEntity().getString("idno"))) continue;
                        result.add(new ErrorVo(ex, errorType));
                    }
                }
                break block8;
            }
            if (datas == null || datas.size() <= 0) break block8;
            for (Map.Entry entry : datas.entrySet()) {
                for (ExtendedDataEntity ex : extendedDataEntitys) {
                    if (!((DynamicObject)entry.getValue()).getString("name").equalsIgnoreCase(ex.getDataEntity().getString("name")) || !((DynamicObject)entry.getValue()).getString("idno").equals(ex.getDataEntity().getString("idno"))) continue;
                    result.add(new ErrorVo(ex, errorType));
                }
            }
        }
        return result;
    }

    private List<ErrorVo> getErrorInfo(List<ExtendedDataEntity> extendedDataEntitys, Map<Object, DynamicObject> datas, String type, MasterUniquenessError errorType, List<Long> ids) {
        ArrayList<ErrorVo> result;
        block9: {
            block8: {
                result = new ArrayList<ErrorVo>();
                ArrayList objects = new ArrayList();
                if (ids != null && ids.size() > 0) {
                    for (Map.Entry entry : datas.entrySet()) {
                        if (ids.contains(Long.parseLong(entry.getKey().toString()))) continue;
                        objects.add(entry.getValue());
                    }
                    if (objects.size() == 0) {
                        return result;
                    }
                }
                if (objects.size() <= 0) break block8;
                for (DynamicObject dynamicObject : objects) {
                    for (ExtendedDataEntity ex : extendedDataEntitys) {
                        if ("name".equals(type)) {
                            if (!dynamicObject.getString(type).equalsIgnoreCase(ex.getDataEntity().getString(type))) continue;
                            result.add(new ErrorVo(ex, errorType));
                            continue;
                        }
                        if (!dynamicObject.getString(type).equals(ex.getDataEntity().getString(type))) continue;
                        result.add(new ErrorVo(ex, errorType));
                    }
                }
                break block9;
            }
            if (datas == null || datas.size() <= 0) break block9;
            for (Map.Entry entry : datas.entrySet()) {
                for (ExtendedDataEntity ex : extendedDataEntitys) {
                    if (!((DynamicObject)entry.getValue()).getString(type).equals(ex.getDataEntity().getString(type))) continue;
                    result.add(new ErrorVo(ex, errorType));
                }
            }
        }
        return result;
    }
}

