/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.vo.MaterialValueVo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.SqlParameter;
import kd.bos.util.StringUtils;

public class TemplateMaterialUtil {
    public static String concatenateCondition(Set<String> materialPks, StringBuffer materialSb) {
        for (String pk : materialPks) {
            materialSb.append(" ");
            materialSb.append(pk);
            materialSb.append(",");
        }
        materialSb.replace(materialSb.lastIndexOf(","), materialSb.lastIndexOf(",") + 1, ")");
        return materialSb.toString();
    }

    public static List<Object[]> getMarterialInsertCondition(MaterialValueVo materialValueVo, DataSet ds, Set<Long> useOrgIds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        SqlParameter[] insertParam = null;
        for (Row row : ds) {
            if (!materialValueVo.getKey().equals(row.getString("fdataid"))) continue;
            insertParam = new SqlParameter[]{new SqlParameter("fuseorgid", -5, (Object)row.getLong("fuseorgid")), new SqlParameter("fdataid", -5, (Object)materialValueVo.getValue()), new SqlParameter("fcreateorgid", -5, (Object)row.getLong("fcreateorgid")), new SqlParameter("fadminorgid", -5, (Object)row.getLong("fadminorgid")), new SqlParameter("fctrlstrategy", 12, (Object)(row.getString("fctrlstrategy") == null ? " " : row.getString("fctrlstrategy"))), new SqlParameter("fisassign", 12, (Object)(row.getString("fisassign") == null ? " " : row.getString("fisassign"))), new SqlParameter("fassignorgid", -5, (Object)row.getLong("fassignorgid"))};
            if (StringUtils.isNotEmpty((String)row.getString("fisassign")) && "1".equals(row.getString("fisassign"))) {
                useOrgIds.add(row.getLong("fuseorgid"));
            }
            insertParams.add(insertParam);
        }
        return insertParams;
    }

    public static List<Object[]> getMarterialUInsertCondition(MaterialValueVo materialValueVo, DataSet ds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        SqlParameter[] insertParam = null;
        for (Row row : ds) {
            if (!materialValueVo.getKey().equals(row.getString("fdataid"))) continue;
            insertParam = new SqlParameter[]{new SqlParameter("fdataid", -5, (Object)materialValueVo.getValue()), new SqlParameter("fuseorgid", -5, (Object)row.getLong("fuseorgid"))};
            insertParams.add(insertParam);
        }
        return insertParams;
    }

    public static List<Object[]> getInsertCondition(Map<?, ?> pksMap, DataSet ds, Set<Long> useOrgIds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        SqlParameter[] insertParam = null;
        for (Row row : ds) {
            insertParam = new SqlParameter[]{new SqlParameter("fuseorgid", -5, (Object)row.getLong("fuseorgid")), new SqlParameter("fdataid", -5, pksMap.get(row.getString("fdataid") + row.getString("fcreateorgid"))), new SqlParameter("fcreateorgid", -5, (Object)row.getLong("fcreateorgid")), new SqlParameter("fadminorgid", -5, (Object)row.getLong("fadminorgid")), new SqlParameter("fctrlstrategy", 12, (Object)(row.getString("fctrlstrategy") == null ? " " : row.getString("fctrlstrategy"))), new SqlParameter("fisassign", 12, (Object)(row.getString("fisassign") == null ? " " : row.getString("fisassign"))), new SqlParameter("fassignorgid", -5, (Object)row.getLong("fassignorgid"))};
            if (StringUtils.isNotEmpty((String)row.getString("fisassign")) && "1".equals(row.getString("fisassign"))) {
                useOrgIds.add(row.getLong("fuseorgid"));
            }
            insertParams.add(insertParam);
        }
        return insertParams;
    }

    public static List<Object[]> getInsertExcCondition(Map<?, ?> pksMap, DataSet ds) {
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        SqlParameter[] insertParam = null;
        for (Row row : ds) {
            insertParam = new SqlParameter[]{new SqlParameter("fuseorgid", -5, (Object)row.getLong("fuseorgid")), new SqlParameter("fdataid", -5, pksMap.get(row.getString("fdataid") + row.getString("fcreateorgid"))), new SqlParameter("fcreateorgid", -5, (Object)row.getLong("fcreateorgid")), new SqlParameter("fnewdataid", -5, (Object)row.getLong("fnewdataid"))};
            insertParams.add(insertParam);
        }
        return insertParams;
    }

    public static String getMaterialAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialUAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIAL_U(FDATAID,FUSEORGID)VALUES(?,?)");
        return sql.toString();
    }

    public static String getMaterialinvinfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALINVINFOUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialinvinfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALINVINFOEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialpurinfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALPURINFOUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialpurinfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALPURINFOEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getInspectcfgAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_INSPECT_CFGUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getInspectcfgExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_INSPECT_CFGEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialmftinfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALMFTINFOUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialmftinfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALMFTINFOEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialcalinfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALCALINFOUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialcalinfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALCALINFOEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialsalinfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALSALINFOUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialsalinfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_BD_MATERIALSALINFOEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialplaninfoAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_MPDM_MATERIALPLANUSEREG(FUSEORGID,FDATAID,FCREATEORGID,FADMINORGID,FCTRLSTRATEGY,FISASSIGN,FASSIGNORGID)VALUES(?,?,?,?,?,?,?)");
        return sql.toString();
    }

    public static String getMaterialplaninfoExcAllocationDataSql() {
        StringBuilder sql = new StringBuilder("INSERT INTO T_MPDM_MATERIALPLANEXC(FUSEORGID,FDATAID,FCREATEORGID,FNEWDATAID)VALUES(?,?,?,?)");
        return sql.toString();
    }

    public static List<Object[]> getUpdateCondition(Map<String, String> numberMap) {
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(numberMap.size());
        SqlParameter[] updateParam = null;
        for (Map.Entry<String, String> map : numberMap.entrySet()) {
            updateParam = new SqlParameter[]{new SqlParameter("FFORMALMATERIALNUMBER", -9, (Object)map.getValue()), new SqlParameter("FENTRYID", -5, (Object)Long.parseLong(map.getKey()))};
            updateParams.add(updateParam);
        }
        return updateParams;
    }

    public static String getAppmaterialsEntryDataSql() {
        StringBuilder sql = new StringBuilder("UPDATE T_BD_APPMATERIALSENTRY SET FFORMALMATERIALNUMBER=? WHERE FENTRYID=?");
        return sql.toString();
    }

    public static String getUseRangeTable(String dataIds, String table_usereg, String table_u, String table_exc) {
        StringBuilder useRangeTable = new StringBuilder();
        useRangeTable.append(" INSERT INTO ").append(table_u).append(" (FDATAID, FUSEORGID)");
        useRangeTable.append(" SELECT FDATAID AS FDATAID,FUSEORGID AS FUSEORGID FROM ").append(table_usereg).append(" WHERE FUSEORGID =? ").append(" AND FDATAID IN(").append(dataIds).append(')');
        useRangeTable.append(" AND NOT EXISTS( SELECT ").append(table_u).append(".FDATAID FROM ").append(table_u).append(" WHERE ").append(table_u).append(".FUSEORGID =?  AND ").append(table_usereg).append(".FDATAID = ").append(table_u).append(".FDATAID").append(") AND NOT EXISTS( SELECT ");
        useRangeTable.append(table_exc).append(".FDATAID FROM ").append(table_exc).append(" WHERE ").append(table_exc).append(".FUSEORGID =? ").append(" AND ").append(table_exc).append(".FDATAID =").append(table_usereg).append(".FDATAID);");
        return useRangeTable.toString();
    }
}

