/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SupplierUserUtil {
    private static final Log log = LogFactory.getLog(SupplierUserUtil.class);

    public static Map<String, Object> deleteSupPerson(Object[] primaryKeyValues) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("success", true);
        DeleteServiceHelper.delete((String)"pbd_supbizperson", (QFilter[])new QFilter[]{new QFilter("scpuser.id", "in", (Object)primaryKeyValues)});
        return resMap;
    }

    public static Map<String, Object> clearUserPermission(Object[] primaryKeyValues) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("success", true);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pur_supuser", (String)"org,user", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        for (DynamicObject supuser : query) {
            long user = supuser.getLong("user");
            long org = supuser.getLong("org");
            HashMap assignInfo = new HashMap(1);
            ArrayList roleList = new ArrayList();
            Set rolesByUser = PermissionServiceHelper.getRolesByUser((Long)user);
            if (!CollectionUtils.isEmpty((Collection)rolesByUser)) {
                roleList.addAll(rolesByUser);
            }
            assignInfo.put(org, roleList);
            boolean removeAdminRole = PermissionServiceHelper.userAssignRole((Long)user, (String)"bos_org", assignInfo, null, (boolean)false);
            if (removeAdminRole) continue;
            log.info("\u6e05\u9664\u4f9b\u5e94\u5546\u6743\u9650\u5931\u8d25\uff1a " + user);
        }
        return resMap;
    }

    public static Map<String, Object> deleteUserOrEnableUser(Object[] primaryKeyValues) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("success", true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult deleteOperationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pur_supuser", (Object[])primaryKeyValues, (OperateOption)option);
        if (!deleteOperationResult.isSuccess()) {
            boolean valMessage;
            List allErrorOrValidateInfo = deleteOperationResult.getAllErrorOrValidateInfo();
            String message = deleteOperationResult.getMessage();
            boolean valInfo = allErrorOrValidateInfo != null && allErrorOrValidateInfo.toString().contains(ResManager.loadKDString((String)"\u5f15\u7528", (String)"SupplierUserUtil_2", (String)"bd-pbd-common", (Object[])new Object[0]));
            boolean bl = valMessage = message != null && message.contains(ResManager.loadKDString((String)"\u5f15\u7528", (String)"SupplierUserUtil_2", (String)"bd-pbd-common", (Object[])new Object[0]));
            if (valInfo || valMessage) {
                boolean hasEnableData = QueryServiceHelper.exists((String)"pur_supuser", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1").and("id", "in", (Object)primaryKeyValues)});
                if (!hasEnableData) {
                    resMap.put("success", false);
                    String msg = valInfo ? allErrorOrValidateInfo.toString() : message;
                    resMap.put("msg", msg);
                } else {
                    log.info("\u4f9b\u5e94\u5546\u7528\u6237\u5220\u9664\u5931\u8d25\u540e\u6267\u884c\u7981\u7528\uff1a" + deleteOperationResult.getMessage());
                    OperationResult enableOperationResult = OperationServiceHelper.executeOperate((String)"disable", (String)"pur_supuser", (Object[])primaryKeyValues, (OperateOption)option);
                    if (!enableOperationResult.isSuccess()) {
                        log.info("\u4f9b\u5e94\u5546\u7528\u6237\u5220\u9664\u5931\u8d25\u540e\u6267\u884c\u7981\u7528\u5931\u8d25\uff1a" + enableOperationResult.getMessage());
                    } else {
                        resMap.put("msg", ResManager.loadKDString((String)"\u7531\u4e8e\u4f9b\u5e94\u5546\u7528\u6237\u5b58\u5728\u5176\u4ed6\u5f15\u7528\uff0c\u672c\u6b21\u64cd\u4f5c\u7531\u5220\u9664\u6539\u4e3a\u7981\u7528\u3002", (String)"SupplierUserUtil_3", (String)"bd-pbd-common", (Object[])new Object[0]));
                    }
                }
            } else {
                resMap.put("success", false);
                if (allErrorOrValidateInfo != null) {
                    String msg = !allErrorOrValidateInfo.isEmpty() ? allErrorOrValidateInfo.toString() : message;
                    resMap.put("msg", msg);
                }
            }
        } else {
            resMap.put("msg", ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u7528\u6237\u5220\u9664\u6210\u529f\u3002", (String)"SupplierUserUtil_4", (String)"bd-pbd-common", (Object[])new Object[0]));
        }
        return resMap;
    }

    public static Map<String, Object> disableSrmUser(Object[] primaryKeyValues) {
        OperationResult enableOperationResult;
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("success", true);
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        DynamicObjectCollection supUsers = QueryServiceHelper.query((String)"pur_supuser", (String)"bizpartner,user", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        ArrayList<Long> bizpartnerList = new ArrayList<Long>(10);
        HashSet<String> phoneSet = new HashSet<String>(16);
        for (DynamicObject supUser : supUsers) {
            long bizpartnerId = supUser.getLong("bizpartner");
            bizpartnerList.add(bizpartnerId);
            long userId = supUser.getLong("user");
            DynamicObject userData = SupplierUserUtil.getUser(userId);
            phoneSet.add(userData.getString("phone"));
            phoneSet.add(userData.getString("email"));
        }
        DynamicObject[] srmUser = BusinessDataServiceHelper.load((String)"srm_user", (String)"id,status,enable", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizpartnerList).and("number", "in", phoneSet).and("enable", "=", (Object)"1")});
        if (srmUser.length > 0 && !(enableOperationResult = OperationServiceHelper.executeOperate((String)"disable", (String)"pur_supuser", (DynamicObject[])srmUser, (OperateOption)option)).isSuccess()) {
            resMap.put("msg", SupplierUserUtil.getFailedMsg(enableOperationResult));
            log.info("\u7981\u7528\u534f\u540c\u6ce8\u518c\u7528\u6237\u5931\u8d25" + enableOperationResult.getAllErrorOrValidateInfo() + enableOperationResult.getMessage());
        }
        return resMap;
    }

    public static Map<String, Object> updateSrmSupplierRegLinkmanAndPhone(Object[] primaryKeyValues, DynamicObjectCollection bizpartners) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(4);
        resMap.put("success", true);
        ArrayList<Long> bizpartnerList = new ArrayList<Long>(10);
        for (DynamicObject row : bizpartners) {
            long bizpartnerId = row.getLong("bizpartner");
            bizpartnerList.add(bizpartnerId);
        }
        DynamicObjectCollection otherSupUser = QueryServiceHelper.query((String)"pur_supuser", (String)"bizpartner", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizpartnerList).and("enable", "=", (Object)"1").and("id", "not in", (Object)primaryKeyValues)});
        HashSet<Long> otherBizpartnerSet = new HashSet<Long>(16);
        for (Object row : otherSupUser) {
            long bizpartnerId = row.getLong("bizpartner");
            otherBizpartnerSet.add(bizpartnerId);
        }
        ArrayList<Long> noneBizpartnerList = new ArrayList<Long>(10);
        for (Long bizPartnerId : bizpartnerList) {
            if (otherBizpartnerSet.contains(bizPartnerId)) continue;
            noneBizpartnerList.add(bizPartnerId);
        }
        if (!noneBizpartnerList.isEmpty()) {
            DynamicObject[] srmSupplierRegs;
            for (DynamicObject srmSupplierReg : srmSupplierRegs = BusinessDataServiceHelper.load((String)"srm_supplierreg", (String)"linkman,phone", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", noneBizpartnerList)})) {
                srmSupplierReg.set("linkman", null);
                srmSupplierReg.set("phone", null);
            }
            SaveServiceHelper.save((DynamicObject[])srmSupplierRegs);
        }
        return resMap;
    }

    public static void updateSrmSupplierRegLinkmanAndPhone(DynamicObject[] dataEntities) {
        DynamicObject[] srmSupplierRegs;
        HashMap dataMap = new HashMap(16);
        for (DynamicObject dataentity : dataEntities) {
            boolean isadmin = dataentity.getBoolean("isadmin");
            if (!isadmin) continue;
            DynamicObject user = dataentity.getDynamicObject("user");
            long userId = user.getLong("id");
            DynamicObject userData = SupplierUserUtil.getUser(userId);
            String name = userData.getString("name");
            String phone = userData.getString("phone");
            String email = userData.getString("email");
            ArrayList<String> linkmanAndPhoneList = new ArrayList<String>(10);
            linkmanAndPhoneList.add(name);
            linkmanAndPhoneList.add(phone);
            linkmanAndPhoneList.add(email);
            long bizpartner = dataentity.getLong("bizpartner.id");
            dataMap.put(bizpartner, linkmanAndPhoneList);
        }
        Set bizpartnerSet = dataMap.keySet();
        for (DynamicObject srmSupplierReg : srmSupplierRegs = BusinessDataServiceHelper.load((String)"srm_supplierreg", (String)"linkman,phone,bizpartner", (QFilter[])new QFilter[]{new QFilter("bizpartner", "in", bizpartnerSet).and(new QFilter("supplier_status", "!=", (Object)880834131733251072L).or("supplier_status", "!=", (Object)880835708355347456L))})) {
            List linkmanAndPhoneList;
            long bizpartner = srmSupplierReg.getLong("bizpartner.id");
            String regSupPhone = srmSupplierReg.getString("phone");
            if (regSupPhone.equals((linkmanAndPhoneList = (List)dataMap.get(bizpartner)).get(2))) continue;
            srmSupplierReg.set("linkman", linkmanAndPhoneList.get(0));
            srmSupplierReg.set("phone", linkmanAndPhoneList.get(1));
        }
        SaveServiceHelper.save((DynamicObject[])srmSupplierRegs);
    }

    private static DynamicObject getUser(long userid) {
        return BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"name,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userid)});
    }

    private static String getFailedMsg(OperationResult operationResult) {
        return !operationResult.getAllErrorOrValidateInfo().isEmpty() ? operationResult.getAllErrorOrValidateInfo().toString() : operationResult.getMessage();
    }
}

