/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.helper.MaterialServiceHelper;
import kd.bd.master.validator.MaterialSaveValidator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialSavePlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(MaterialSavePlugin.class);
    private GroupStandardHelper groupStandardHelper = new GroupStandardHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("simplepinyin");
        e.getFieldKeys().add("auxptyunit");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("entry_groupstandard");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("isuseauxpty");
        e.getFieldKeys().add("auxptyentry");
        e.getFieldKeys().add("serviceattribute");
        e.getFieldKeys().add("materialtype");
        e.getFieldKeys().add("configproperties");
        e.getFieldKeys().add("farmproducts");
        e.getFieldKeys().add("deductiblerate");
        e.getFieldKeys().add("enableinv");
        e.getFieldKeys().add("enableproduct");
        e.getFieldKeys().add("enableoutsource");
        e.getFieldKeys().add("enabletrustee");
        e.getFieldKeys().add("enableconsign");
        e.getFieldKeys().add("enableinspect");
        e.getFieldKeys().add("suite");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"MaterialSavePlugin", (String)"onAddValidators");){
            e.addValidator((AbstractValidator)new MaterialSaveValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        log.info("MaterialSavePlugin.beginOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan span = Tracer.create((String)"MaterialSavePlugin", (String)"beginOperationTransaction");){
            this.operationContext = new OperationContext();
            HashMap<String, Boolean> map = this.operationContext.getParameter();
            if (map == null) {
                map = new HashMap<String, Boolean>(e.getDataEntities().length);
                this.operationContext.setParameter(map);
            }
            for (DynamicObject data : e.getDataEntities()) {
                String customerId = MasterDataHelper.getDataPk((DynamicObject)data);
                GroupStandardHelper.setGroupData(map, (DynamicObject)data, (String)customerId, (String)e.getOperationKey());
                map.put(customerId, data.getDataEntityState().getFromDatabase());
                MasterDataHelper.setDataStatus((DynamicObject)data, (OperateOption)this.getOption());
                IDataEntityProperty prop = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)"serviceattribute");
                DynamicObjectCollection serviceattributes = data.getDynamicObjectCollection(prop);
                String materialType = data.getString("materialtype");
                if (serviceattributes != null && serviceattributes.isEmpty()) {
                    if (serviceattributes.getDynamicObjectType() == null || serviceattributes.getParent() == null) {
                        data.getDataStorage().setLocalValue(prop, null);
                        serviceattributes = data.getDynamicObjectCollection(prop);
                    }
                    DynamicObject serviceattribute = serviceattributes.addNew();
                    switch (materialType) {
                        case "1": {
                            serviceattribute.set("fbasedataid_id", (Object)1194029484878120960L);
                            break;
                        }
                        case "7": {
                            serviceattribute.set("fbasedataid_id", (Object)1194029484878120960L);
                            DynamicObject serviceattribute2 = serviceattributes.addNew();
                            serviceattribute2.set("fbasedataid_id", (Object)1194029878949760000L);
                            break;
                        }
                        case "8": {
                            serviceattribute.set("fbasedataid_id", (Object)1194029484878120960L);
                            DynamicObject serviceattribute3 = serviceattributes.addNew();
                            serviceattribute3.set("fbasedataid_id", (Object)1194030110357899264L);
                            break;
                        }
                        case "9": {
                            serviceattribute.set("fbasedataid_id", (Object)1194029484878120960L);
                            DynamicObject serviceattribute4 = serviceattributes.addNew();
                            serviceattribute4.set("fbasedataid_id", (Object)1194029708862343168L);
                            break;
                        }
                        default: {
                            log.info("materialtype not matching");
                            serviceattribute.set("fbasedataid_id", (Object)1194029484878120960L);
                        }
                    }
                }
                if (!"1".equals(materialType)) {
                    data.set("configproperties", (Object)"1");
                    data.set("farmproducts", (Object)false);
                    data.set("deductiblerate", (Object)0);
                } else if (data.get("farmproducts") != null && !data.getBoolean("farmproducts")) {
                    data.set("deductiblerate", (Object)0);
                }
                if (!"1".equals(materialType) && !"9".equals(materialType) || data.get("suite") == null || !data.getBoolean("suite")) continue;
                data.set("enableproduct", (Object)0);
                data.set("enableoutsource", (Object)0);
                data.set("enabletrustee", (Object)0);
                data.set("enableconsign", (Object)0);
                data.set("enableinspect", (Object)0);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan traceSpan = Tracer.create((String)"MaterialSavePlugin", (String)"afterExecuteOperationTransaction");){
            boolean isFromView;
            if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
                return;
            }
            Map map = this.operationContext.getParameter();
            ArrayList successObjs = new ArrayList(16);
            ArrayList entityGroupDetails = new ArrayList(16);
            HashSet deleteIds = new HashSet();
            ArrayList deleteUnitIds = new ArrayList(16);
            try (TraceSpan span = Tracer.create((String)"MaterialSavePlugin", (String)"getGroupOrg");){
                this.groupStandardHelper.getGroupOrg(map, e.getDataEntities(), "bd_materialgroup");
            }
            ArrayList measureUnits = new ArrayList(16);
            boolean flag = false;
            Map grpDetailFromDB = GroupStandardHelper.queryGrpDetailByMasterId((AfterOperationArgs)e, (Map)map);
            for (DynamicObject dataEntity : e.getDataEntities()) {
                try {
                    try (TraceSpan span = Tracer.create((String)"MaterialSavePlugin", (String)"setGroupDetail");){
                        GroupStandardHelper.setGroupDetail((String)"bd_material", (Map)map, successObjs, entityGroupDetails, deleteIds, (DynamicObject)dataEntity, (String)e.getOperationKey(), (Map)grpDetailFromDB);
                    }
                    span = Tracer.create((String)"MaterialSavePlugin", (String)"updateMaterialUnit");
                    var17_28 = null;
                    try {
                        MaterialServiceHelper.updateMaterialUnit((Map)map, measureUnits, deleteUnitIds, (DynamicObject)dataEntity);
                    }
                    catch (Throwable throwable) {
                        var17_28 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (span != null) {
                            if (var17_28 != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable throwable) {
                                    var17_28.addSuppressed(throwable);
                                }
                            } else {
                                span.close();
                            }
                        }
                    }
                }
                catch (KDBizException exp) {
                    this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(dataEntity, exp));
                }
                MasterDataHelper.checkMasterId((DynamicObject)dataEntity, (boolean)flag);
            }
            boolean containFromView = this.getOption().containsVariable("fromFormView");
            boolean bl = isFromView = containFromView ? "true".equals(this.getOption().getVariableValue("fromFormView")) : false;
            if (!measureUnits.isEmpty() || measureUnits.isEmpty() && isFromView) {
                QFilter[] filters = new QFilter[]{new QFilter("materialid", "in", deleteUnitIds)};
                DeleteServiceHelper.delete((String)"bd_multimeasureunit", (QFilter[])filters);
            }
            if (!measureUnits.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])measureUnits.toArray(new DynamicObject[0]));
            }
            if (!deleteIds.isEmpty()) {
                DeleteServiceHelper.delete((String)"bd_materialgroupdetail", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
            }
            if (!entityGroupDetails.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])entityGroupDetails.toArray(new DynamicObject[0]));
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
            if (flag) {
                SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            }
        }
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, exp.getErrorCode().getCode(), ResManager.loadKDString((String)"\u4fdd\u5b58\u7269\u6599\u5931\u8d25\u3002", (String)"MaterialSavePlugin_0", (String)"bd-master-opplugin", (Object[])new Object[0]), msg, errorLevel);
        return info;
    }
}

