/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bd.master.enums.EnableEnum;
import kd.bd.master.enums.StatusEnum;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bd.master.helper.MasterValidatorCfgHelper;
import kd.bd.master.validator.MasterDataSaveValidator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import org.apache.commons.lang3.StringUtils;

public abstract class CustomerAndSupplierSaveValidator
extends MasterDataSaveValidator {
    private static final String SQL_1 = "select t1.fid as fid,t1.fmasterid as fmasterid,t1.fnumber as fnumber,t2.finternalcompanyid as finternalcompanyid from t_";
    private static final String SQL_2 = " t1 inner join t_";
    private static final String SQL_3 = "_b t2 on t1.fid=t2.fid where ";

    public void checkDefault(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryLinkMan = dataEntity.getDataEntity().getDynamicObjectCollection("entry_linkman");
        DynamicObjectCollection entryBank = dataEntity.getDataEntity().getDynamicObjectCollection("entry_bank");
        int linkManDefCount = 0;
        int realLinkManCount = 0;
        int bankDefCount = 0;
        for (DynamicObject linkman : entryLinkMan) {
            if (!linkman.getBoolean("deleteidentity")) {
                ++realLinkManCount;
                if (linkman.getBoolean("isdefault_linkman") && !linkman.getBoolean("invalid")) {
                    ++linkManDefCount;
                }
            }
            if (linkman.getDynamicObject("associatedaddress") != null) {
                String errMsg;
                String filter;
                DynamicObject address = linkman.getDynamicObject("associatedaddress");
                if ("bd_customer".equals(this.getEntityKey()) && !address.getString("customerid").equals(dataEntity.getDataEntity().getString("id"))) {
                    filter = String.format("%s = %s and %s = '%s'", "number", address.getString("number"), "name", address.getString("name"));
                    errMsg = ResManager.loadKDString((String)"%1$s \u3010\u5173\u8054\u5730\u5740\u3011\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a%2$s", (String)"CustomerAndSupplierSaveValidator_5", (String)"bd-master-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(errMsg, "", filter));
                } else if ("bd_supplier".equals(this.getEntityKey()) && !address.getString("supplierid").equals(dataEntity.getDataEntity().getString("id"))) {
                    filter = String.format("%s = %s and %s = '%s'", "number", address.getString("number"), "name", address.getString("name"));
                    errMsg = ResManager.loadKDString((String)"%1$s \u3010\u5173\u8054\u5730\u5740\u3011\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a%2$s", (String)"CustomerAndSupplierSaveValidator_5", (String)"bd-master-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(errMsg, "", filter));
                }
            }
            if (linkman.getBoolean("invalid") || !linkman.getBoolean("deleteidentity")) continue;
            String errMsg = ResManager.loadKDString((String)"\u5220\u9664\u6807\u8bc6\u7684\u503c\u6253\u5f00\u5931\u6548\u6807\u8bc6\u5fc5\u987b\u540c\u6b65\u6253\u5f00\u3002", (String)"CustomerAndSupplierSaveValidator_14", (String)"bd-master-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errMsg);
        }
        for (DynamicObject bank : entryBank) {
            if (!StringUtils.isEmpty((CharSequence)bank.getString("bankaccount"))) {
                bank.set("bankaccount", (Object)bank.getString("bankaccount").trim());
            }
            if (!StringUtils.isEmpty((CharSequence)bank.getString("iban"))) {
                bank.set("iban", (Object)bank.getString("iban").trim());
            }
            if (!bank.getBoolean("isdefault_bank")) continue;
            ++bankDefCount;
        }
        if ("save".equals(this.getOperateKey()) && "bd_supplier".equals(this.getEntityKey())) {
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"sup_linkdefault_save", (String)this.getOperateKey())) {
                if (realLinkManCount > 0 && linkManDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (realLinkManCount > 0 && linkManDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"sup_bankdefault_save", (String)this.getOperateKey())) {
                if (entryBank.size() > 0 && bankDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (entryBank.size() > 0 && bankDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_4", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if ("save".equals(this.getOperateKey()) && "bd_customer".equals(this.getEntityKey())) {
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"cus_linkdefault_save", (String)this.getOperateKey())) {
                if (realLinkManCount > 0 && linkManDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (realLinkManCount > 0 && linkManDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"cus_bankdefault_save", (String)this.getOperateKey())) {
                if (entryBank.size() > 0 && bankDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (entryBank.size() > 0 && bankDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_4", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if ("submit".equals(this.getOperateKey()) && "bd_supplier".equals(this.getEntityKey())) {
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"sup_linkdefault_submit", (String)this.getOperateKey())) {
                if (realLinkManCount > 0 && linkManDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (realLinkManCount > 0 && linkManDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"sup_bankdefault_submit", (String)this.getOperateKey())) {
                if (entryBank.size() > 0 && bankDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (entryBank.size() > 0 && bankDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_4", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if ("submit".equals(this.getOperateKey()) && "bd_customer".equals(this.getEntityKey())) {
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"cus_linkdefault_submit", (String)this.getOperateKey())) {
                if (realLinkManCount > 0 && linkManDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (realLinkManCount > 0 && linkManDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u4e14\u6709\u6548\u7684\u8054\u7cfb\u4eba\u3002", (String)"CustomerAndSupplierSaveValidator_2", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
            if (MasterValidatorCfgHelper.getValidatorResult((String)this.getEntityKey(), (String)"cus_bankdefault_submit", (String)this.getOperateKey())) {
                if (entryBank.size() > 0 && bankDefCount == 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u9700\u8981\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_3", (String)"bd-master-opplugin", (Object[])new Object[0]));
                } else if (entryBank.size() > 0 && bankDefCount > 1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u94f6\u884c\u4fe1\u606f\u4e2d\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u3002", (String)"CustomerAndSupplierSaveValidator_4", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void checkInternalCompany(ExtendedDataEntity[] dataEntities, Long num, String entityName) {
        if (num == 0L) {
            return;
        }
        List internalCompanyExs = Arrays.asList(dataEntities).stream().filter(de -> de.getDataEntity().getDynamicObject("internal_company") != null).collect(Collectors.toList());
        HashSet<Long> internalCompanyPks = null;
        ArrayList<ExtendedDataEntity> noRepeatDatas = new ArrayList<ExtendedDataEntity>();
        if (internalCompanyExs != null && internalCompanyExs.size() > 0) {
            internalCompanyPks = new HashSet<Long>(internalCompanyExs.size());
            HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(internalCompanyExs.size());
            String number = "";
            for (ExtendedDataEntity ex : internalCompanyExs) {
                if (internalCompanyPks.contains(ex.getDataEntity().getDynamicObject("internal_company").getLong("id"))) {
                    number = ((DynamicObject)map.get(ex.getDataEntity().getDynamicObject("internal_company").getLong("id"))).getString("number");
                    this.getInternalCompanyError(entityName, ex, number, "1");
                } else {
                    noRepeatDatas.add(ex);
                }
                internalCompanyPks.add(ex.getDataEntity().getDynamicObject("internal_company").getLong("id"));
                map.put(ex.getDataEntity().getDynamicObject("internal_company").getLong("id"), ex.getDataEntity());
            }
        }
        if (internalCompanyPks != null && internalCompanyPks.size() > 0) {
            SqlBuilder sql = new SqlBuilder();
            sql.append(SQL_1 + entityName, new Object[0]).append(SQL_2 + entityName + SQL_3, new Object[0]).appendIn("t2.finternalcompanyid", new ArrayList(internalCompanyPks));
            DataSet ds = DB.queryDataSet((String)"queryInternalCompany", (DBRoute)DBRoute.basedata, (SqlBuilder)sql);
            Object object = null;
            try {
                if (ds != null && ds.hasNext() && noRepeatDatas.size() > 0) {
                    block10: for (ExtendedDataEntity ex : noRepeatDatas) {
                        for (Row row : ds.copy()) {
                            if (row.getLong("fid").equals(ex.getDataEntity().getLong("id")) || row.getLong("fmasterid").equals(ex.getDataEntity().getLong("masterid")) || ex.getDataEntity().getDynamicObject("internal_company") == null || !row.getLong("finternalcompanyid").equals(ex.getDataEntity().getDynamicObject("internal_company").getLong("id"))) continue;
                            this.getInternalCompanyError(entityName, ex, row.getString("fnumber"), "2");
                            continue block10;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
    }

    private void getInternalCompanyError(String entityName, ExtendedDataEntity ex, String number, String type) {
        switch (entityName) {
            case "bd_customer": {
                if ("1".equals(type)) {
                    String cuserror = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u5bfc\u5165\u6587\u4ef6\u4e2d\u5ba2\u6237\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e00\u81f4\uff0c\u6570\u636e\u91cd\u590d\u3002", (String)"CustomerAndSupplierSaveValidator_9", (String)"bd-master-opplugin", (Object[])new Object[0]), number);
                    this.addErrorMessage(ex, cuserror);
                    break;
                }
                String cuserror = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u5ba2\u6237\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e00\u81f4\uff0c\u6570\u636e\u91cd\u590d\u3002", (String)"CustomerAndSupplierSaveValidator_7", (String)"bd-master-opplugin", (Object[])new Object[0]), number);
                this.addErrorMessage(ex, cuserror);
                break;
            }
            case "bd_supplier": {
                if ("1".equals(type)) {
                    String superror = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u5bfc\u5165\u6587\u4ef6\u4e2d\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e00\u81f4\uff0c\u6570\u636e\u91cd\u590d\u3002", (String)"CustomerAndSupplierSaveValidator_10", (String)"bd-master-opplugin", (Object[])new Object[0]), number);
                    this.addErrorMessage(ex, superror);
                    break;
                }
                String superror = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e0e\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u4e00\u81f4\uff0c\u6570\u636e\u91cd\u590d\u3002", (String)"CustomerAndSupplierSaveValidator_8", (String)"bd-master-opplugin", (Object[])new Object[0]), number);
                this.addErrorMessage(ex, superror);
            }
        }
    }

    protected void checkTaxCertificate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String invalidTaxCertificateNames;
            DynamicObject masterData = dataEntity.getDataEntity();
            DynamicObject taxRegistPlace = masterData.getDynamicObject("taxregistplace");
            DynamicObjectCollection taxEntry = masterData.getDynamicObjectCollection("entry_tax");
            if (!taxEntry.isEmpty() && taxRegistPlace == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7a0e\u52a1\u6ce8\u518c\u5730\u3002", (String)"CustomerAndSupplierSaveValidator_11", (String)"bd-master-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (taxEntry.isEmpty() || taxRegistPlace == null || !StringUtils.isNotBlank((CharSequence)(invalidTaxCertificateNames = this.getInvalidTaxCertificateNames(taxRegistPlace, taxEntry)))) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u8d28%1$s\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7684\u4f7f\u7528\u72b6\u6001\u662f\u5426\u4e3a\u53ef\u7528\u4e14\u56fd\u5bb6\u5730\u533a\u7b49\u4e8e\u7a0e\u52a1\u6ce8\u518c\u5730\u3002", (String)"CustomerAndSupplierSaveValidator_12", (String)"bd-master-opplugin", (Object[])new Object[0]), invalidTaxCertificateNames));
        }
    }

    private String getInvalidTaxCertificateNames(DynamicObject taxRegistPlace, DynamicObjectCollection taxEntry) {
        HashSet<String> taxCertificateNames = new HashSet<String>(16);
        Long taxRegistPlaceId = taxRegistPlace.getLong("id");
        for (DynamicObject tax : taxEntry) {
            DynamicObject taxCertificate = tax.getDynamicObject("taxcertificate");
            if (taxCertificate == null) continue;
            DynamicObject taxCertificateCountry = taxCertificate.getDynamicObject("country");
            Long taxCertificateCountryId = taxCertificateCountry == null ? 0L : taxCertificateCountry.getLong("id");
            String taxCertificateName = taxCertificate.getLocaleString("name").getLocaleValue();
            String taxCertificateEnable = taxCertificate.getString("enable");
            String taxCertificateStatus = taxCertificate.getString("status");
            if (EnableEnum.ENABLE.getCode().equals(taxCertificateEnable) && StatusEnum.AUDIT.getCode().equals(taxCertificateStatus) && taxRegistPlaceId.equals(taxCertificateCountryId)) continue;
            taxCertificateNames.add(taxCertificateName);
        }
        return taxCertificateNames.isEmpty() ? "" : ((Object)taxCertificateNames).toString();
    }

    @Override
    public void validate() {
        super.validate();
        if (!BizpartnerHelper.isEnablepartner()) {
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                if (dataEntity.getDataEntity().getDynamicObject("bizpartner") != null) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fdd\u5b58\u5ba2\u5546\u5546\u52a1\u4f19\u4f34\u5fc5\u987b\u5f55\u5165\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CustomerAndSupplierSaveValidator_13", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public void checkChkisInternalCompany(ExtendedDataEntity dataEntity, String type) {
        boolean chkisinternalcompany = dataEntity.getDataEntity().getBoolean("chkisinternalcompany");
        DynamicObject internalCompany = dataEntity.getDataEntity().getDynamicObject("internal_company");
        if (chkisinternalcompany && internalCompany == null) {
            if ("bd_supplier".equals(type)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u4f9b\u5e94\u5546\u5c5e\u6027\u5f00\u542f\u65f6\uff0c\u4f9b\u5e94\u5546\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u5c5e\u6027\u9700\u8981\u7ef4\u62a4\u3002", (String)"BASEDATA-W-105431", (String)"bd-master-opplugin", (Object[])new Object[0]));
            } else if ("bd_customer".equals(type)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5185\u90e8\u5ba2\u6237\u5c5e\u6027\u5f00\u542f\u65f6\uff0c\u5ba2\u6237\u7684\u5185\u90e8\u4e1a\u52a1\u5355\u5143\u5c5e\u6027\u9700\u8981\u7ef4\u62a4\u3002", (String)"BASEDATA-W-737735", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

