/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.business.pdm.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MaterialAttrSyncHelper {
    private static final String SPLIT = "&&";
    private static final Log log = LogFactory.getLog(MaterialAttrSyncHelper.class);
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public static void materialAttrSync(Set<Object> materialInfoIds, String entityNumber) {
        Map errorMap;
        List successIds;
        long starttime = System.currentTimeMillis();
        Map datas = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)"id,masterid,createorg,materialattr", (QFilter[])new QFilter[]{new QFilter("id", "in", materialInfoIds)});
        String updateEntityNumber = null;
        if ("bd_materialmftinfo".equals(entityNumber)) {
            updateEntityNumber = "mpdm_materialplan";
        } else if ("mpdm_materialplan".equals(entityNumber)) {
            updateEntityNumber = "bd_materialmftinfo";
        }
        HashMap<String, String> materialAttrMap = new HashMap<String, String>(16);
        HashMap<String, Long> materialbizIdMap = new HashMap<String, Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        HashSet<Long> createorgIds = new HashSet<Long>(16);
        for (DynamicObject data : datas.values()) {
            Long materialId = data.getLong("masterid.id");
            Long createorgId = data.getLong("createorg.id");
            String materialattr = data.getString("materialattr");
            String key = materialId + SPLIT + createorgId;
            materialAttrMap.put(key, materialattr);
            materialbizIdMap.put(key, data.getLong("id"));
            materialIds.add(materialId);
            createorgIds.add(createorgId);
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterMaterials = new QFilter("masterid", "in", materialIds);
        QFilter qFilterCreateorg = new QFilter("createorg", "in", createorgIds);
        QFilter[] filters = new QFilter[]{qFilterStatus, qFilterEnable, qFilterMaterials, qFilterCreateorg};
        DynamicObject[] oldDataMap = BusinessDataServiceHelper.load((String)updateEntityNumber, (String)"id,masterid,materialattr,createorg", (QFilter[])filters);
        HashMap<Long, Set<DynamicObject>> materialBizInfos = new HashMap<Long, Set<DynamicObject>>(16);
        HashMap<Long, String> updateMaterialIdAttrMap = new HashMap<Long, String>(16);
        for (DynamicObject oldData : oldDataMap) {
            Long materialId = oldData.getLong("masterid.id");
            Long createorgId = oldData.getLong("createorg.id");
            String key = materialId + SPLIT + createorgId;
            String materialAttr = (String)materialAttrMap.get(key);
            Long updateId = (Long)materialbizIdMap.get(key);
            if (updateId == null) continue;
            Long oldDataId = oldData.getLong("id");
            updateMaterialIdAttrMap.put(oldDataId, materialAttr);
            Set set = materialBizInfos.computeIfAbsent(updateId, k -> new HashSet(16));
            set.add(oldData);
        }
        if ("bd_materialmftinfo".equals(updateEntityNumber) && updateMaterialIdAttrMap.size() > 0) {
            long mftstarttime = System.currentTimeMillis();
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"IMaterialMftInfoService", (String)"materialMftInfoAttrSync", (Object[])new Object[]{updateMaterialIdAttrMap});
            long mftendtime = System.currentTimeMillis();
            log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65\u751f\u4ea7\u4fe1\u606f\u63a5\u53e3\u8017\u65f6" + (mftendtime - mftstarttime) + "ms");
            successIds = (List)result.get("successIds");
            errorMap = (Map)result.get("errorMap");
            long logstarttime = System.currentTimeMillis();
            MaterialAttrSyncHelper.updateRecordLogInfos(materialBizInfos, successIds, errorMap);
            long logendtime = System.currentTimeMillis();
            log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65\u65e5\u5fd7\u8017\u65f6" + (logendtime - logstarttime) + "ms");
        } else if ("mpdm_materialplan".equals(updateEntityNumber) && updateMaterialIdAttrMap.size() > 0) {
            long planstarttime = System.currentTimeMillis();
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMaterialPlanService", (String)"materialPlanAttrSync", (Object[])new Object[]{updateMaterialIdAttrMap});
            long planendtime = System.currentTimeMillis();
            log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65\u8ba1\u5212\u4fe1\u606f\u63a5\u53e3\u8017\u65f6" + (planendtime - planstarttime) + "ms");
            successIds = (List)result.get("successIds");
            errorMap = (Map)result.get("errorMap");
            long logstarttime = System.currentTimeMillis();
            MaterialAttrSyncHelper.updateRecordLogInfos(materialBizInfos, successIds, errorMap);
            long logendtime = System.currentTimeMillis();
            log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65\u65e5\u5fd7\u8017\u65f6" + (logendtime - logstarttime) + "ms");
        }
        long bomstarttime = System.currentTimeMillis();
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"UpdateBomEntryDataService", (String)"syncBomEntry", (Object[])new Object[]{entityNumber, materialInfoIds});
        long bomendtime = System.currentTimeMillis();
        log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65Bom\u63a5\u53e3\u8017\u65f6" + (bomendtime - bomstarttime) + "ms");
        long endtime = System.currentTimeMillis();
        log.info("\u7269\u6599\u5c5e\u6027\u540c\u6b65\u8017\u65f6" + (endtime - starttime) + "ms");
    }

    public static void updateRecordLogInfos(Map<Long, Set<DynamicObject>> materialBizInfos, List<Object> successIds, Map<Long, String> errorMap) {
        HashSet<Long> materUpdateBizInfoIds = new HashSet<Long>(16);
        String updateEntityNumber = null;
        ArrayList<DynamicObject> updateLogs = new ArrayList<DynamicObject>(16);
        for (Map.Entry<Long, Set<DynamicObject>> entry : materialBizInfos.entrySet()) {
            Set<DynamicObject> materUpdateBizInfos = entry.getValue();
            for (DynamicObject dynamicObject : materUpdateBizInfos) {
                if (StringUtils.isBlank(updateEntityNumber)) {
                    updateEntityNumber = dynamicObject.getDynamicObjectType().getName();
                }
                Long materUpdateBizInfoId = dynamicObject.getLong("id");
                materUpdateBizInfoIds.add(materUpdateBizInfoId);
            }
        }
        Map datas = BusinessDataServiceHelper.loadFromCache(updateEntityNumber, (String)"id,masterid,createorg,modifytime,materialattr", (QFilter[])new QFilter[]{new QFilter("id", "in", materUpdateBizInfoIds)});
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType(updateEntityNumber);
        IDataEntityProperty materialattrProperty = dataEntityType.findProperty("materialattr");
        for (Map.Entry entry : materialBizInfos.entrySet()) {
            Set materUpdateBizInfos = (Set)entry.getValue();
            for (DynamicObject materUpdateBizInfo : materUpdateBizInfos) {
                Long materUpdateBizInfoId = materUpdateBizInfo.getLong("id");
                DynamicObject upateData = (DynamicObject)datas.get(materUpdateBizInfoId);
                if (errorMap != null && !errorMap.isEmpty() && errorMap.containsKey(materUpdateBizInfoId)) {
                    String error = errorMap.get(materUpdateBizInfoId);
                    DynamicObject errorlog = MaterialAttrSyncHelper.setLogInfo(materUpdateBizInfo, materialattrProperty, (Long)entry.getKey(), updateEntityNumber, dataEntityType.getDisplayName().getLocaleValue());
                    errorlog.set("errorinfo", (Object)error);
                    updateLogs.add(errorlog);
                    continue;
                }
                DynamicObject logInfo = MaterialAttrSyncHelper.recordLogInfo(upateData, materUpdateBizInfo, "materialattr", materialattrProperty, (Long)entry.getKey(), updateEntityNumber, dataEntityType.getDisplayName().getLocaleValue());
                if (logInfo == null) continue;
                updateLogs.add(logInfo);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateLogs.toArray(new DynamicObject[0]));
    }

    private static DynamicObject setLogInfo(DynamicObject materUpdateBizInfo, IDataEntityProperty materialattrProperty, Long bizInfoId, String updateEntityNumber, String updateEntityName) {
        Long materUpdateBizInfoId = materUpdateBizInfo.getLong("id");
        DynamicObject updateLog = BusinessDataServiceHelper.newDynamicObject((String)"bd_materialattrsynclog");
        updateLog.set("propname", (Object)materialattrProperty.getDisplayName().getLocaleValue());
        updateLog.set("materialid", (Object)materUpdateBizInfo.getString("masterid.id"));
        updateLog.set("bizorg", (Object)materUpdateBizInfo.getLong("createorg.id"));
        updateLog.set("materialid", (Object)materUpdateBizInfo.getString("masterid.id"));
        updateLog.set("materialnumber", (Object)materUpdateBizInfo.getString("masterid.number"));
        updateLog.set("materialname", (Object)materUpdateBizInfo.getLocaleString("masterid.name").getLocaleValue());
        if ("bd_materialmftinfo".equals(updateEntityNumber)) {
            updateLog.set("opname", (Object)ResManager.loadKDString((String)"\u8ba1\u5212\u540c\u6b65\u751f\u4ea7", (String)"MaterialAttrSyncHelper_0", (String)"bd-sbd-business", (Object[])new Object[0]));
            updateLog.set("materialplanid", (Object)bizInfoId);
            updateLog.set("materialmftid", (Object)materUpdateBizInfoId);
        } else if ("mpdm_materialplan".equals(updateEntityNumber)) {
            updateLog.set("opname", (Object)ResManager.loadKDString((String)"\u751f\u4ea7\u540c\u6b65\u8ba1\u5212", (String)"MaterialAttrSyncHelper_1", (String)"bd-sbd-business", (Object[])new Object[0]));
            updateLog.set("materialplanid", (Object)materUpdateBizInfoId);
            updateLog.set("materialmftid", (Object)bizInfoId);
        }
        Date opdate = materUpdateBizInfo.getDate("modifytime");
        String userName = RequestContext.get().getUserName();
        updateLog.set("opdate", (Object)opdate);
        updateLog.set("username", (Object)userName);
        return updateLog;
    }

    private static DynamicObject recordLogInfo(DynamicObject materUpdateBizInfo, DynamicObject olddata, String prop, IDataEntityProperty materialattrProperty, Long bizInfoId, String updateEntityNumber, String updateEntityName) {
        String newValue;
        DynamicObject updateLog = null;
        String oldValue = MaterialAttrSyncHelper.getValue(olddata, prop, materialattrProperty, null);
        if (!Objects.equals(oldValue, newValue = MaterialAttrSyncHelper.getValue(materUpdateBizInfo, prop, materialattrProperty, null))) {
            updateLog = MaterialAttrSyncHelper.setLogInfo(materUpdateBizInfo, materialattrProperty, bizInfoId, updateEntityNumber, updateEntityName);
            updateLog.set("prevalue", (Object)oldValue);
            updateLog.set("nextvalue", (Object)newValue);
        }
        return updateLog;
    }

    public static String getValue(DynamicObject data, String prop, IDataEntityProperty property, DynamicObject unit) {
        if (data == null) {
            return "";
        }
        if (property instanceof BasedataProp) {
            BasedataProp baseDataProp = (BasedataProp)property;
            String displayProp = baseDataProp.getDisplayProp();
            DynamicObject dobj = data.getDynamicObject(prop);
            if (dobj == null) {
                return "";
            }
            return data.getDynamicObject(prop).getString(displayProp);
        }
        if (property instanceof TextProp) {
            return data.getString(prop);
        }
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            Date date = data.getDate(prop);
            if (date == null) {
                return "";
            }
            return MaterialAttrSyncHelper.formatDateTime(date);
        }
        if (property instanceof QtyProp) {
            if (unit == null) {
                return "";
            }
            BigDecimal value = data.getBigDecimal(prop).setScale(unit.getInt("precision"), 4);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof DecimalProp) {
            BigDecimal value = data.getBigDecimal(prop);
            if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
                return "";
            }
            return value.toString();
        }
        if (property instanceof BooleanProp) {
            Boolean value = data.getBoolean(prop);
            return value.toString();
        }
        if (property instanceof ComboProp) {
            String value = data.getString(prop);
            List comboItems = ((ComboProp)property).getComboItems();
            String name = "";
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(value)) continue;
                name = comboItem.getName().getLocaleValue();
                break;
            }
            return name;
        }
        return "";
    }

    public static String formatDateTime(Date date) {
        return DATETIME.get().format(date);
    }
}

