/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.permission.model.AdminType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class ManuStrategyConfigEditPlugin
extends AbstractBasePlugIn {
    private static final String KEY_FIELD = "field";
    private static final String KEY_DOMAIN = "domain";
    private static final String KEY_BILLTYPE = "billentity";
    private static final String KEY_DIMENSION = "dimension";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_SUBENTRYENTITY = "subentryentity";
    private static final Log log = LogFactory.getLog(ManuStrategyConfigEditPlugin.class);

    public void afterCreateNewData(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        RequestContext requestContext = RequestContext.get();
        long userID = requestContext.getCurrUserId();
        boolean isAdmin = PermissionServiceHelper.isAdminUser((long)userID, (AdminType)AdminType.Administrator);
        if (!isAdmin) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_delete", "bar_save", "bar_disable", "bar_more"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_FIELD});
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (KEY_FIELD.equals(source.getKey())) {
            EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            int selectRow = 0;
            if (entry.getSelectRows().length != 0) {
                selectRow = entry.getSelectRows()[0];
            }
            if (this.getModel().getValue(KEY_BILLTYPE, selectRow) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u8ffd\u6eaf\u8303\u56f4\u201d\u7b2c%s\u884c\u201c\u5355\u636e\u201d", (String)"ManuStrategyConfigEditPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), selectRow + 1));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_FIELD.equals(key)) {
            EntryGrid entryrGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            int selectRow = 0;
            if (entryrGrid.getSelectRows().length != 0) {
                selectRow = entryrGrid.getSelectRows()[0];
            }
            String sourcebilltype = ((DynamicObject)this.getModel().getValue(KEY_BILLTYPE, selectRow)).getString("id");
            MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)sourcebilltype);
            PropTreeBuildOption ops = new PropTreeBuildOption();
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)appBillMainType, (PropTreeBuildOption)ops);
            this.showSelectFieldForm(srcBillNode, KEY_FIELD, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"SnParameteEditPlugein_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        }
    }

    private void showSelectFieldForm(TreeNode billNode, String fieldCtrlKey, String caption) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        if (returnData == null) {
            return;
        }
        if (KEY_FIELD.equals(actionId)) {
            EntryGrid entryrGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            int selectRow = 0;
            if (entryrGrid.getSelectRows().length != 0) {
                selectRow = entryrGrid.getSelectRows()[0];
            }
            String field = returnData.toString().replace("billhead.", "");
            String sourcebilltype = ((DynamicObject)this.getModel().getValue(KEY_BILLTYPE, selectRow)).getString("id");
            MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)sourcebilltype);
            DataEntityPropertyCollection properties = appBillMainType.getProperties();
            if (field.indexOf(46) != -1 && properties.get((Object)field.substring(0, field.indexOf(46))) == null) {
                for (IDataEntityProperty po : properties) {
                    DynamicObjectType propertyType;
                    DataEntityPropertyCollection entryProp;
                    if (!(po instanceof EntryProp) || (entryProp = (propertyType = ((EntryProp)po).getDynamicCollectionItemPropertyType()).getProperties()).get((Object)field.substring(0, field.indexOf(46))) == null) continue;
                    field = po.getName() + "." + field;
                    break;
                }
            }
            EntryGrid subentry = (EntryGrid)this.getControl(KEY_SUBENTRYENTITY);
            model.setValue(KEY_FIELD, (Object)field, subentry.getSelectRows()[0]);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (KEY_BILLTYPE.equals(propName)) {
            int entryRowCount = this.getModel().getEntryRowCount(KEY_SUBENTRYENTITY);
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue(KEY_FIELD, (Object)"", i);
            }
        }
    }
}

