/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bd.sbd.formplugin.translate.FieldFormTranslator;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class MatchoutRuleEditPlugin
extends AbstractBasePlugIn
implements EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(MatchoutRuleEditPlugin.class);
    private static String BILLHEAD = "billhead";

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.translateFields();
    }

    private void translateFields() {
        IDataModel model = this.getModel();
        try {
            FieldFormTranslator translator = FieldFormTranslator.create(model);
            translator.entryToEntryTranslate("entryentity", "source", "srccol", "srccolname");
        }
        catch (Exception ex) {
            logger.error("\u7ffb\u8bd1\u9519\u8bef", (Object)ex.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("save".equals(op.getOperateKey())) {
            this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("modifytime", (Object)new Date());
        }
        super.beforeDoOperation(args);
    }

    private void setEnable() {
        Boolean isPreset = this.getModel().getDataEntity().getBoolean("ispreset");
        if (isPreset.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel", "bar_delete", "bar_save", "bar_modify", "bar_saveandnew"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete", "bar_save", "bar_modify", "bar_saveandnew"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List entities = e.getRows();
        IFormView view = this.getView();
        entities.forEach(entry -> {
            int rowIndex = entry.getRowIndex();
            DynamicObject entryObj = entry.getDataEntity();
            String type = entryObj.getString("type");
            if ("custom".equals(type)) {
                view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"customorder"});
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"valueouttype"});
            } else {
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"customorder"});
                view.setEnable(Boolean.valueOf(true), rowIndex, new String[]{"valueouttype"});
            }
        });
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IFormView view = this.getView();
        String entryName = e.getEntryProp().getName();
        if ("entryentity".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                view.setEnable(Boolean.valueOf(false), rowIndex, new String[]{"customorder"});
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srccol"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "srccol": {
                this.clickSrcCol();
            }
        }
    }

    private void clickSrcCol() {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("entryentity");
        String source = (String)model.getValue("source", index);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        HashSet<String> configed = new HashSet<String>(16);
        for (DynamicObject entry : entryEntity) {
            if (!source.equals(entry.getString("source"))) continue;
            configed.add(entry.getString("srccol"));
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        PropTreeBuildOption ops = new PropTreeBuildOption();
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceType, (PropTreeBuildOption)ops);
        this.removeTreeNode(srcBillNode, configed);
        this.showSelectFieldForm(srcBillNode, "srccol");
    }

    private void removeTreeNode(TreeNode node, Set<String> field) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if (field.contains(child.getId())) {
                iterator.remove();
                continue;
            }
            if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
            this.removeTreeNode(child, field);
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "srccol": {
                this.srccolCloseCallBack(actionId, (String)returnData);
            }
        }
    }

    private void srccolCloseCallBack(String colFlag, String returnCol) {
        int index;
        if (StringUtils.isBlank((String)returnCol)) {
            return;
        }
        IDataModel model = this.getModel();
        String source = (String)model.getValue("source", index = model.getEntryCurrentRowIndex("entryentity"));
        if (returnCol.equals(source) || returnCol.equals(BILLHEAD)) {
            return;
        }
        MainEntityType sourceType = EntityMetadataCache.getDataEntityType((String)source);
        model.beginInit();
        model.setValue("srccol", (Object)returnCol, index);
        model.setValue("srccolname", (Object)this.getColName(sourceType, returnCol), index);
        model.setValue("type", (Object)"asc", index);
        model.setValue("customorder", null, index);
        model.setValue("valueouttype", (Object)"A", index);
        model.endInit();
        this.getView().updateView("entryentity", index);
    }

    private String getColName(MainEntityType entity, String col) {
        if (StringUtils.isBlank((String)col)) {
            return null;
        }
        String[] proCols = col.split("\\.");
        IDataEntityProperty pro = entity.findProperty(proCols[0]);
        StringBuilder name = new StringBuilder(pro.getDisplayName().getLocaleValue());
        if (proCols.length > 1) {
            BasedataProp basePro = null;
            for (int i = 1; i < proCols.length && pro instanceof BasedataProp; ++i) {
                MainEntityType type;
                String subName = null;
                String propSubContent = proCols[i];
                subName = pro instanceof FlexProp ? ("id".equals(propSubContent) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"MatchoutRuleEditPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]) : propSubContent) : ((pro = (type = MetadataServiceHelper.getDataEntityType((String)(basePro = (BasedataProp)pro).getBaseEntityId())).findProperty(propSubContent)).getDisplayName() == null ? ("id".equals(pro.getName()) ? ResManager.loadKDString((String)"\u5185\u7801", (String)"MatchoutRuleEditPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]) : "") : pro.getDisplayName().getLocaleValue());
                name.append('.').append(subName);
            }
        }
        return name.toString();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "source": {
                this.changeSource(model, changeSet);
                break;
            }
            case "srccol": {
                this.changeSrccol(model, changeSet);
                break;
            }
            case "type": {
                this.changeType(model, changeSet);
                break;
            }
            case "customorder": {
                this.changeCustomOrder(model, changeSet);
                break;
            }
            case "valueouttype": {
                this.changeValueOutType(model, changeSet);
            }
        }
    }

    private void changeSource(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int index = changeData.getRowIndex();
            model.setValue("srccol", null, index);
            model.setValue("srccolname", null, index);
            model.setValue("type", (Object)"asc", index);
            model.setValue("customorder", null, index);
            model.setValue("valueouttype", (Object)"A", index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeSrccol(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int index = changeData.getRowIndex();
            model.setValue("srccolname", null, index);
            model.setValue("type", (Object)"asc", index);
            model.setValue("customorder", null, index);
            model.setValue("valueouttype", (Object)"A", index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeType(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int index = changeData.getRowIndex();
            String type = (String)changeData.getNewValue();
            if ("custom".equals(type)) {
                String oldValue = (String)changeData.getOldValue();
                String source = (String)model.getValue("source", index);
                String srccol = (String)model.getValue("srccol", index);
                if (!srccol.isEmpty()) {
                    Class<?> propType = this.getFieldPropType(source, srccol);
                    if (String.class != propType) {
                        model.setValue("type", (Object)oldValue, index);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ec5\u652f\u6301\u5b57\u7b26\u7c7b\u578b\u7684\u5b57\u6bb5\u8bbe\u7f6e\u4e3a\u81ea\u5b9a\u4e49\u6392\u5e8f\u3002", (String)"MatchoutRuleEditPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    model.setValue("valueouttype", (Object)"A", index);
                    continue;
                }
                model.setValue("valueouttype", (Object)"A", index);
                continue;
            }
            model.setValue("customorder", null, index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeValueOutType(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            Class<?> propType;
            int index = changeData.getRowIndex();
            String valueOutType = (String)changeData.getNewValue();
            if ("A".equals(valueOutType)) continue;
            String source = (String)model.getValue("source", index);
            String srccol = (String)model.getValue("srccol", index);
            if (srccol.isEmpty() || Date.class == (propType = this.getFieldPropType(source, srccol))) continue;
            String oldValue = (String)changeData.getOldValue();
            model.setValue("valueouttype", (Object)oldValue, index);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4ec5\u652f\u6301\u65e5\u671f\u7c7b\u578b\u7684\u5b57\u6bb5\u8bbe\u7f6e\u4e3a\u7a7a\u503c\u4f18\u5148\u6216\u5ef6\u540e\u51fa\u5e93\u3002", (String)"MatchoutRuleEditPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void changeCustomOrder(IDataModel model, ChangeData[] changeSet) {
        model.beginInit();
        for (ChangeData changeData : changeSet) {
            int index = changeData.getRowIndex();
            String customorder = (String)changeData.getNewValue();
            StringBuilder newCustomOrder = new StringBuilder();
            int i = 0;
            for (String customorderItem : customorder.split(",")) {
                String customorderItemNew;
                if (customorderItem == null || (customorderItemNew = customorderItem.replaceAll("\u3000", " ").trim()).isEmpty()) continue;
                if (i > 0) {
                    newCustomOrder.append(',');
                }
                newCustomOrder.append(customorderItemNew);
                ++i;
            }
            model.setValue("customorder", (Object)newCustomOrder.toString(), index);
        }
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private Class<?> getFieldPropType(String source, String srccol) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)source);
        String[] keys = srccol.split("\\.");
        IDataEntityProperty pro = mainType.findProperty(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keys.length; ++i) {
                String propSubContent;
                if (pro instanceof BasedataProp) {
                    propSubContent = keys[i];
                    if ("id".equals(propSubContent)) {
                        return Long.class;
                    }
                    if (pro instanceof FlexProp) {
                        return String.class;
                    }
                } else {
                    return pro.getPropertyType();
                }
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)((BasedataProp)pro).getBaseEntityId());
                pro = type.findProperty(propSubContent);
            }
            return pro.getPropertyType();
        }
        return pro.getPropertyType();
    }
}

