/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.sbd.formplugin.MaterialBizInfoPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;

public class MaterialMftPlugin
extends MaterialBizInfoPlugin {
    private static final String ENTRY = "entry";
    private static final String MATPLANSCOPID = "matplanscopid";
    private static final String MSPLAN_MATPLANSCOP = "msplan_matplanscop";
    private static final String ENTRY_SUPPLIER_ORG = "entry_supplier_org";
    private static final String ENTRY_SUPPLIER_WAREHOUSE = "entry_supplier_warehouse";
    private static final String ENTRY_SUPPLIER_SHIPPING = "entry_supplier_shipping";
    private static final String ENTRY_IN_STORAGE_ORG = "entry_in_storage_org";
    private static final String ENTRY_STORAGE_WAREHOUSE = "entry_storage_warehouse";
    private static final String ENTRY_IN_STORAGE_SHIPPING = "entry_in_storage_shipping";
    private static final String SELECTPROPERTIES = "entrymatplanscop.seq,entrymatplanscop.planscope,entrymatplanscop.supplier_org,entrymatplanscop.supplier_warehouse,entrymatplanscop.supplier_shipping,entrymatplanscop.in_storage_org,entrymatplanscop.in_storage_warehouse,entrymatplanscop.in_storage_shipping,entrymatplanscop.start_useing";

    @Override
    protected void setInitializeData(BillShowParameter lsp) {
        Object materialID;
        Object minBatchUnit;
        super.setInitializeData(lsp);
        Object baseUnitId = lsp.getCustomParam("baseunit");
        if (baseUnitId != null) {
            this.getModel().setValue("mftunit", baseUnitId);
        }
        if ((minBatchUnit = lsp.getCustomParam("minbatchunit")) != null) {
            this.getModel().setValue("minbatchunit", minBatchUnit);
        }
        if ((materialID = lsp.getCustomParam("materialid")) != null) {
            this.getModel().setValue("material", materialID);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierWarehouse = (BasedataEdit)this.getView().getControl(ENTRY_SUPPLIER_WAREHOUSE);
        supplierWarehouse.addBeforeF7SelectListener(this::supplierWarehouseBeforeF7Select);
        BasedataEdit supplierShipping = (BasedataEdit)this.getView().getControl(ENTRY_SUPPLIER_SHIPPING);
        supplierShipping.addBeforeF7SelectListener(this::supplierShippingBeforeF7Select);
        BasedataEdit storageWarehouse = (BasedataEdit)this.getView().getControl(ENTRY_STORAGE_WAREHOUSE);
        storageWarehouse.addBeforeF7SelectListener(this::storageWarehouseBeforeF7Select);
        BasedataEdit storageShipping = (BasedataEdit)this.getView().getControl(ENTRY_IN_STORAGE_SHIPPING);
        storageShipping.addBeforeF7SelectListener(this::storageShippingBeforeF7Select);
        BasedataEdit supplierOrg = (BasedataEdit)this.getView().getControl(ENTRY_SUPPLIER_ORG);
        supplierOrg.addBeforeF7SelectListener(this::supplierOrgBeforeF7Select);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "entry_supplier_org": {
                this.dealFieldIfnull(key, newObj, rowIndex);
                break;
            }
            case "entry_in_storage_org": {
                this.dealFieldIfnull(key, newObj, rowIndex);
                break;
            }
            case "entry_supplier_warehouse": {
                this.dealFieldIfnull(key, newObj, rowIndex);
                break;
            }
            case "entry_storage_warehouse": {
                this.dealFieldIfnull(key, newObj, rowIndex);
            }
            case "masterid": {
                this.setMaterialAttr();
            }
        }
    }

    private void setMaterialAttr() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            Long createorgid = (Long)this.getModel().getValue("createorg_id");
            if (this.getModel().getValue("masterid") != null) {
                Long materialId = ((DynamicObject)this.getModel().getValue("masterid")).getLong("masterid");
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>(4);
                qfilters.add(new QFilter("material.masterid", "=", (Object)materialId));
                qfilters.add(new QFilter("createorg.id", "=", (Object)createorgid));
                qfilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
                qfilters.add(new QFilter("status", "=", (Object)Character.valueOf('C')));
                DynamicObject materialPlan = BusinessDataServiceHelper.loadSingle((String)"mpdm_materialplan", (String)"materialattr", (QFilter[])qfilters.toArray(new QFilter[0]));
                if (materialPlan != null) {
                    this.getModel().setValue("materialattr", (Object)materialPlan.getString("materialattr"));
                }
            }
        }
    }

    private void dealFieldIfnull(String key, Object newObj, int rowIndex) {
        if (newObj == null) {
            if (ENTRY_SUPPLIER_ORG.equals(key)) {
                this.getModel().setValue(ENTRY_SUPPLIER_WAREHOUSE, null, rowIndex);
                this.getModel().setValue(ENTRY_SUPPLIER_SHIPPING, null, rowIndex);
            } else if (ENTRY_IN_STORAGE_ORG.equals(key)) {
                this.getModel().setValue(ENTRY_STORAGE_WAREHOUSE, null, rowIndex);
                this.getModel().setValue(ENTRY_IN_STORAGE_SHIPPING, null, rowIndex);
            } else if (ENTRY_SUPPLIER_WAREHOUSE.equals(key)) {
                this.getModel().setValue(ENTRY_SUPPLIER_SHIPPING, null, rowIndex);
            } else {
                this.getModel().setValue(ENTRY_IN_STORAGE_SHIPPING, null, rowIndex);
            }
        }
    }

    private void supplierOrgBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
        Long createOrgId = createOrg.getLong("id");
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(createOrgId.longValue());
        param.setFromViewType("04");
        param.setToViewType("05");
        param.setDirectViewType("toorg");
        Map map = OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
        List isExists = (List)map.get("data");
        ArrayList<Long> orgList = new ArrayList<Long>(isExists.size());
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.setMultiSelect(false);
        for (Map exists : isExists) {
            Long orgId = (Long)exists.get("orgId");
            orgList.add(orgId);
        }
        if (orgList.size() == 0) {
            return;
        }
        boolean orgExists = QueryServiceHelper.exists((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("fisinventory", "=", (Object)true).and("id", "=", (Object)createOrgId)});
        if (orgExists) {
            orgList.add(createOrgId);
        }
        QFilter qFilter = new QFilter("id", "in", orgList);
        e.addCustomQFilter(qFilter);
    }

    private void supplierWarehouseBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplierOrg = (DynamicObject)this.getModel().getValue(ENTRY_SUPPLIER_ORG);
        if (supplierOrg == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u7ec4\u7ec7\u3002", (String)"MaterialMftPlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]), new Object[0]));
            e.setCancel(true);
        } else {
            Long masterid = supplierOrg.getLong("masterid");
            this.setWarehouseFilter(e, masterid);
        }
    }

    private void storageWarehouseBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplierWarehouse = (DynamicObject)this.getModel().getValue("createorg");
        long masterid = supplierWarehouse.getLong("masterid");
        Long planScopeValueId = (Long)this.getModel().getValue("entry_planscopeid");
        DynamicObject planScopeValue = BusinessDataServiceHelper.loadSingleFromCache((Object)planScopeValueId, (String)"msplan_planscope");
        if (planScopeValue != null) {
            long planScope = planScopeValue.getLong("masterid");
            DynamicObjectCollection value = QueryServiceHelper.query((String)"msplan_planscope_whs", (String)"warehouse.id", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)masterid).and("planscope", "=", (Object)planScope)});
            ArrayList<Long> msplanPlanscopeWhsList = new ArrayList<Long>();
            for (DynamicObject msplanPlanscopeWhs : value) {
                msplanPlanscopeWhsList.add(msplanPlanscopeWhs.getLong("warehouse.id"));
            }
            QFilter qFilter = new QFilter("id", "in", msplanPlanscopeWhsList);
            e.addCustomQFilter(qFilter);
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8ba1\u5212\u8303\u56f4\u3002", (String)"MaterialMftPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), new Object[0]));
            e.setCancel(true);
        }
    }

    private void setWarehouseFilter(BeforeF7SelectEvent e, Long masterid) {
        QFilter qFilter1 = new QFilter("initstatus", "=", (Object)"B");
        QFilter qFilter2 = new QFilter("startstatus", "=", (Object)"B");
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("org", "=", (Object)masterid);
        DynamicObjectCollection value = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])new QFilter[]{qFilter1.and(qFilter2).and(qFilter3).and(qFilter4)});
        ArrayList<Long> imWareHouseSetupList = new ArrayList<Long>();
        for (DynamicObject imWarehousesetup : value) {
            imWareHouseSetupList.add(imWarehousesetup.getLong("warehouse.id"));
        }
        QFilter qFilter = new QFilter("id", "in", imWareHouseSetupList);
        e.addCustomQFilter(qFilter);
    }

    private void supplierShippingBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplierWarehouse = (DynamicObject)this.getModel().getValue(ENTRY_SUPPLIER_WAREHOUSE);
        if (supplierWarehouse == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u4ed3\u5e93\u3002", (String)"MaterialMftPlugin_2", (String)"bd-sbd-formplugin", (Object[])new Object[0]), new Object[0]));
            e.setCancel(true);
        } else {
            Long masterid = supplierWarehouse.getLong("masterid");
            this.setShippingFilter(e, masterid);
        }
    }

    private void storageShippingBeforeF7Select(BeforeF7SelectEvent e) {
        DynamicObject supplierWarehouse = (DynamicObject)this.getModel().getValue(ENTRY_STORAGE_WAREHOUSE);
        if (supplierWarehouse == null) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5165\u5e93\u4ed3\u5e93\u3002", (String)"MaterialMftPlugin_3", (String)"bd-sbd-formplugin", (Object[])new Object[0]), new Object[0]));
            e.setCancel(true);
        } else {
            Long masterid = supplierWarehouse.getLong("masterid");
            this.setShippingFilter(e, masterid);
        }
    }

    private void setShippingFilter(BeforeF7SelectEvent e, Long masterid) {
        QFilter qFilter = new QFilter("id", "=", (Object)masterid);
        DynamicObjectCollection value = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> bdWarehouseList = new ArrayList<Long>();
        for (DynamicObject bdWarehouse : value) {
            bdWarehouseList.add(bdWarehouse.getLong("entryentity.location"));
        }
        QFilter qFilter1 = new QFilter("id", "in", bdWarehouseList);
        e.addCustomQFilter(qFilter1);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillEntry();
    }

    private void fillEntry() {
        Long createorgid = (Long)this.getModel().getValue("createorg_id");
        Long materialId = (Long)this.getModel().getValue("id");
        if (materialId != null) {
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
            qfilters.add(new QFilter("material.id", "=", (Object)materialId));
            qfilters.add(new QFilter("createorg.id", "=", (Object)createorgid));
            qfilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            DynamicObject matplanscop = BusinessDataServiceHelper.loadSingle((String)MSPLAN_MATPLANSCOP, (String)SELECTPROPERTIES, (QFilter[])qfilters.toArray(new QFilter[0]));
            if (matplanscop != null) {
                this.setEntryValue(matplanscop);
            }
        }
    }

    private void setEntryValue(DynamicObject matplanscop) {
        this.getPageCache().put(MATPLANSCOPID, matplanscop.getPkValue().toString());
        DynamicObjectCollection collections = matplanscop.getDynamicObjectCollection("entrymatplanscop");
        if (!collections.isEmpty()) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            model.deleteEntryData(ENTRY);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField("entry_planscope_name", new Object[0]);
            vs.addField("entry_planscopeid", new Object[0]);
            vs.addField(ENTRY_SUPPLIER_ORG, new Object[0]);
            vs.addField(ENTRY_SUPPLIER_WAREHOUSE, new Object[0]);
            vs.addField(ENTRY_SUPPLIER_SHIPPING, new Object[0]);
            vs.addField(ENTRY_IN_STORAGE_ORG, new Object[0]);
            vs.addField(ENTRY_STORAGE_WAREHOUSE, new Object[0]);
            vs.addField(ENTRY_IN_STORAGE_SHIPPING, new Object[0]);
            vs.addField("entry_is_used", new Object[0]);
            int seq = 1;
            for (DynamicObject collection : collections) {
                vs.addRow(new Object[]{seq++, collection.getString("planscope.name"), collection.getLong("planscope.id"), collection.getLong("supplier_org.id"), collection.getLong("supplier_warehouse.id"), collection.getLong("supplier_shipping.id"), collection.getLong("in_storage_org.id"), collection.getLong("in_storage_warehouse.id"), collection.getLong("in_storage_shipping.id"), collection.getBoolean("start_useing")});
            }
            model.batchCreateNewEntryRow(ENTRY, vs);
            model.beginInit();
            this.getView().updateView(ENTRY);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate oper = (FormOperate)args.getSource();
        String operateKey = oper.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            String msg = this.getSaveMatplanscopResult();
            if (!StringUtils.isEmpty((String)msg)) {
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
            this.fillEntry();
        }
    }

    private String getSaveMatplanscopResult() {
        String obj = this.getPageCache().get(MATPLANSCOPID);
        if (obj != null) {
            OperationResult result;
            DynamicObject matplanscop = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(obj), (String)MSPLAN_MATPLANSCOP);
            if (matplanscop != null) {
                DynamicObjectCollection collections = matplanscop.getDynamicObjectCollection("entrymatplanscop");
                DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRY);
                if (!collections.isEmpty() && entrys.size() == collections.size()) {
                    for (int i = 0; i < collections.size(); ++i) {
                        DynamicObject entryDyn = (DynamicObject)collections.get(i);
                        entryDyn.set("seq", (Object)(i + 1));
                        entryDyn.set("supplier_org", ((DynamicObject)entrys.get(i)).get(ENTRY_SUPPLIER_ORG));
                        entryDyn.set("supplier_warehouse", ((DynamicObject)entrys.get(i)).get(ENTRY_SUPPLIER_WAREHOUSE));
                        entryDyn.set("supplier_shipping", ((DynamicObject)entrys.get(i)).get(ENTRY_SUPPLIER_SHIPPING));
                        entryDyn.set("in_storage_org", ((DynamicObject)entrys.get(i)).get(ENTRY_IN_STORAGE_ORG));
                        entryDyn.set("in_storage_warehouse", ((DynamicObject)entrys.get(i)).get(ENTRY_STORAGE_WAREHOUSE));
                        entryDyn.set("in_storage_shipping", ((DynamicObject)entrys.get(i)).get(ENTRY_IN_STORAGE_SHIPPING));
                        entryDyn.set("start_useing", ((DynamicObject)entrys.get(i)).get("entry_is_used"));
                    }
                }
            }
            if (!(result = SaveServiceHelper.saveOperate((String)MSPLAN_MATPLANSCOP, (DynamicObject[])new DynamicObject[]{matplanscop}, (OperateOption)OperateOption.create())).isSuccess()) {
                String errMsg = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).collect(Collectors.joining("\n"));
                return String.format(ResManager.loadKDString((String)"\u7269\u6599\u4e0e\u8ba1\u5212\u8303\u56f4\u5173\u7cfb\u8868\u540c\u6b65\u4fee\u6539\u5931\u8d25\uff1a\n%s", (String)"MaterialMftPlugin_4", (String)"bd-sbd-formplugin", (Object[])new Object[0]), errMsg);
            }
        }
        return null;
    }
}

