/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.pdm;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bd.sbd.enums.ConfigCodeRuleFormatEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ConfigCodeRulePlugin
extends AbstractFormPlugin
implements CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        AbstractOperate operat = (AbstractOperate)args.getSource();
        String key = operat.getOperateKey();
        if ("save".equals(key)) {
            DynamicObjectCollection col = model.getEntryEntity("entryentity");
            boolean flag = false;
            for (DynamicObject obj : col) {
                String setValueStr;
                DynamicObject codeAttr = obj.getDynamicObject("codeattr");
                if (codeAttr == null) continue;
                String attrType = codeAttr.getString("attrtype");
                if ("E".equals(attrType)) {
                    flag = true;
                    this.checkSerialMustControl(args, obj);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"D", (CharSequence)attrType) || obj == null || (setValueStr = obj.getString("setvalue")) != null && !StringUtils.isEmpty((CharSequence)setValueStr)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e38\u91cf\u7684\u8bbe\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConfigCodeRulePlugin_9", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5fc5\u987b\u5305\u542b\u5c5e\u6027\u4e3a\u201c\u6d41\u6c34\u53f7\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5\u3002", (String)"ConfigCodeRulePlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void checkSerialMustControl(BeforeDoOperationEventArgs args, DynamicObject codeAttrDO) {
        if (codeAttrDO == null) {
            return;
        }
        String setValueStr = codeAttrDO.getString("setvalue");
        int stepLength = codeAttrDO.getInt("steplength");
        if (setValueStr == null || StringUtils.isEmpty((CharSequence)setValueStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u7684\u8bbe\u7f6e\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ConfigCodeRulePlugin_7", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!Pattern.matches("^[0-9]*$", setValueStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u7684\u8bbe\u7f6e\u503c\u53ea\u80fd\u8f93\u5165\u7eaf\u6570\u5b57\u3002", (String)"ConfigCodeRulePlugin_10", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (stepLength <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u7684\u6b65\u957f\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ConfigCodeRulePlugin_8", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String separator;
        Object[] arr;
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        IDataModel modal = this.getModel();
        if ("save".equals(key)) {
            String number = modal.getValue("number").toString();
            this.getModel().setValue("status", (Object)"C");
            QFilter filter = new QFilter("number", "=", (Object)number);
            arr = new QFilter[]{filter};
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"bd_configcoderule", (String)"number,status", (QFilter[])arr);
            if (obj != null) {
                obj.set("status", (Object)"C");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("status").getOrdinal(), false);
            }
        }
        if ("modify".equals(key)) {
            this.getModel().setValue("status", (Object)"A");
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("status").getOrdinal(), false);
        }
        if (("newentry".equals(key) || "insertentry".equals(key)) && StringUtils.isNotEmpty((CharSequence)(separator = String.valueOf(modal.getValue("separator"))))) {
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            arr = eg.getSelectRows();
            this.getModel().beginInit();
            modal.setValue("entryseparator", (Object)separator, (int)arr[0]);
            this.getModel().endInit();
            this.getView().updateView("entryseparator", (int)arr[0]);
        }
        if ("deleteentry".equals(key)) {
            DynamicObjectCollection col = this.getModel().getEntryEntity("entryentity");
            String example = this.getNumExample(col);
            this.getModel().setValue("example", (Object)example);
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String example;
        DynamicObjectCollection col;
        super.propertyChanged(event);
        String proName = event.getProperty().getName();
        ChangeData[] changeDatas = event.getChangeSet();
        if (changeDatas == null || changeDatas.length == 0) {
            return;
        }
        ChangeData changeData = changeDatas[0];
        if ("codeattr".equals(proName)) {
            col = this.getModel().getEntryEntity("entryentity");
            this.setFormatCom(changeData);
            example = this.getNumExample(col);
            this.getModel().beginInit();
            this.getModel().setValue("example", (Object)example);
            int i = changeData.getRowIndex();
            this.getModel().setValue("setvalue", null, i);
            this.getModel().setValue("steplength", null, i);
            this.getModel().endInit();
            this.getView().updateView("example");
        }
        if ("entryseparator".equals(proName)) {
            col = this.getModel().getEntryEntity("entryentity");
            int i = changeData.getRowIndex();
            DynamicObject codeAttr = this.getModel().getEntryRowEntity("entryentity", i).getDynamicObject("codeattr");
            if (null != codeAttr) {
                String example2 = this.getNumExample(col);
                this.getModel().setValue("example", (Object)example2);
            }
        }
        if ("setvalue".equals(proName)) {
            col = this.getModel().getEntryEntity("entryentity");
            example = this.getNumExample(col);
            this.getModel().setValue("example", (Object)example);
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            this.checkSetValueSerial(newValue, oldValue, rowIndex);
        }
    }

    private void checkSetValueSerial(Object newValue, Object oldValue, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            return;
        }
        this.getModel().beginInit();
        Object codeattr = this.getModel().getValue("codeattr");
        String attrType = "";
        if (codeattr instanceof DynamicObject) {
            attrType = ((DynamicObject)codeattr).getString("attrtype");
        }
        if ("E".equals(attrType) && !Pattern.matches("^[0-9]*$", newValue.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u7684\u8bbe\u7f6e\u503c\u53ea\u80fd\u8f93\u5165\u7eaf\u6570\u5b57\u3002", (String)"ConfigCodeRulePlugin_10", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("setvalue", oldValue, rowIndex);
            this.getView().updateView("setvalue", rowIndex);
        }
        this.getModel().endInit();
    }

    private void setFormatCom(ChangeData changeData) {
        Object obj = changeData.getNewValue();
        int i = changeData.getRowIndex();
        if (obj == null) {
            return;
        }
        String attrtype = ((DynamicObject)obj).get("attrtype").toString();
        String format = String.valueOf(this.getModel().getValue("format", i));
        if ("C".equals(attrtype) || "E".equals(attrtype) || "A".equals(attrtype) || "D".equals(attrtype)) {
            this.getModel().beginInit();
            this.getModel().setValue("format", (Object)ConfigCodeRuleFormatEnum.NORMAL.getName(), i);
            this.getModel().setValue("formatvalue", (Object)ConfigCodeRuleFormatEnum.NORMAL.getValue(), i);
            this.getModel().endInit();
            this.getView().updateView("format", i);
            this.getView().updateView("formatvalue", i);
        }
        if ("B".equals(attrtype)) {
            this.getModel().beginInit();
            this.getModel().setValue("format", (Object)"yyyyMMdd", i);
            this.getModel().setValue("formatvalue", (Object)"yyyyMMdd", i);
            this.getModel().endInit();
            this.getView().updateView("format", i);
            this.getView().updateView("formatvalue", i);
        }
        if ("D".equals(attrtype) || "E".equals(attrtype)) {
            this.getModel().setValue("usemode", (Object)"A", i);
        }
    }

    private String getNumExample(DynamicObjectCollection col) {
        StringBuilder builder = new StringBuilder();
        for (DynamicObject obj : col) {
            DynamicObject codeAttr = obj.getDynamicObject("codeattr");
            String attrName = "";
            if (null != codeAttr) {
                String type = codeAttr.getString("attrtype");
                if ("B".equals(type)) {
                    String format = obj.getString("format");
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    attrName = sdf.format(new Date());
                } else if ("D".equals(type) || "E".equals(type)) {
                    String setValue = obj.getString("setvalue");
                    if (StringUtils.isNotEmpty((CharSequence)setValue)) {
                        attrName = setValue;
                    }
                } else {
                    attrName = codeAttr.getString("name");
                }
            }
            String entrySepara = obj.getString("entryseparator");
            builder.append(attrName);
            builder.append(entrySepara);
        }
        return builder.toString();
    }

    public void cellClick(CellClickEvent evt) {
        IDataModel modle = this.getModel();
        String sourceFldKey = evt.getFieldKey();
        String status = "";
        Object statusObj = modle.getValue("status");
        if (StringUtils.isNotBlank((Object)statusObj)) {
            status = String.valueOf(statusObj);
        }
        if ("format".equals(sourceFldKey) && "A".equals(status)) {
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            int[] arr = eg.getSelectRows();
            DynamicObject obj = this.getModel().getEntryRowEntity("entryentity", arr[0]);
            DynamicObject dynobj = obj.getDynamicObject("codeattr");
            if (null != dynobj) {
                CloseCallBack closeCallBack;
                String attrtype = dynobj.get("attrtype").toString();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("currentRow", arr[0]);
                if ("B".equals(attrtype)) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "key_date");
                    this.showForm("bos_coderule_dateformat", params, closeCallBack, ShowType.Modal);
                }
                if ("A".equals(attrtype) || "D".equals(attrtype)) {
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "key_textformat");
                    this.showForm("bd_configcoderule_format", params, closeCallBack, ShowType.Modal);
                }
            }
            eg.selectRows(arr[0], false);
        }
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (key = evt.getActionId()) {
            case "key_date": {
                HashMap map1 = (HashMap)returnData;
                int currentRow1 = (Integer)map1.get("currentRow");
                this.getModel().beginInit();
                this.getModel().setValue("format", (Object)map1.get("format").toString(), currentRow1);
                this.getModel().setValue("formatvalue", (Object)map1.get("format").toString(), currentRow1);
                this.getModel().setValue("entrylength", (Object)map1.get("format").toString().length(), currentRow1);
                this.getModel().endInit();
                this.getView().updateView("format", currentRow1);
                this.getView().updateView("formatvalue", currentRow1);
                this.getView().updateView("entrylength", currentRow1);
                DynamicObject object = (DynamicObject)this.getModel().getValue("codeattr", currentRow1);
                if (object == null || !"B".equals(object.getString("attrtype"))) break;
                DynamicObjectCollection col = this.getModel().getEntryEntity("entryentity");
                String example = this.getNumExample(col);
                this.getModel().setValue("example", (Object)example);
                break;
            }
            case "key_textformat": {
                HashMap map2 = (HashMap)returnData;
                int currentRow2 = (Integer)map2.get("currentRow");
                this.getModel().beginInit();
                this.getModel().setValue("formatvalue", (Object)map2.get("value").toString(), currentRow2);
                this.getModel().setValue("format", (Object)map2.get("format").toString(), currentRow2);
                this.getModel().endInit();
                this.getView().updateView("format", currentRow2);
                this.getView().updateView("formatvalue", currentRow2);
                String setValue = String.valueOf(this.getModel().getValue("setvalue", currentRow2));
                if (StringUtils.isNotEmpty((CharSequence)setValue)) {
                    if ("A".equals(map2.get("value"))) {
                        setValue = setValue.toUpperCase();
                    }
                    if ("C".equals(map2.get("value"))) {
                        setValue = setValue.toLowerCase();
                    }
                }
                this.getModel().setValue("setvalue", (Object)setValue, currentRow2);
                break;
            }
        }
    }
}

