/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.sn;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class SnMainFilePlugin
extends AbstractBasePlugIn
implements IDataModelListener,
BeforeF7SelectListener {
    private static final String EX_TYPE_NOT_INVORG = "error_notinvorg";
    private static final Integer DB_HANDLE_MAX_SIZE = 250;
    private static final String INV_ORG = "invorg";
    private static final String ISINVENTORY = "fisinventory";
    private static final String BILL_STATUS = "billstatus";
    private static final String SNDIMITEM = "sndimitem";
    private static final String CURINVORG = "curinvorg";
    private static final String CURWAREHOUS = "curwarehous";
    private static final String CURLOCATION = "curlocation";
    private static List<String> COLS = Arrays.asList("fbizhappendate", "fbllentityid", "fbiztypeid", "fbillno", "fsrcsupplierid", "fdescustomerid", "fbizdeptid", "fkeeporgid", "fdeptid", "fwarehouseid", "flocationid", "fbillstatus", "fauditdate", "fsrcinvorgid", "fsrcwarehouseid", "fsrclocationid", "finlotnum", "foutlotnum");
    private static final String CONNECTOR = "_";

    public void initialize() {
        this.addExecutionListDataProvider();
    }

    private List<String> getMoveEntryExtCols() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        List listFields = list.getListFields();
        Map snMoveTrackRelCols = EntityMetadataCache.getDataEntityType((String)"bd_snmovetrack_rel").getAllFields();
        ArrayList<String> extCols = new ArrayList<String>();
        for (ListField listField : listFields) {
            String col = listField.getKey();
            if (COLS.contains(col) || !snMoveTrackRelCols.containsKey(col)) continue;
            extCols.add(listField.getKey());
        }
        return extCols;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit snDimEdit = (BasedataEdit)this.getView().getControl(SNDIMITEM);
        snDimEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datas = (BasedataEdit)this.getControl(SNDIMITEM);
        datas.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Toolbar toolbar = (Toolbar)this.getView().getControl("advcontoolbarap");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        this.resetBillListQFilter();
    }

    private void resetBillListQFilter() {
        String lastQFilterStr = this.getPageCache().get("lastQFilter");
        BillList billList = (BillList)this.getControl("billlistap");
        if (lastQFilterStr != null && !lastQFilterStr.isEmpty()) {
            QFilter lastQFilter = QFilter.fromSerializedString((String)lastQFilterStr);
            billList.getFilterParameter().setQFilters(Collections.singletonList(lastQFilter));
        } else {
            QFilter qFilter = new QFilter("-1", "=", (Object)1);
            billList.getFilterParameter().setQFilters(Collections.singletonList(qFilter));
            billList.clearData();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (SNDIMITEM.equals(fieldKey)) {
            this.filterBillType(this.getModel(), beforeF7SelectEvent);
        }
    }

    private void filterBillType(IDataModel model, BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject bill;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_sndimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SNUMBER")});
        if (dynamicObject == null) {
            return;
        }
        DynamicObjectCollection entryList = model.getEntryEntity("sndimentity");
        ArrayList<Long> ids = new ArrayList<Long>(entryList.size());
        for (int i = 0; i < entryList.size() && (bill = (DynamicObject)((DynamicObject)entryList.get(i)).get(SNDIMITEM)) != null; ++i) {
            long id = bill.getLong("id");
            ids.add(id);
        }
        Long id = (Long)dynamicObject.get("id");
        QFilter filter = new QFilter("id", "!=", (Object)id);
        QFilter filter1 = new QFilter("id", "not in", (Object)ids.toArray());
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter.and(filter1));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long id = this.getModel().getDataEntity().getLong("id");
        DynamicObject[] isHasTrack = BusinessDataServiceHelper.load((String)"bd_snmovetrack_rel", (String)"id", (QFilter[])new QFilter[]{new QFilter("snmainfileid", "=", (Object)id)});
        DynamicObject[] snDim = BusinessDataServiceHelper.load((String)"bd_sndimension", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "!=", (Object)"SNUMBER")});
        if (snDim == null || snDim.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
        }
        if (isHasTrack == null || isHasTrack.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"moveentry2"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"moveentry2"});
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        List importDataMaps = e.getSourceDataList();
        int startIndex = 0;
        int importDataCount = importDataMaps.size();
        int dBHandleCount = importDataCount / DB_HANDLE_MAX_SIZE;
        int remainder = importDataCount % DB_HANDLE_MAX_SIZE;
        if (dBHandleCount >= 1) {
            for (int i = 1; i <= dBHandleCount; ++i) {
                int endIndex = DB_HANDLE_MAX_SIZE * i;
                this.checkImportSNMainFile(importDataMaps, startIndex, endIndex);
                startIndex = endIndex;
            }
        }
        if (remainder > 0) {
            int endIndex = remainder + startIndex;
            this.checkImportSNMainFile(importDataMaps, startIndex, endIndex);
        }
    }

    private void checkImportSNMainFile(List<Map<String, Object>> importDataMaps, int startIndex, int endIndex) {
        QFilter orgFilter = null;
        ArrayList<String> orgSelectors = new ArrayList<String>(20);
        HashMap orgToImptData = new HashMap();
        for (int k = startIndex; k < endIndex; ++k) {
            Map<String, Object> importDataMap = importDataMaps.get(k);
            String snnumber = (String)importDataMap.get("number");
            Map materialMap = (Map)importDataMap.get("material");
            if (materialMap == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e8f\u5217\u53f7\u4e3a[%1$s]\u5bf9\u5e94\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SnMainFilePlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]), snnumber));
            }
            Map orgMap = (Map)importDataMap.get(INV_ORG);
            if (orgMap == null || orgMap.isEmpty()) continue;
            String orgKey = (String)orgMap.get("number");
            if (!orgToImptData.containsKey(orgKey)) {
                orgToImptData.put(orgKey, new ArrayList());
            }
            ((List)orgToImptData.get(orgKey)).add(importDataMap);
            orgSelectors.add(orgKey);
        }
        if (orgSelectors.size() > 0) {
            DynamicObject[] bosOrgs;
            orgFilter = new QFilter("number", "in", orgSelectors);
            for (DynamicObject bosOrg : bosOrgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"number,fisinventory", (QFilter[])orgFilter.toArray())) {
                String number = bosOrg.getString("number");
                boolean isinventory = bosOrg.getBoolean(ISINVENTORY);
                if (isinventory) continue;
                List imptOrgs = (List)orgToImptData.get(number);
                for (Map orgMap : imptOrgs) {
                    orgMap.put(EX_TYPE_NOT_INVORG, ResManager.loadKDString((String)"\u5e93\u5b58\u7ec4\u7ec7\u6240\u5728\u5217\u4e0d\u80fd\u5bfc\u5165\u975e\u5e93\u5b58\u7ec4\u7ec7\u5c5e\u6027\u7684\u4e1a\u52a1\u5355\u5143\u3002", (String)"CheckExMsgNotInvOrg", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map importDataMap = e.getSourceData();
        Object errorNotInvOrg = importDataMap.get(EX_TYPE_NOT_INVORG);
        if (errorNotInvOrg != null) {
            e.setCancel(true);
            e.setCancelMessage(errorNotInvOrg + "");
        } else {
            this.initSNMainFileData(importDataMap);
        }
    }

    private void initSNMainFileData(Map<String, Object> importDataMap) {
        importDataMap.put("isimport", Boolean.TRUE);
        String snStatus = (String)importDataMap.get("snstatus");
        if (StringUtils.isEmpty((String)snStatus)) {
            String snStatusPedingInInv = "A";
            importDataMap.put("snstatus", snStatusPedingInInv);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.querySNMoveCondition();
        this.billTopsetValue(this.getModel());
        this.getModel().setDataChanged(false);
    }

    private void querySNMoveCondition() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        QFilter qFilter = this.getQFilter();
        billList.getFilterParameter().setQFilters(Collections.singletonList(qFilter));
        this.putLastFilterCache(qFilter);
    }

    private void putLastFilterCache(QFilter filter) {
        if (filter != null) {
            this.getPageCache().put("lastQFilter", filter.toSerializedString());
        } else {
            this.getPageCache().put("lastQFilter", "");
        }
    }

    private QFilter getQFilter() {
        Object snmainfileId = this.getModel().getValue("id");
        String queryTrackIdSql = "select t1.ftrackid trackid from t_bd_snmovetrack t\nleft join t_bd_snmovetrack_rel t1 on t1.ftrackid = t.fid\nwhere t1.fsnmainfileid = " + snmainfileId;
        List trackids = (List)DB.query((DBRoute)new DBRoute("sys"), (String)queryTrackIdSql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws Exception {
                ArrayList<Long> result = new ArrayList<Long>(rs.getFetchSize());
                while (rs.next()) {
                    result.add(rs.getLong("trackid"));
                }
                return result;
            }
        });
        QFilter qFilter = new QFilter("id", "in", (Object)trackids);
        return qFilter;
    }

    public void afterCreateNewData(EventObject e) {
        IPageCache pageCache;
        String createOrg;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && (createOrg = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get("createOrg")) != null && !StringUtils.isEmpty((String)createOrg)) {
            this.getModel().setValue(INV_ORG, (Object)Long.valueOf(createOrg));
        }
    }

    private void billTopsetValue(IDataModel model) {
        DynamicObject material = model.getDataEntity().getDynamicObject("material");
        Object materialId = material.getPkValue();
        Object snid = model.getDataEntity().getPkValue();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t2.fkeeporgid,t2.fwarehouseid,t2.fnowinvaccid,t2.flocationid FROM t_bd_snmainfile t LEFT JOIN T_BD_SNMOVETRACK_REL R").append(" ON t.fid = r.fsnmainfileid and t.ffinalaudittrailid = r.fid").append(" LEFT JOIN t_bd_snmovetrack t2 ON r.ftrackid = t2.fid").append(" where fmaterialid = ").append(materialId).append(" and t.fid = ").append(snid);
        DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"sys"), (String)sql.toString());
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            long warehous = row.getLong("fwarehouseid");
            long location = row.getLong("flocationid");
            long bizorg = row.getLong("fkeeporgid");
            model.setValue(CURWAREHOUS, (Object)warehous);
            model.setValue(CURLOCATION, (Object)location);
            model.setValue(CURINVORG, (Object)bizorg);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int index = valueSet[0].getRowIndex();
        Object newValue = valueSet[0].getNewValue();
        switch (propName) {
            case "sndimitem": {
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    this.getModel().setValue("sndimnumber", null, rowIndex);
                }
                break;
            }
            case "material": {
                if (newValue == null) break;
                DynamicObject material = (DynamicObject)newValue;
                Boolean isuseauxpty = material.getBoolean("isuseauxpty");
                this.getView().setEnable(isuseauxpty, new String[]{"auxpty"});
                break;
            }
            case "number": 
            case "lotnumber": {
                this.relSpace(null, propName, 0);
                break;
            }
            case "sndimnumber": {
                this.relSpace("sndimentity", propName, index);
                break;
            }
        }
    }

    private String getSelectors() {
        StringBuilder sb = new StringBuilder();
        for (String col : COLS) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(col);
        }
        return sb.toString();
    }

    private Map<String, String> getBillStatusENToCN() {
        HashMap<String, String> billStatusENToCN = new HashMap<String, String>();
        billStatusENToCN.put("A", ResManager.loadKDString((String)"\u6682\u5b58", (String)"SNBillStatusTempoaryCN", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        billStatusENToCN.put("B", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"SNBillStatusSubmitCN", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        billStatusENToCN.put("C", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"SNBillStatusAuditCN", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        billStatusENToCN.put("D", ResManager.loadKDString((String)"\u5df2\u5220\u9664", (String)"SNBillStatusDeleteCN", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
        return billStatusENToCN;
    }

    private Map<String, String> getSNMoveTrackToSelectors() {
        HashMap<String, String> sNMoveTrackToSels = new HashMap<String, String>(16);
        sNMoveTrackToSels.put("fbizhappendate", "biztime");
        sNMoveTrackToSels.put("fbllentityid", "ebillentity");
        sNMoveTrackToSels.put("fbiztypeid", "biztype");
        sNMoveTrackToSels.put("fbillno", "ebillno");
        sNMoveTrackToSels.put("fsrcsupplierid", "supplier");
        sNMoveTrackToSels.put("fdescustomerid", "customer");
        sNMoveTrackToSels.put("fbizdeptid", "bizdept");
        sNMoveTrackToSels.put("fsrcinvorgid", "issueinvenorg");
        sNMoveTrackToSels.put("fsrcwarehouseid", "esrcwarehouse");
        sNMoveTrackToSels.put("fsrclocationid", "esrclocation");
        sNMoveTrackToSels.put("finlotnum", "inlotnum");
        sNMoveTrackToSels.put("foutlotnum", "outlotnum");
        sNMoveTrackToSels.put("fkeeporgid", "bizorg");
        sNMoveTrackToSels.put("fdeptid", "warehousedept");
        sNMoveTrackToSels.put("fwarehouseid", "bizwarehouse");
        sNMoveTrackToSels.put("flocationid", "bizlocation");
        sNMoveTrackToSels.put("fauditdate", "auditdate");
        sNMoveTrackToSels.put("fbillstatus", BILL_STATUS);
        return sNMoveTrackToSels;
    }

    private void relSpace(String entrykey, String currentkey, int index) {
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = entrykey != null ? model.getEntryRowEntity(entrykey, index) : model.getDataEntity();
        String currentValue = dynamicObject.getString(currentkey);
        if (currentValue != null) {
            currentValue = currentValue.replaceAll("\u3000", " ").trim();
            model.beginInit();
            if (entrykey != null) {
                model.setValue(currentkey, (Object)currentValue, index);
            } else {
                model.setValue(currentkey, (Object)currentValue);
            }
            model.endInit();
        }
    }

    private void addExecutionListDataProvider() {
        final BillList list = (BillList)this.getView().getControl("billlistap");
        if (list == null) {
            return;
        }
        list.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent evt) {
                evt.getQFilters().addAll(list.getFilterParameter().getQFilters());
            }
        });
        list.addCreateListDataProviderListener(new CreateListDataProviderListener(){

            public void createListDataProvider(BeforeCreateListDataProviderArgs e) {
                e.setListDataProvider((IListDataProvider)new ListDataProvider(){

                    public DynamicObjectCollection getData(int start, int limit) {
                        List extMoveCols;
                        DynamicObjectCollection cols = super.getData(start, limit);
                        if (cols != null && !cols.isEmpty() && !(extMoveCols = SnMainFilePlugin.this.getMoveEntryExtCols()).isEmpty()) {
                            SnMainFilePlugin.this.handlerExtColsValue(cols, extMoveCols);
                        }
                        return cols;
                    }
                });
            }
        });
    }

    private void handlerExtColsValue(DynamicObjectCollection cols, List<String> extMoveCols) {
        List trackIds = cols.stream().map(i -> i.get("id")).collect(Collectors.toList());
        Long mainFileId = (Long)this.getModel().getValue("id");
        StringBuilder selectCols = new StringBuilder();
        selectCols.append("trackid");
        for (String extMoveCol : extMoveCols) {
            selectCols.append(",").append(extMoveCol);
        }
        DynamicObjectCollection moveTrackInfo = QueryServiceHelper.query((String)"bd_snmovetrack_rel", (String)selectCols.toString(), (QFilter[])new QFilter[]{new QFilter("snmainfileid", "=", (Object)mainFileId).and("trackid", "in", trackIds)});
        HashMap<String, Object> extColValues = new HashMap<String, Object>();
        if (moveTrackInfo != null && !moveTrackInfo.isEmpty()) {
            for (DynamicObject info : moveTrackInfo) {
                for (String col : extMoveCols) {
                    extColValues.put(info.get("trackid") + CONNECTOR + col, info.get(col));
                }
            }
        }
        if (!extColValues.isEmpty()) {
            for (DynamicObject col : cols) {
                for (String extMoveCol : extMoveCols) {
                    col.set(extMoveCol, extColValues.get(col.get("id") + CONNECTOR + extMoveCol));
                }
            }
        }
    }
}

