/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.api.ProjectService;
import kd.bd.assistant.plugin.util.AssociatedTableModel;
import kd.bd.assistant.plugin.util.AutoPushOperation;
import kd.bd.assistant.plugin.util.AutoPushUtil;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ProjectServiceImpl
implements ProjectService {
    private Log log = LogFactory.getLog(ProjectServiceImpl.class);

    public DynamicObject updateProject(Object pkId, boolean refCheck) {
        DynamicObject newProject = null;
        try {
            newProject = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bd_project");
            newProject.set("refcheck", (Object)(refCheck ? 1 : 0));
            SaveServiceHelper.update((DynamicObject)newProject);
        }
        catch (Exception e) {
            this.log.error(String.format("update project [%s] error", pkId), (Throwable)e);
        }
        return newProject;
    }

    public DynamicObject updateProject(String projectNumber, Object createOrgId, boolean refCheck) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "=", (Object)projectNumber).and(new QFilter("createorg", "=", createOrgId)));
        DynamicObject project = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        DynamicObject newProject = null;
        if (project != null) {
            newProject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bd_project");
            newProject.set("refcheck", (Object)(refCheck ? 1 : 0));
            SaveServiceHelper.update((DynamicObject)newProject);
        }
        return newProject;
    }

    public DynamicObject updateProject(Object pkId, Map<String, Object> updateFieldMap) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bd_project");
        if (updateFieldMap == null || updateFieldMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u4e9b\u8981\u66f4\u65b0\u7684\u5b57\u6bb5\u3002", (String)"ProjectServiceImpl_1", (String)"bd-assistant-mservice", (Object[])new Object[0]));
        }
        for (Map.Entry<String, Object> entry : updateFieldMap.entrySet()) {
            project.set(entry.getKey(), entry.getValue());
        }
        SaveServiceHelper.update((DynamicObject)project);
        return project;
    }

    public DynamicObject createNewData(Object groupId, String projectNumber, String projectName, Object createOrgId, Object parentId, Date planbegindate, Date planenddate, String address, String source, boolean refCheck) {
        DynamicObject project = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"), (Object)ORM.create().genLongId((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_project")));
        project.set("number", (Object)projectNumber);
        project.set("name", (Object)projectName);
        project.set("planbegindate", (Object)planbegindate);
        project.set("planenddate", (Object)planenddate);
        project.set("proaddress", (Object)address);
        if (groupId != null && !groupId.toString().equals("0")) {
            DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"bd_projectkind");
            project.set("group", (Object)group);
        }
        if (createOrgId != null && !createOrgId.toString().equals("0")) {
            DynamicObject createOrg = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
            project.set("createorg", (Object)createOrg);
            project.set("org", (Object)createOrg);
            project.set("useorg", (Object)createOrg);
            project.set("pmascreateorg", (Object)createOrg);
            project.set("department", (Object)createOrg);
        }
        DynamicObject parent = null;
        if (parentId != null && !parentId.toString().equals("0")) {
            parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bd_project");
            project.set("parent", (Object)parent);
        }
        project.set("isleaf", (Object)1);
        if (parent == null) {
            project.set("level", (Object)1);
            project.set("longnumber", (Object)projectNumber);
            project.set("fullname", (Object)projectName);
        } else {
            project.set("level", (Object)(parent.getInt("level") + 1));
            project.set("longnumber", (Object)(parent.get("number") + "." + projectNumber));
            project.set("fullname", (Object)(parent.get("name") + "." + projectName));
        }
        project.set("status", (Object)"C");
        project.set("prostatus", (Object)"696208078613566464");
        project.set("enable", (Object)1);
        project.set("systemtype", (Object)source);
        project.set("refcheck", (Object)refCheck);
        project.set("issys", (Object)1);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bd_project", (DynamicObject[])new DynamicObject[]{project}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
        if (parent != null) {
            parent.set("isleaf", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
        }
        return project;
    }

    public DynamicObject createNewData(String projectNumber, Object projectName, Object createOrgId, String source) {
        return this.createNewData(0L, projectNumber, projectName, createOrgId, 0L, null, null, null, source);
    }

    public DynamicObject createNewData(Object groupId, String projectNumber, Object projectName, Object createOrgId, Object parentId, Date planbegindate, Date planenddate, String address, String source) {
        DynamicObject oldBdProject = BusinessDataServiceHelper.loadSingle((String)"bd_project", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)projectNumber)});
        if (oldBdProject != null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u7f16\u7801\u5728\u7cfb\u7edf\u4e91\u4e2d\u5df2\u88ab\u4f7f\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ProjectServiceImpl_0", (String)"bd-assistant-mservice", (Object[])new Object[0]), projectNumber));
        }
        DynamicObject project = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"), (Object)ORM.create().genLongId((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_project")));
        project.set("number", (Object)projectNumber);
        project.set("name", projectName);
        project.set("planbegindate", (Object)planbegindate);
        project.set("planenddate", (Object)planenddate);
        project.set("proaddress", (Object)address);
        if (groupId != null && !groupId.toString().equals("0")) {
            DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"bd_projectkind");
            project.set("group", (Object)group);
        }
        if (createOrgId != null && !createOrgId.toString().equals("0")) {
            DynamicObject createOrg = BusinessDataServiceHelper.loadSingle((Object)createOrgId, (String)"bos_org");
            project.set("createorg", (Object)createOrg);
            project.set("org", (Object)createOrg);
            project.set("useorg", (Object)createOrg);
            project.set("pmascreateorg", (Object)createOrg);
            project.set("department", (Object)createOrg);
        }
        DynamicObject parent = null;
        if (parentId != null && !parentId.toString().equals("0")) {
            parent = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"bd_project");
            project.set("parent", (Object)parent);
        }
        project.set("isleaf", (Object)1);
        if (parent == null) {
            project.set("level", (Object)1);
            project.set("longnumber", (Object)projectNumber);
            project.set("fullname", projectName);
        } else {
            project.set("level", (Object)(parent.getInt("level") + 1));
            project.set("longnumber", (Object)(parent.get("number") + "." + projectNumber));
            project.set("fullname", (Object)(parent.get("name") + "." + projectName));
        }
        project.set("status", (Object)"C");
        project.set("prostatus", (Object)"696208078613566464");
        project.set("enable", (Object)1);
        project.set("systemtype", (Object)source);
        project.set("issys", (Object)1);
        new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(new DynamicObject[]{project}, "bd_project");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bd_project", (DynamicObject[])new DynamicObject[]{project}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            throw new KDBizException(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
        if (parent != null) {
            parent.set("isleaf", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
        }
        return project;
    }

    public DynamicObject createNewData(Map<String, Object> map) {
        return this.createNewData("bd_project", map);
    }

    public DynamicObject createNewData(String entityId, Map<String, Object> map) {
        MainEntityType curDt = EntityMetadataCache.getDataEntityType((String)entityId);
        String projectNumber = (String)map.get("number");
        Object projectName = map.get("name");
        Object createOrg = map.get("createorg");
        if (StringUtils.isEmpty((CharSequence)projectNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectServiceImpl_2", (String)"bd-assistant-mservice", (Object[])new Object[0]));
        }
        if (projectName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectServiceImpl_3", (String)"bd-assistant-mservice", (Object[])new Object[0]));
        }
        if (createOrg == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProjectServiceImpl_4", (String)"bd-assistant-mservice", (Object[])new Object[0]));
        }
        DynamicObject oldBdProject = BusinessDataServiceHelper.loadSingle((String)entityId, (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)projectNumber)});
        if (oldBdProject != null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u7f16\u7801\u5728\u7cfb\u7edf\u4e91\u4e2d\u5df2\u88ab\u4f7f\u7528,\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ProjectServiceImpl_6", (String)"bd-assistant-mservice", (Object[])new Object[0]), projectNumber));
        }
        long newProId = ORM.create().genLongId((IDataEntityType)curDt);
        DynamicObject project = new DynamicObject((DynamicObjectType)curDt, (Object)newProId);
        DynamicObject parent = (DynamicObject)map.get("parent");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"parent")) {
                parent = (DynamicObject)value;
                project.set("isleaf", (Object)1);
                if (parent == null) {
                    project.set("level", (Object)1);
                    project.set("longnumber", (Object)projectNumber);
                    project.set("fullname", projectName);
                    continue;
                }
                project.set("level", (Object)(parent.getInt("level") + 1));
                project.set("longnumber", (Object)(parent.get("number") + "." + projectNumber));
                project.set("fullname", (Object)(parent.get("name") + "." + projectName));
                continue;
            }
            project.set(key, value);
        }
        Long orgCU = null;
        if (createOrg instanceof Long) {
            orgCU = (Long)createOrg;
        } else if (createOrg instanceof DynamicObject) {
            orgCU = (Long)((DynamicObject)createOrg).getPkValue();
        }
        if (orgCU != null) {
            String bdCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityId, (String)orgCU.toString());
            project.set("ctrlstrategy", (Object)bdCtrlStrgy);
        }
        project.set("createorg", createOrg);
        project.set("org", createOrg);
        project.set("useorg", createOrg);
        project.set("pmascreateorg", createOrg);
        project.set("department", createOrg);
        project.set("status", (Object)"C");
        project.set("enable", (Object)1);
        project.set("issys", (Object)1);
        new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(new DynamicObject[]{project}, "bd_project");
        OperationResult result = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                result = OperationServiceHelper.executeOperate((String)"save", (String)entityId, (DynamicObject[])new DynamicObject[]{project}, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    throw new KDBizException(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
                }
            }
            catch (Exception e) {
                if (result != null) {
                    this.log.error(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage(), (Throwable)e);
                } else {
                    this.log.error("OperationServiceHelper.executeOperate save failed.", (Throwable)e);
                }
                h.markRollback();
                throw e;
            }
        }
        if (parent != null) {
            try {
                parent = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)entityId);
                parent.set("isleaf", (Object)0);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
            }
            catch (Exception e) {
                this.delete(new Object[]{newProId});
                throw e;
            }
        }
        return project;
    }

    public DynamicObject createNewDataByConvertRule(DynamicObject dataEntity, String srcEntityId, String targetEntityId, String appId, String ruleId) {
        List<AssociatedTableModel> tableModels = Arrays.asList(new AssociatedTableModel("sys", "t_bd_project_tc"), new AssociatedTableModel("sys", "t_bd_project_lk"));
        AutoPushOperation ato = new AutoPushOperation(dataEntity.getPkValue(), srcEntityId, targetEntityId, appId, ruleId, tableModels);
        DynamicObject pro = ato.pushActionTx("audit");
        Object parentPro = dataEntity.get("parentpro");
        if (parentPro != null) {
            DynamicObject parentProEntity = (DynamicObject)parentPro;
            new BaseDataCommonService().generateBaseDataBitIndexAndSourceId(new DynamicObject[]{parentProEntity}, "bd_project");
            DynamicObject parentProject = BusinessDataServiceHelper.loadSingle((Object)parentProEntity.getPkValue(), (String)targetEntityId);
            parentProject.set("isleaf", (Object)0);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentProject});
        }
        return pro;
    }

    public void delete(Object[] pks) {
        if (pks != null && pks.length == 0) {
            return;
        }
        DynamicObject[] deletePros = BusinessDataServiceHelper.load((String)"bd_project", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        Set parentSet = Arrays.stream(deletePros).filter(deletePro -> deletePro.getDynamicObject("parent") != null).map(o -> o.getDynamicObject("parent").getPkValue()).collect(Collectors.toSet());
        try {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_project"), (Object[])pks);
        }
        catch (Exception e) {
            this.log.error("delete project error", (Throwable)e);
        }
        ArrayList<DynamicObject> updateParentPros = new ArrayList<DynamicObject>(parentSet.size());
        for (Object parentId : parentSet) {
            QFilter parentFilter = new QFilter("parent", "=", parentId);
            DynamicObject[] sonPros = BusinessDataServiceHelper.load((String)"bd_project", (String)"", (QFilter[])new QFilter[]{parentFilter});
            if (sonPros.length != 0) continue;
            DynamicObject parent = BusinessDataServiceHelper.loadSingle(parentId, (String)"bd_project");
            parent.set("isleaf", (Object)1);
            updateParentPros.add(parent);
        }
        DynamicObject[] updateParentProObjs = new DynamicObject[updateParentPros.size()];
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])updateParentPros.toArray(updateParentProObjs));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void deleteProAndAssociate(Object[] pks, Long[] srcBillPks) {
        if (pks != null && pks.length == 0) {
            return;
        }
        DynamicObject[] deletePros = BusinessDataServiceHelper.load((String)"bd_project", (String)"parent", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        Set parentSet = Arrays.stream(deletePros).filter(deletePro -> deletePro.getDynamicObject("parent") != null).map(o -> o.getDynamicObject("parent").getPkValue()).collect(Collectors.toSet());
        try {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_project"), (Object[])pks);
        }
        catch (Exception e) {
            this.log.error("delete project error", (Throwable)e);
        }
        ArrayList<DynamicObject> updateParentPros = new ArrayList<DynamicObject>(parentSet.size());
        for (Object parentId : parentSet) {
            QFilter parentFilter = new QFilter("parent", "=", parentId);
            DynamicObject[] sonPros = BusinessDataServiceHelper.load((String)"bd_project", (String)"", (QFilter[])new QFilter[]{parentFilter});
            if (sonPros.length != 0) continue;
            DynamicObject parent = BusinessDataServiceHelper.loadSingle(parentId, (String)"bd_project");
            parent.set("isleaf", (Object)1);
            updateParentPros.add(parent);
        }
        DynamicObject[] updateParentProObjs = new DynamicObject[updateParentPros.size()];
        Long[] longArray = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])updateParentPros.toArray(updateParentProObjs));
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable object) {
            longArray = object;
            throw object;
        }
        if (srcBillPks == null || srcBillPks.length == 0) {
            return;
        }
        List<AssociatedTableModel> tableModels = Arrays.asList(new AssociatedTableModel("sys", "t_bd_project_tc"), new AssociatedTableModel("sys", "t_bd_project_lk"));
        for (Long srcBillPk : srcBillPks) {
            AutoPushUtil.deleteAssociation((Long)srcBillPk, tableModels);
        }
    }
}

