/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang.StringUtils;

public class DateUtil {
    public static final String DATE_DEFAULT_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_DEFAULT_FORMAT = "HH:mm:ss";
    private static Log log = LogFactory.getLog(DateUtil.class);

    public static Date formatDate(String date, String format) {
        try {
            return new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public static String getDateFormat(Date date) {
        return new SimpleDateFormat(DATE_DEFAULT_FORMAT).format(date);
    }

    public static String getDateTimeFormat(Date date) {
        return new SimpleDateFormat(DATETIME_DEFAULT_FORMAT).format(date);
    }

    public static String getTimeFormat(Date date) {
        return new SimpleDateFormat(TIME_DEFAULT_FORMAT).format(date);
    }

    public static String getDateFormat(Date date, String formatStr) {
        if (StringUtils.isNotBlank((String)formatStr)) {
            return new SimpleDateFormat(formatStr).format(date);
        }
        return null;
    }

    public static Date getDateFormat(String date) {
        try {
            return new SimpleDateFormat(DATE_DEFAULT_FORMAT).parse(date);
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public static Date getDateTimeFormat(String date) {
        try {
            return new SimpleDateFormat(DATETIME_DEFAULT_FORMAT).parse(date);
        }
        catch (ParseException e) {
            log.info(e.getMessage());
            return null;
        }
    }

    public static Date getNowDate() {
        return DateUtil.getDateFormat(new SimpleDateFormat(DATE_DEFAULT_FORMAT).format(new Date()));
    }

    public static Date getFirstDayOfWeek() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(new Date());
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek());
        return gregorianCalendar.getTime();
    }

    public static Date getLastDayOfWeek() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(new Date());
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek() + 6);
        return gregorianCalendar.getTime();
    }

    public static Date getFirstDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek());
        return gregorianCalendar.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        if (date == null) {
            return null;
        }
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setFirstDayOfWeek(2);
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(7, gregorianCalendar.getFirstDayOfWeek() + 6);
        return gregorianCalendar.getTime();
    }

    public static Date getFirstDayOfMonth() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(new Date());
        gregorianCalendar.set(5, 1);
        return gregorianCalendar.getTime();
    }

    public static Date getLastDayOfMonth() {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(new Date());
        gregorianCalendar.set(5, 1);
        gregorianCalendar.add(2, 1);
        gregorianCalendar.add(5, -1);
        return gregorianCalendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        return gregorianCalendar.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        gregorianCalendar.add(2, 1);
        gregorianCalendar.add(5, -1);
        return gregorianCalendar.getTime();
    }

    public static Date getBeforeDay() {
        return DateUtil.getBeforeDay(new Date(), 1);
    }

    public static Date getBeforeDay(Date date) {
        return DateUtil.getBeforeDay(date, 1);
    }

    public static Date getBeforeDay(Date date, int count) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        int day = gregorianCalendar.get(5);
        gregorianCalendar.set(5, day - count);
        return gregorianCalendar.getTime();
    }

    public static Date getNextDate() {
        return DateUtil.getNextDate(new Date(), 1);
    }

    public static Date getNextDate(Date date) {
        return DateUtil.getNextDate(date, 1);
    }

    public static Date getNextDate(Date date, int count) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        int day = gregorianCalendar.get(5);
        gregorianCalendar.set(5, day + count);
        return gregorianCalendar.getTime();
    }

    public static int getNowYear() {
        Calendar d = Calendar.getInstance();
        return d.get(1);
    }

    public static int getNowMonth() {
        Calendar d = Calendar.getInstance();
        return d.get(2) + 1;
    }

    public static int getNowMonthDay() {
        Calendar d = Calendar.getInstance();
        return d.getActualMaximum(5);
    }

    public static List<Date> getEveryDay(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return null;
        }
        startDate = DateUtil.getDateFormat(DateUtil.getDateFormat(startDate));
        endDate = DateUtil.getDateFormat(DateUtil.getDateFormat(endDate));
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(startDate);
        dates.add(gregorianCalendar.getTime());
        while (gregorianCalendar.getTime().compareTo(endDate) < 0) {
            gregorianCalendar.add(5, 1);
            dates.add(gregorianCalendar.getTime());
        }
        return dates;
    }

    public static Date getBeforeMonth(int monty) {
        Calendar c = Calendar.getInstance();
        c.add(2, -monty);
        return c.getTime();
    }

    public static Date getDayFirst(Date date) {
        Calendar ca = Calendar.getInstance();
        if (date != null) {
            ca.setTime(date);
        }
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static Date getDayLast(Date date) {
        Calendar ca = Calendar.getInstance();
        if (date != null) {
            ca.setTime(date);
        }
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        ca.add(5, 1);
        ca.add(14, -1);
        return ca.getTime();
    }
}

