/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.valid.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.util.WfRecordHelper;
import kd.bos.ext.scmc.chargeagainst.valid.CaValida;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BillMessageValid
implements CaValida {
    private CaModelFieldCaChe modelField;
    private static final List<String> FILTER_BIZTYPES = new ArrayList<String>(16);
    private static final String ASYNC_STATUS_SUCCESS = "B";
    private static final List<String> CA_BILLS = new ArrayList<String>(16);
    private static final String FEE_COST = "I";
    private static final String FEE_SHARE = "D";
    private static final String ASYNC_STATUS = "asyncstatus";
    private static final String DOMAIN = "domain";
    private static final String DOMAIN_VMI = "6";
    private static final String IS_ALLOW_CA = "1";
    private boolean isSalesAgencyAllowCa = false;

    public static BillMessageValid build(CaModelFieldCaChe modelField) {
        BillMessageValid valid = new BillMessageValid();
        valid.setModelField(modelField);
        return valid;
    }

    @Override
    public void validate(List<DynamicObject> dataEntity) {
        this.isSalesAgencyAllowCa = this.getParam();
        this.checkBillMessage(dataEntity, Boolean.FALSE);
    }

    public void downBillValidate(List<DynamicObject> dataEntity) {
        this.checkBillMessage(dataEntity, Boolean.TRUE);
    }

    private boolean getParam() {
        String result = "";
        DBRoute route = new DBRoute("scm");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select forgid,fkey,fvalue from t_im_invdbparam where fkey = 'isSalesAgencyAllowCa'", new Object[0]);
        DataSet paramSet = DB.queryDataSet((String)"ChargeAgainstServer", (DBRoute)route, (SqlBuilder)sqlBuilder);
        Iterator iterator = paramSet.iterator();
        if (iterator.hasNext()) {
            Row param = (Row)iterator.next();
            result = param.getString("fvalue");
        }
        return IS_ALLOW_CA.equals(result);
    }

    private void checkBillMessage(List<DynamicObject> dataEntityList, Boolean isDownCheck) {
        List<Object> billIds = this.getBillIds(dataEntityList);
        Set<Object> snreSet = this.getSnreSet(billIds);
        Set<Object> feeDivideSet = this.getFeeDivideSet(billIds);
        Set<Object> reverseChange = this.getReverseChange(billIds);
        for (DynamicObject dataEntity : dataEntityList) {
            if (!isDownCheck.booleanValue()) {
                this.checkVirtBill(dataEntity);
                this.checkCoreBillIsVirtBill(dataEntity);
            }
            this.checkBillRange(dataEntity, isDownCheck);
            this.checkCommon(dataEntity);
            this.checkFeeDivideSet(dataEntity, feeDivideSet);
            this.getSnreSet(dataEntity, snreSet);
            WfRecordHelper.checkWfRecordBills(dataEntity, this.modelField);
        }
    }

    private void checkReverse(DynamicObject dataEntity, Set<Object> reverseChanges) {
        String billNo = CommonUtil.getBillNo(dataEntity);
        if (reverseChanges.contains(dataEntity.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u9884\u7559\u8f6c\u79fb\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_19", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo));
        }
    }

    private List<Object> getBillIds(List<DynamicObject> dataEntityList) {
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (DynamicObject ob : dataEntityList) {
            list.add(ob.getPkValue());
        }
        return list;
    }

    private void checkVerifyRecord(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        QFilter emptyQfilter = new QFilter("writeofftypeid", ">", (Object)0);
        if ("im_saloutbill".equals(billNumber)) {
            QFilter qFilter = new QFilter("billid", "=", dataEntity.getPkValue());
            qFilter.and("billtype", "=", (Object)billNumber);
            QFilter qFilterTwo = new QFilter("entry.e_billid", "=", dataEntity.getPkValue());
            qFilterTwo.and("entry.e_billtype", "=", (Object)billNumber);
            qFilter.or(qFilterTwo);
            qFilter.and(emptyQfilter);
            boolean isArVerifyrecord = QueryServiceHelper.exists((String)"ar_verifyrecord", (QFilter[])qFilter.toArray());
            if (isArVerifyrecord) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_7", (String)"bos-ext-scmc", (Object[])new Object[0]), CommonUtil.getBillNo(dataEntity)));
            }
        } else if ("im_purinbill".equals(billNumber)) {
            QFilter qFilter = new QFilter("billid", "=", dataEntity.getPkValue());
            qFilter.and("billtype", "=", (Object)billNumber);
            QFilter qFilterTwo = new QFilter("entry.e_billid", "=", dataEntity.getPkValue());
            qFilterTwo.and("entry.e_billtype", "=", (Object)billNumber);
            qFilter.or(qFilterTwo);
            qFilter.and(emptyQfilter);
            boolean isArVerifyrecord = QueryServiceHelper.exists((String)"ap_verifyrecord", (QFilter[])qFilter.toArray());
            if (isArVerifyrecord) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500", (String)"ChargeAgainstValid_7", (String)"bos-ext-scmc", (Object[])new Object[0]), CommonUtil.getBillNo(dataEntity)));
            }
        }
    }

    private void checkVirtBill(DynamicObject dataEntity) {
        String isVirtualBill1 = this.modelField.getCaModelField(dataEntity.getDataEntityType().getName()).getIsVirtualBill();
        if (!CommonUtil.isExistField(dataEntity, isVirtualBill1)) {
            return;
        }
        boolean isVirtualBill = dataEntity.getBoolean(isVirtualBill1);
        if (isVirtualBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u865a\u5355\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_9", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void checkBillRange(DynamicObject dataEntity, Boolean isDownCheck) {
        String billNo = CommonUtil.getBillNo(dataEntity);
        String billName = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
        String billNumber = dataEntity.getDataEntityType().getDisplayName().getLocaleValue();
        String billType = dataEntity.getDataEntityType().getName();
        if (!CA_BILLS.contains(billType)) {
            if (isDownCheck.booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0b\u6e38\u5355\u636e%s\u7684\u5355\u636e\u7c7b\u578b\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_10", (String)"bos-ext-scmc", (Object[])new Object[0]), billName, billNo, billNumber));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u7684\u5355\u636e\u7c7b\u578b\u4e3a%s\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_10", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo, billNumber));
        }
    }

    private void checkCommon(DynamicObject dataEntity) {
        boolean bizTypeIsAllowCa;
        String billNo = CommonUtil.getBillNo(dataEntity);
        boolean caBill = dataEntity.getBoolean(this.modelField.getCaModelField(dataEntity.getDataEntityType().getName()).getIsChargeOff());
        boolean alreadyCa = dataEntity.getBoolean(this.modelField.getCaModelField(dataEntity.getDataEntityType().getName()).getIsChargeOffed());
        if (caBill || alreadyCa) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u9500\u5355\u636e\u548c\u5df2\u88ab\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        String billStatusKey = ((BillEntityType)dataEntity.getDataEntityType()).getBillStatus();
        String billStatus = dataEntity.getString(billStatusKey);
        if ("A".equals(billStatus) || ASYNC_STATUS_SUCCESS.equals(billStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001\u4e3a\u975e\u201c\u6682\u5b58\u201d\u3001\u201c\u63d0\u4ea4\u201d\u72b6\u6001\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u51b2\u9500\u3002", (String)"ChargeAgainstValid_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        IDataEntityProperty bizTypeProp = ((BillEntityType)dataEntity.getDataEntityType()).findProperty("biztype");
        String number = "";
        if (bizTypeProp != null) {
            DynamicObject bizType = dataEntity.getDynamicObject("biztype");
            number = bizType.getString("number");
        }
        IDataEntityProperty invSchePerty = ((BillEntityType)dataEntity.getDataEntityType()).findProperty("invscheme");
        String invSchemeNum = "";
        if (invSchePerty != null) {
            DynamicObject invScheme = dataEntity.getDynamicObject("invscheme");
            invSchemeNum = invScheme.getString("number");
        }
        boolean isAllowCa = this.isSalesAgencyAllowCa && "230".equals(number) && "211".equals(invSchemeNum);
        boolean bl = bizTypeIsAllowCa = !isAllowCa && FILTER_BIZTYPES.contains(number);
        if (bizTypeIsAllowCa) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u59d4\u6258\u4ee3\u9500\u3001\u59d4\u5916\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        boolean isExist = CommonUtil.isExistField(dataEntity, ASYNC_STATUS);
        if (!isExist) {
            return;
        }
        String asyncStatus = dataEntity.getString(ASYNC_STATUS);
        if (!ASYNC_STATUS_SUCCESS.equals(asyncStatus)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u5f02\u6b65\u670d\u52a1\u672a\u6267\u884c\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_6", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo));
        }
    }

    private void checkFeeDivideSet(DynamicObject dataEntity, Set<Object> feeDivideSet) {
        String billNo = CommonUtil.getBillNo(dataEntity);
        if (feeDivideSet.contains(dataEntity.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u8d39\u7528\u5206\u644a\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_12", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo));
        }
    }

    private Set<Object> getFeeDivideSet(List<Object> billIds) {
        HashSet<Object> feeDivideBills = new HashSet<Object>();
        QFilter qFilter = new QFilter("bizbillid", "in", billIds);
        DynamicObject[] costRecords = BusinessDataServiceHelper.load((String)"cal_costrecord", (String)"billno,bizbillid,subentryentity.id,subentryentityest.id", (QFilter[])qFilter.toArray());
        ArrayList<Object> list = new ArrayList<Object>(12);
        for (DynamicObject record : costRecords) {
            list.add(record.getPkValue());
        }
        boolean hasAdjust = this.isHasAdjust(list);
        for (DynamicObject record : costRecords) {
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entry");
            Object bizBillId = record.get("bizbillid");
            for (DynamicObject entry : entrys) {
                DynamicObjectCollection divideEntry = entry.getDynamicObjectCollection("subentryentity");
                DynamicObjectCollection estimateEntry = entry.getDynamicObjectCollection("subentryentityest");
                if (CollectionUtils.isEmpty((Collection)estimateEntry) && CollectionUtils.isEmpty((Collection)divideEntry) && !hasAdjust) continue;
                feeDivideBills.add(bizBillId);
            }
        }
        return feeDivideBills;
    }

    private boolean isHasAdjust(List<Object> list) {
        ArrayList<String> createTypeList = new ArrayList<String>();
        createTypeList.add(FEE_COST);
        createTypeList.add(FEE_SHARE);
        QFilter qFilter1 = new QFilter("entryentity.invbillid", "in", list);
        qFilter1.and("createtype", "in", createTypeList);
        return QueryServiceHelper.exists((String)"cal_costadjustbill", (QFilter[])qFilter1.toArray());
    }

    private Set<Object> getSnreSet(List<Object> billIds) {
        QFilter qFilterSnre = new QFilter("billid", "in", billIds);
        DynamicObjectCollection snreList = QueryServiceHelper.query((String)"sbs_billsnrelation", (String)"billid", (QFilter[])qFilterSnre.toArray());
        HashSet<Object> set = new HashSet<Object>(16);
        for (DynamicObject snre : snreList) {
            set.add(snre.get("billid"));
        }
        return set;
    }

    private Set<Object> getReverseChange(List<Object> billIds) {
        QFilter qFilterSnre = new QFilter("billid", "in", billIds);
        DynamicObjectCollection snreList = QueryServiceHelper.query((String)"msmod_reservetrans", (String)"billid", (QFilter[])qFilterSnre.toArray());
        HashSet<Object> set = new HashSet<Object>(16);
        for (DynamicObject snre : snreList) {
            set.add(snre.get("billid"));
        }
        return set;
    }

    private void getSnreSet(DynamicObject dataEntity, Set<Object> snreSet) {
        String billNo = CommonUtil.getBillNo(dataEntity);
        if (snreSet.contains(dataEntity.getPkValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u5e8f\u5217\u53f7\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_13", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo));
        }
    }

    private void checkCoreBillIsVirtBill(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        if (!"im_saloutbill".equals(billNumber) && !"im_purinbill".equals(billNumber)) {
            return;
        }
        HashMap<String, HashSet<Long>> mainBills = new HashMap<String, HashSet<Long>>(16);
        DynamicObjectCollection billEntryList = dataEntity.getDynamicObjectCollection("billentry");
        for (DynamicObject billEntry : billEntryList) {
            Long mainBillId = billEntry.getLong("mainbillid");
            String mainBillEntity = billEntry.getString("mainbillentity");
            if (!StringUtils.isNotEmpty((CharSequence)mainBillEntity)) continue;
            HashSet<Long> billIds = (HashSet<Long>)mainBills.get(mainBillEntity);
            if (CollectionUtils.isEmpty((Collection)billIds)) {
                billIds = new HashSet<Long>(16);
            }
            billIds.add(mainBillId);
            mainBills.put(mainBillEntity, billIds);
        }
        for (Map.Entry mainBill : mainBills.entrySet()) {
            String isVirtualBillField;
            String billType = (String)mainBill.getKey();
            boolean existField = CommonUtil.isExistField(billType, isVirtualBillField = this.modelField.getCaModelField(billType).getIsVirtualBill());
            if (!existField) continue;
            QFilter qFilter = new QFilter(isVirtualBillField, "=", (Object)Boolean.TRUE);
            qFilter.and("id", "in", mainBill.getValue());
            boolean exists = QueryServiceHelper.exists((String)((String)mainBill.getKey()), (QFilter[])qFilter.toArray());
            if (!exists) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u5fc3\u5355\u636e\u4e3a\u865a\u5355\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void setModelField(CaModelFieldCaChe modelField) {
        this.modelField = modelField;
    }

    static {
        FILTER_BIZTYPES.add("230");
        FILTER_BIZTYPES.add("2301");
        FILTER_BIZTYPES.add("4011");
        FILTER_BIZTYPES.add("4051");
        FILTER_BIZTYPES.add("408");
        FILTER_BIZTYPES.add("4041");
        FILTER_BIZTYPES.add("4031");
        CA_BILLS.add("im_transdirbill");
        CA_BILLS.add("im_saloutbill");
        CA_BILLS.add("im_purinbill");
        CA_BILLS.add("im_purreceivebill");
        CA_BILLS.add("im_otherinbill");
        CA_BILLS.add("im_materialreqoutbill");
        CA_BILLS.add("im_adjustbill");
        CA_BILLS.add("im_assembbill");
        CA_BILLS.add("im_disassemblebill");
        CA_BILLS.add("im_locationtransfer");
        CA_BILLS.add("im_transinbill");
        CA_BILLS.add("im_transoutbill");
        CA_BILLS.add("im_productinbill");
        CA_BILLS.add("im_otheroutbill");
        CA_BILLS.add("im_mdc_mftproorder");
        CA_BILLS.add("im_mdc_mftreturnorder");
        CA_BILLS.add("im_mdc_mftfeedorder");
        CA_BILLS.add("im_mdc_mftmanuinbill");
        CA_BILLS.add("im_mdc_mftreturnbill");
        CA_BILLS.add("im_mdc_omcmplinbill");
        CA_BILLS.add("im_mdc_omfeedbill");
        CA_BILLS.add("im_mdc_omoutbill");
        CA_BILLS.add("im_mdc_omreturnbill");
    }
}

