/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.freeze;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.ArrayUtils;

public class UnFreezeOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(UnFreezeOpAction.class);
    private static final String SCENES_CODE = "msmod_unfreeze_mservice";
    private static final String CLOUD_ID = "mpscmm";
    private static final String APP_ID = "mscommon";
    private static final String SERVICE_NAME = "UnFreezeECService";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        Object[] entities = e.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])entities)) {
            return;
        }
        this.process((DynamicObject[])entities, e.getOperationKey());
    }

    private void process(DynamicObject[] entities, String operationKey) {
        String entityNumber = this.billEntityType.getName();
        List ids = Stream.of(entities).map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
        log.info("\u5355\u636e\u6807\u8bc6:{},\u5355\u636eid:{},\u64cd\u4f5c\u7f16\u7801:{}", new Object[]{entityNumber, ids, operationKey});
        try {
            BillEntityType entityType = (BillEntityType)entities[0].getDataEntityType();
            String entityTypeStr = entityType.getName();
            String idKey = entityType.getPrimaryKey().getName();
            ArrayList<Long> billIds = new ArrayList<Long>(entities.length);
            ArrayList<String> businessInfoList = new ArrayList<String>(entities.length);
            for (DynamicObject entity : entities) {
                long id = entity.getLong(idKey);
                billIds.add(id);
                businessInfoList.add(entityTypeStr + "#" + id);
            }
            CommonParam param = new CommonParam();
            param.put((Object)"entityNumber", (Object)entityType.getName());
            param.put((Object)"ids", (Object)SerializationUtils.toJsonString(billIds));
            param.put((Object)"operationKey", (Object)operationKey);
            param.put((Object)"traceId", (Object)RequestContext.get().getTraceId());
            this.execute(SCENES_CODE, null, CLOUD_ID, APP_ID, SERVICE_NAME, this.billEntityType.getDBRouteKey(), businessInfoList, (Param)param, null);
        }
        catch (KDException ex) {
            log.error("\u89e3\u51bb\u670d\u52a1\u5f02\u5e38KDException", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            log.error("\u89e3\u51bb\u670d\u52a1\u5f02\u5e38Exception", (Object)ex.getMessage());
            throw ex;
        }
    }

    private void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String serviceName, String dbRoute, List<String> businessInfo, Param param, String bizId) throws KDException {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((CharSequence)KdtxRequestContext.get().getXid())) {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)dbRoute));
            ECGlobalSession.setBusinessType((String)"UnFreezeOpAction");
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
        ECGlobalSession.setAsync((boolean)false);
    }
}

