/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.func;

import java.util.Arrays;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GetSettleRelationValue
implements BOSUDFunction {
    private static final String FIELD_LOCATION_HEAD = "0";
    private static final String FIELD_LOCATION_ENTRY = "1";
    private static final String DEFINE_PATH_FIRST = "0";
    private static final String DEFINE_PATH_CURRENT = "1";
    private static final String DEFINE_PATH_LAST = "2";
    private static final String ISM_PREFIX = "ism@";
    private ExpressionContext ec;

    public GetSettleRelationValue() {
    }

    public GetSettleRelationValue(ExpressionContext ec) {
        this.ec = ec;
    }

    public Object call(Object ... params) {
        CRExpressionContext crec = (CRExpressionContext)this.ec;
        Map variables = crec.getOption().getVariables();
        String settleRelationId = (String)variables.get("settleRelation");
        String entryRelationId = (String)variables.get("entrysettleRelation");
        String value = null;
        if (StringUtils.isEmpty((CharSequence)settleRelationId)) {
            StringBuilder str = new StringBuilder();
            str.append(this.getName());
            str.append(Arrays.toString(params));
            str.append(ResManager.loadKDString((String)"\u5f53\u524dBOTP\u6267\u884c\u81ea\u5b9a\u4e49\u53c2\u6570\u4e2d\u6ca1\u6709\u7ed3\u7b97\u5173\u7cfbID\uff0c\u65e0\u6cd5\u4f7f\u7528\u8be5\u51fd\u6570\u3002", (String)"NoSettleRelation", (String)"bos-ext-scmc", (Object[])new Object[0]));
            throw new KDBizException(str.toString());
        }
        if (params.length != 3) {
            StringBuilder str = new StringBuilder();
            str.append(this.getName());
            str.append(Arrays.toString(params));
            str.append(ResManager.loadKDString((String)"\u51fd\u6570\u53c2\u6570\u914d\u7f6e\u5f02\u5e38", (String)"FunctionConfigErro", (String)"bos-ext-scmc", (Object[])new Object[0]));
            throw new KDBizException(str.toString());
        }
        String relationField = (String)params[0];
        String fieldLocation = (String)params[1];
        String path = (String)params[2];
        if (variables.containsKey("ism@funcCache") && (value = this.getValueFromCache(relationField, fieldLocation, settleRelationId, entryRelationId, path, variables)) != null) {
            return Long.valueOf(value);
        }
        return this.getValueFromDB(relationField, fieldLocation, settleRelationId, entryRelationId, path);
    }

    private Object getValueFromDB(String relationField, String fieldLocation, String settleRelationId, String entryRelationId, String path) {
        DynamicObject entry;
        DynamicObject value = null;
        String selectField = "0".equals(fieldLocation) ? relationField : "settlerelationdetail.".concat(relationField);
        DynamicObject relation = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(settleRelationId), (String)"ism_settlerelations", (String)selectField);
        if ("0".equals(fieldLocation)) {
            value = relation.getDynamicObject(relationField);
        } else if ("1".equals(fieldLocation) && (entry = this.getEntrySettleRelation(entryRelationId, path, relation)) != null) {
            value = entry.getDynamicObject(relationField);
        }
        if (value != null) {
            return value.getPkValue();
        }
        return 0L;
    }

    private String getValueFromCache(String relationField, String fieldLocation, String settleRelationId, String entryRelationId, String path, Map<String, String> variables) {
        if ("0".equals(fieldLocation)) {
            return variables.get(ISM_PREFIX + relationField);
        }
        if ("1".equals(fieldLocation)) {
            if (path.equals("0")) {
                String fristEntryId = variables.get("ism@fristEntry");
                return variables.get(ISM_PREFIX + fristEntryId + "@" + relationField);
            }
            if (path.equals("1")) {
                return variables.get(ISM_PREFIX + entryRelationId + "@" + relationField);
            }
            if (path.equals(DEFINE_PATH_LAST)) {
                String lastEntryId = variables.get("ism@lastEntry");
                return variables.get(ISM_PREFIX + lastEntryId + "@" + relationField);
            }
        }
        return null;
    }

    private DynamicObject getEntrySettleRelation(String entryRelationId, String path, DynamicObject relation) {
        DynamicObjectCollection detail = relation.getDynamicObjectCollection("settlerelationdetail");
        DynamicObject entryRelation = null;
        if (path.equals("0")) {
            entryRelation = (DynamicObject)detail.get(0);
        } else if (path.equals("1")) {
            for (DynamicObject dentry : detail) {
                String entryId = dentry.getString("id");
                if (!entryId.equals(entryRelationId)) continue;
                entryRelation = dentry;
                break;
            }
        } else if (path.equals(DEFINE_PATH_LAST)) {
            entryRelation = (DynamicObject)detail.get(detail.size() - 1);
        }
        return entryRelation;
    }

    public String getName() {
        return "getSettleRelationValue";
    }

    public BOSUDFunction getInstance(ExpressionContext ec) {
        return new GetSettleRelationValue(ec);
    }
}

