/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.DispatchServiceHelper;

public class InterOrgSettleOp
extends FormOperate {
    public OperationResult invokeOperation() {
        Map<Long, String> billNos = this.getOperateIdBillNos();
        OperationResult opResult = new OperationResult();
        opResult.getSuccessPkIds().addAll(billNos.keySet());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ism", (String)"SettleBillService", (String)"batchGenerateSettleBill", (Object[])new Object[]{new ArrayList<Long>(billNos.keySet()), this.getEntityId()});
        Boolean isSuccess = (Boolean)result.get("isSuccess");
        if (!isSuccess.booleanValue()) {
            this.buildFailInfo(opResult, result, billNos);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u6267\u884c\u6210\u529f\u3002", (String)"intersettlesuccess", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        return opResult;
    }

    private void buildFailInfo(OperationResult opResult, Map<String, Object> result, Map<Long, String> billNos) {
        String failInfo = (String)result.get("info");
        Map failInfos = (Map)SerializationUtils.fromJsonString((String)failInfo, Map.class);
        HashMap<Long, String> allErroInfos = new HashMap<Long, String>(16);
        for (Map.Entry entry : failInfos.entrySet()) {
            Long l = Long.valueOf((String)entry.getKey());
            StringBuilder strs = new StringBuilder();
            for (Map failDetail : (List)entry.getValue()) {
                String code = (String)failDetail.get("code");
                String message = (String)failDetail.get("message");
                if ("ISMEC-BZ0005".equals(code)) continue;
                strs.append(message);
            }
            if (strs.length() <= 0) continue;
            allErroInfos.put(l, strs.toString());
        }
        if (!allErroInfos.isEmpty()) {
            StringBuilder strs = new StringBuilder();
            for (Map.Entry entry : allErroInfos.entrySet()) {
                Long billId = (Long)entry.getKey();
                String erroInfo = (String)entry.getValue();
                OperateErrorInfo errorInfo = new OperateErrorInfo(erroInfo, ErrorLevel.FatalError, entry.getKey());
                opResult.addErrorInfo(errorInfo);
                strs.append(String.format("%1s:%2s", billNos.get(billId), erroInfo));
            }
            IFormView iFormView = this.getView();
            if (iFormView != null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ed3\u7b97\u6267\u884c\u5931\u8d25", (String)"ismSettleExecuteFail", (String)"bos-ext-scmc", (Object[])new Object[0]), strs.toString(), MessageTypes.Image_m);
            }
        }
    }

    public Map<Long, String> getOperateIdBillNos() {
        IFormView view = this.getView();
        HashMap<Long, String> ids = new HashMap<Long, String>(16);
        if (view instanceof BillView) {
            DynamicObject bill = this.getView().getModel().getDataEntity();
            long id = this.getView().getModel().getDataEntity().getLong("id");
            if (id == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"plsSaveBill", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            String billNo = "";
            String billNoKey = ((BillEntityType)bill.getDataEntityType()).getBillNo();
            if (StringUtils.isNotEmpty((CharSequence)billNoKey)) {
                billNo = bill.getString(billNoKey);
            }
            ids.put(id, billNo);
        } else if (view instanceof ListView) {
            for (ListSelectedRow row : this.getListSelectedData()) {
                ids.put((Long)row.getPrimaryKeyValue(), row.getBillNo());
            }
        }
        return ids;
    }
}

