/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.operation.helper.NoUpdateFieldsAnalysisExtHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.FormOperate;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;

public class InventoryQuery
extends FormOperate {
    private static final Log log = LogFactory.getLog(InventoryQuery.class);
    private static final String NEWCFG_ENABLE = "1";
    private static final String KEY_METADATAKEY = "metadatakey";
    private static final String KEY_CURRENTMETADATAKEY = "currentmetadatakey";
    private static final String KEY_QFILTER = "qfilter";
    private static final String KEY_UPDATE = "update";
    private static final String KEY_MATCH = "match";
    private static final String KEY_ORDER = "returnorder";
    private static final String KEY_RETURNCLNO = "returncolno";
    private static final String KEY_RETURNCL = "returncol";
    private static final String BD_MATERIAL = "bd_material";
    private static final String IM_MATERIALINVACC = "im_materialinvacc";
    private static final String INVQUERYCONF_META = "im_invqueryconf";
    private static final String CFG_SRCBILLOBJ = "srcbillobj";
    private static final String CFG_SRCBILLENTRY = "srcbillentry";
    private static final String CFG_OPERATEKEY = "operatekey";
    private static final String CFG_ENABLE = "enable";
    private static final String MATERIALINVACC_CALLBACK = "materialinvaccCallBack";
    private static final String CLASS_CALLBACK = "kd.bos.ext.scmc.operation.InventoryQueryCallBack";
    private static final String BILL_STATUS_A = "A";
    private static final String KEY_FIELDMUSTINPUT = "fieldmustinput";
    public static final String MUSTSELECTENTRY = "mustselectentry";
    public static final String INVFILTER = "invfilterjson_tag";
    public static final String FILTERENTRY = "filterentry";
    public static final String PREFILTERJSON_TAG = "prefilterjson_tag";
    public static final String IM_INV_REALBALANCE = "im_inv_realbalance";
    private String billtype;
    private String entrykey;
    private String operatekey;
    private int[] rows;
    private int row = -1;
    private Map<String, Object> mapParam;
    private boolean isDraw = false;
    private static final Set<String> enableApps = new HashSet<String>(Arrays.asList("im", "pm", "sm"));

    public void initialize(Map<String, Object> opMeta) {
        super.initialize(opMeta);
        this.operatekey = (String)opMeta.get("key");
        Map custParamObj = (Map)opMeta.get("parameter");
        String paramValue = (String)custParamObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? Collections.emptyMap() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        this.billtype = this.getEntityId();
        if (InventoryQuery.isUseNewCfg()) {
            DynamicObject cfg = this.getInvQueryCfg();
            if (cfg == null) throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5c1a\u672a\u914d\u7f6e\u5e93\u5b58\u67e5\u8be2\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"InventoryQuery_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.entrykey = cfg.getString(CFG_SRCBILLENTRY);
            this.getMapparamFromCfg(cfg);
        } else {
            if (this.mapParam.isEmpty()) throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5c1a\u672a\u914d\u7f6e\u5e93\u5b58\u67e5\u8be2\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"InventoryQuery_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
            this.setOldMapparam();
        }
        this.isDraw = this.isDrawByBOTP();
        EntryGrid entryGrid = (EntryGrid)view.getControl(this.entrykey);
        this.rows = entryGrid.getSelectRows();
        if (this.rows.length > 0) {
            this.row = this.rows[0];
        }
        if (this.row < 0 && (this.isDraw || this.getMustSelectEntry())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u4f53\u540e\uff0c\u518d\u67e5\u8be2\u5e93\u5b58\u3002", (String)"mustSelectEntry", (String)"bos-ext-scmc", (Object[])new Object[0]));
            return super.invokeOperation();
        }
        if (!this.checkMustInputFields()) {
            return super.invokeOperation();
        }
        String kitResult = this.checkKitProductType();
        if ("false".equals(kitResult)) {
            return super.invokeOperation();
        }
        JSONObject param = new JSONObject();
        JSONObject fieldQFilter = this.getJsonObjectQFilterByBillField();
        param.put("qfilterfield", (Object)fieldQFilter);
        param.put("billType", (Object)this.billtype);
        log.info("\u89e3\u6790\u4e4b\u540e\u8fc7\u6ee4\u5b57\u6bb5\u4fe1\u606f:" + fieldQFilter);
        this.fillExpandFilterAndUpdateFields(view, param);
        param.put("mapparam", this.mapParam);
        param.put("isDraw", (Object)this.isDraw);
        if (StringUtils.isNotBlank((CharSequence)kitResult)) {
            param.put("kitResult", (Object)kitResult);
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IM_MATERIALINVACC);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2", (String)"InventoryQuery_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
        parameter.setCustomParam("param", (Object)param);
        Map settingParam = (Map)this.mapParam.get("settingparam");
        String dealType = (String)settingParam.get("dealtype");
        if ("systemdeal".equals(dealType)) {
            parameter.setCloseCallBack(new CloseCallBack(CLASS_CALLBACK, MATERIALINVACC_CALLBACK));
        } else if ("plugindeal".equals(dealType)) {
            String pluginName = (String)settingParam.get("pluginname");
            String actionId = (String)settingParam.get("actionid");
            parameter.setCloseCallBack(new CloseCallBack(pluginName, actionId));
        }
        view.showForm(parameter);
        view.returnDataToParent(this.mapParam);
        return super.invokeOperation();
    }

    private boolean getMustSelectEntry() {
        boolean mustSelectEntry = false;
        Map settingParam = (Map)this.mapParam.get("settingparam");
        if (settingParam.get(MUSTSELECTENTRY) != null) {
            mustSelectEntry = (Boolean)settingParam.get(MUSTSELECTENTRY);
        }
        return mustSelectEntry;
    }

    private static boolean isUseNewCfg() {
        DynamicObject invdbParam = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"newInvqryCfg").toArray());
        return invdbParam != null && NEWCFG_ENABLE.equals(invdbParam.getString("value"));
    }

    private DynamicObject getInvQueryCfg() {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)INVQUERYCONF_META, (QFilter[])new QFilter(CFG_SRCBILLOBJ, "=", (Object)this.billtype).and(CFG_OPERATEKEY, "=", (Object)this.operatekey).and(CFG_ENABLE, "=", (Object)NEWCFG_ENABLE).toArray());
        if (cfgs == null || cfgs.isEmpty()) {
            return null;
        }
        if (cfgs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\u4e86\u591a\u4e2a\u542f\u7528\u89c4\u5219\uff0c\u8bf7\u7981\u7528\u6216\u8005\u5220\u9664\u591a\u4f59\u7684\u89c4\u5219\u3002", (String)"InventoryQuery_6", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        return cfgs.values().toArray(new DynamicObject[0])[0];
    }

    private void getMapparamFromCfg(DynamicObject cfg) {
        Map settingParam = this.mapParam.getOrDefault("settingparam", new HashMap(12));
        settingParam.put("entrykey", this.entrykey);
        settingParam.put(CFG_OPERATEKEY, this.operatekey);
        settingParam.put("returntype", cfg.get("returntype"));
        settingParam.put("dealtype", cfg.get("dealtype"));
        settingParam.put("qtyrule", cfg.get("qtyrule"));
        settingParam.put("proqtyfield", cfg.get("proqtyfield"));
        settingParam.put("actionid", cfg.get("actionid"));
        settingParam.put("newdeal", cfg.get("newdeal"));
        settingParam.put("entrynoupdatefieldkey", cfg.get("entrynoupdatefieldkey"));
        settingParam.put("pluginname", cfg.get("pluginname"));
        settingParam.put("filterpluginname", cfg.get("filterpluginname"));
        settingParam.put("unittran", cfg.get("unittran"));
        settingParam.put("middleinsert", cfg.get("middleinsert"));
        settingParam.put(MUSTSELECTENTRY, cfg.get(MUSTSELECTENTRY));
        List<QFilter> invFilters = this.getInvFilters(cfg);
        settingParam.put(INVFILTER, invFilters);
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("entryentity");
        List fields = this.mapParam.getOrDefault("fielddata", new ArrayList(entries.size()));
        fields.clear();
        for (DynamicObject entry : entries) {
            HashMap<String, Object> field = new HashMap<String, Object>(9);
            field.put("row", entry.getInt("seq") - 1);
            field.put(KEY_METADATAKEY, entry.get("invacccol"));
            field.put("metadata", entry.get("invacccolno"));
            field.put(KEY_CURRENTMETADATAKEY, entry.get("srcbillcol"));
            field.put("currentmetadata", entry.get("srcbillcolno"));
            field.put(KEY_QFILTER, entry.get(KEY_QFILTER));
            field.put(KEY_UPDATE, entry.get(KEY_UPDATE));
            field.put(KEY_MATCH, entry.get(KEY_MATCH));
            field.put(KEY_ORDER, entry.get(KEY_ORDER));
            field.put(KEY_FIELDMUSTINPUT, entry.get(KEY_FIELDMUSTINPUT));
            field.put(KEY_RETURNCLNO, entry.get(KEY_RETURNCLNO));
            field.put(KEY_RETURNCL, entry.get(KEY_RETURNCL));
            fields.add(field);
        }
        fields.sort(new MapFieldComparator());
    }

    private List<QFilter> getInvFilters(DynamicObject cfg) {
        IDataModel model = this.getView().getModel();
        MainEntityType dataEntityType = model.getDataEntityType();
        MainEntityType balEntityType = MetadataServiceHelper.getDataEntityType((String)IM_INV_REALBALANCE);
        DynamicObjectCollection filterEntries = cfg.getDynamicObjectCollection(FILTERENTRY);
        ArrayList<QFilter> invFilters = new ArrayList<QFilter>();
        for (DynamicObject filterEntry : filterEntries) {
            String invFilterJson;
            FilterCondition filterCondition;
            FilterBuilder filterBuilder;
            String filterScript;
            String preFilterJson = filterEntry.getString(PREFILTERJSON_TAG);
            boolean matchPreFilter = true;
            if (StringUtils.isNotEmpty((CharSequence)preFilterJson) && !StringUtils.isEmpty((CharSequence)(filterScript = (filterBuilder = new FilterBuilder(dataEntityType, filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)preFilterJson, FilterCondition.class))).buildFilterScript()[0]))) {
                String[] variables = FormulaEngine.extractVariables((String)filterScript);
                HashMap<String, Object> params = new HashMap<String, Object>();
                for (String variable : variables) {
                    params.put(variable, model.getDataEntity().get(variable));
                }
                matchPreFilter = (Boolean)FormulaEngine.execExcelFormula((String)filterScript, params);
            }
            if (!matchPreFilter || !StringUtils.isNotEmpty((CharSequence)(invFilterJson = filterEntry.getString(INVFILTER)))) continue;
            FilterCondition invFilterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)invFilterJson, FilterCondition.class);
            FilterBuilder builder = new FilterBuilder(balEntityType, invFilterCondition);
            builder.buildFilter();
            invFilters.add(builder.getQFilter());
        }
        return invFilters;
    }

    private void setOldMapparam() {
        List fields = (List)this.mapParam.get("fielddata");
        if (fields.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5931\u8d25\uff0c\u8be5\u5355\u636e\u5c1a\u672a\u914d\u7f6e\u5e93\u5b58\u67e5\u8be2\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"InventoryQuery_11", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        for (Map field : fields) {
            String invAccFieldKey = (String)field.get(KEY_METADATAKEY);
            field.put(KEY_ORDER, InventoryQuery.getDefaultReturnOrder(invAccFieldKey));
        }
        fields.sort(new MapFieldComparator());
        this.entrykey = this.getBillEntryKeyFromMeta(fields);
        Map settingParam = this.mapParam.getOrDefault("settingparam", new HashMap(12));
        settingParam.put("entrykey", this.entrykey);
        settingParam.put(CFG_OPERATEKEY, this.operatekey);
        settingParam.put("unittran", false);
        settingParam.put("middleinsert", false);
        settingParam.put(MUSTSELECTENTRY, false);
    }

    private String getBillEntryKeyFromMeta(List<Map<String, Object>> fields) {
        if (null == fields || fields.size() == 0) {
            return null;
        }
        for (Map<String, Object> field : fields) {
            String currentKey = (String)field.get(KEY_CURRENTMETADATAKEY);
            if (currentKey == null || currentKey.indexOf(46) == -1) continue;
            String[] keys = currentKey.split("\\.");
            String entityKey = keys[keys.length - 2];
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
            if (entryGrid == null) continue;
            return entityKey;
        }
        return null;
    }

    private boolean isDrawByBOTP() {
        IDataEntityProperty dataEntityProperty;
        if (this.entrykey == null || StringUtils.isBlank((CharSequence)this.entrykey)) {
            return false;
        }
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection entrys = model.getEntryEntity(this.entrykey);
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)model.getDataEntityType().getName());
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        String linkEntityKey = this.getEntryLinkEntityKey();
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!this.entrykey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = model.getDataEntityType().findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private JSONObject getJsonObjectQFilterByBillField() {
        JSONObject fieldQFilter = new JSONObject();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        List fields = (List)this.mapParam.get("fielddata");
        Map settingParam = (Map)this.mapParam.get("settingparam");
        String entryNoUpdateFieldkey = (String)settingParam.get("entrynoupdatefieldkey");
        if (entryNoUpdateFieldkey != null) {
            entryNoUpdateFieldkey = entryNoUpdateFieldkey.trim();
        }
        if (fields != null) {
            boolean validMultiRowsFlag = true;
            NoUpdateFieldsAnalysisExtHelper.setNoUpdateFields(this.getView().getModel(), entryNoUpdateFieldkey, fields);
            List<String> entryNoUpdateFieldValueList = Collections.emptyList();
            if (null != entryNoUpdateFieldkey && !entryNoUpdateFieldkey.isEmpty() && this.row > -1) {
                String entryNoUpdateFieldValue = (String)model.getValue(entryNoUpdateFieldkey, this.row);
                entryNoUpdateFieldValueList = NoUpdateFieldsAnalysisExtHelper.getNoUpdateFieldsList(entryNoUpdateFieldValue);
            }
            for (Map field : fields) {
                boolean isQFilter = (Boolean)field.get(KEY_QFILTER);
                if (!isQFilter) continue;
                String currentKey = (String)field.get(KEY_CURRENTMETADATAKEY);
                String metaKey = (String)field.get(KEY_METADATAKEY);
                if (StringUtils.isBlank((CharSequence)currentKey)) {
                    fieldQFilter.put(metaKey, null);
                    continue;
                }
                if (currentKey.indexOf(46) != -1) {
                    if (validMultiRowsFlag) {
                        this.validMultiRows(model);
                    }
                    this.setQFilterByEntryField(field, fieldQFilter, currentKey, metaKey, model, entryNoUpdateFieldValueList);
                    validMultiRowsFlag = false;
                    continue;
                }
                this.setQFilterByHeadField(field, fieldQFilter, currentKey, metaKey, model);
            }
        }
        return fieldQFilter;
    }

    private void validMultiRows(IDataModel model) {
        Object billstatus = model.getValue("billstatus");
        if (this.isDraw && BILL_STATUS_A.equals(billstatus) && this.rows.length != 1) {
            if (this.rows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"InventoryQuery_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5e93\u5b58\u67e5\u8be2\uff0c\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"InventoryQuery_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        if (this.rows.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5e93\u5b58\u67e5\u8be2\uff0c\u8bf7\u4e0d\u9009\u62e9\u6216\u8005\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"InventoryQuery_4", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void validOrgNull(Map<String, Object> field, String metaKey, Object value) {
        if ("org".equals(metaKey) && value == null) {
            String orgColname = (String)field.get("currentmetadata");
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5148\u7ef4\u62a4%s\u6570\u636e\u540e\u518d\u8fdb\u884c\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQuery_7", (String)"bos-ext-scmc", (Object[])new Object[0]), orgColname, orgColname));
        }
    }

    private void setQFilterByHeadField(Map<String, Object> field, JSONObject fieldQFilter, String currentKey, String metaKey, IDataModel model) {
        Object value = model.getValue(currentKey);
        this.validOrgNull(field, metaKey, value);
        if (value instanceof DynamicObject) {
            fieldQFilter.put(metaKey, ((DynamicObject)value).get("id"));
        } else {
            fieldQFilter.put(metaKey, value);
        }
    }

    private void setQFilterByEntryField(Map<String, Object> field, JSONObject fieldQFilter, String currentKey, String metaKey, IDataModel model, List<String> entryNoUpdateFieldValueList) {
        String[] keys = currentKey.split("\\.");
        String key = keys[keys.length - 1];
        if (this.row > -1 && !entryNoUpdateFieldValueList.contains(key)) {
            Object value = model.getValue(key, this.row);
            this.validOrgNull(field, metaKey, value);
            if (value instanceof DynamicObject) {
                Object pkid = this.getDynamicObjectKey(key, value);
                fieldQFilter.put(metaKey, pkid);
            } else {
                fieldQFilter.put(metaKey, value);
            }
        } else {
            fieldQFilter.put(metaKey, null);
        }
    }

    private void fillExpandFilterAndUpdateFields(IFormView view, JSONObject param) {
        String appid = view.getModel().getDataEntityType().getAppId();
        if (enableApps.contains(appid)) {
            QFilter expandQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"scmc", (String)appid, (String)"InvqueryService", (String)"getExpandFilter", (Object[])new Object[]{view, this.entrykey, this.row, this.operatekey});
            QFilter invFilter = this.getInvFilter();
            if (invFilter != null) {
                expandQFilter = expandQFilter != null ? expandQFilter.and(invFilter) : invFilter;
            }
            if (expandQFilter != null) {
                param.put("expandQFilter", (Object)expandQFilter.toSerializedString());
            }
            List allUpdateFields = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)appid, (String)"InvqueryService", (String)"getExpandUpdateFields", (Object[])new Object[]{view, this.entrykey, this.row, this.operatekey});
            this.mapParam.put("expandUpdateFields", allUpdateFields);
        } else {
            this.mapParam.put("expandUpdateFields", Collections.emptyList());
        }
    }

    private QFilter getInvFilter() {
        List invFilters = (List)((Map)this.mapParam.get("settingparam")).get(INVFILTER);
        if (invFilters == null || invFilters.isEmpty()) {
            return null;
        }
        ((Map)this.mapParam.get("settingparam")).remove(INVFILTER);
        QFilter resultFilter = null;
        for (QFilter invFilter : invFilters) {
            if (resultFilter == null) {
                resultFilter = invFilter;
                continue;
            }
            resultFilter = resultFilter.and(invFilter);
        }
        return resultFilter;
    }

    private Object getDynamicObjectKey(String key, Object value) {
        Object pkid = null;
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)MetadataServiceHelper.getDataEntityType((String)this.getView().getEntityId()).getAllFields().get(key);
        if (dataEntityProperty instanceof MaterielProp && !((MaterielProp)dataEntityProperty).getBaseEntityId().equals(BD_MATERIAL)) {
            DynamicObject material = ((DynamicObject)value).getDynamicObject("masterid");
            pkid = material.getPkValue();
        } else {
            pkid = ((DynamicObject)value).getPkValue();
        }
        return pkid;
    }

    private String getEntryLinkEntityKey() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        Map allEntities = mainType.getAllEntities();
        for (EntityType entity : allEntities.values()) {
            if (!(entity instanceof LinkEntryType) || !this.entrykey.equals(entity.getParent().getName())) continue;
            return entity.getName();
        }
        return "";
    }

    private boolean checkMustInputFields() {
        List fields = (List)this.mapParam.get("fielddata");
        IDataModel model = this.getView().getModel();
        boolean isSelectRow = this.row > -1;
        ArrayList<String> entryNullList = new ArrayList<String>();
        ArrayList<String> headNullList = new ArrayList<String>();
        StringBuilder errorMsg = new StringBuilder(100);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.billtype);
        Map allFields = mainType.getAllFields();
        for (Map field : fields) {
            Object value;
            if (field.get(KEY_FIELDMUSTINPUT) == null || !((Boolean)field.get(KEY_FIELDMUSTINPUT)).booleanValue()) continue;
            String srcBillCol = (String)field.get(KEY_CURRENTMETADATAKEY);
            if (srcBillCol.contains(".")) {
                Object value2;
                String property;
                IDataEntityProperty fieldProp;
                if (!isSelectRow || (fieldProp = (IDataEntityProperty)allFields.get(property = this.getPure(srcBillCol))) == null || !this.isNullValue(value2 = model.getValue(property, this.row))) continue;
                entryNullList.add(fieldProp.getDisplayName().getLocaleValue());
                continue;
            }
            IDataEntityProperty fieldProp = (IDataEntityProperty)allFields.get(srcBillCol);
            if (fieldProp == null || !this.isNullValue(value = model.getValue(srcBillCol))) continue;
            headNullList.add(fieldProp.getDisplayName().getLocaleValue());
        }
        if (!headNullList.isEmpty()) {
            errorMsg.append(String.join((CharSequence)"\u3001", headNullList));
            errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchingRuleOutHandler_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (!entryNullList.isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"MatchingRuleOutHandler_3", (String)"scmc-im-business", (Object[])new Object[0]), this.row + 1));
            errorMsg.append(String.join((CharSequence)"\u3001", entryNullList));
            errorMsg.append(ResManager.loadKDString((String)"\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchingRuleOutHandler_2", (String)"scmc-im-business", (Object[])new Object[0]));
        }
        if (errorMsg.length() > 0) {
            this.getView().showTipNotification(errorMsg.toString());
            return false;
        }
        return true;
    }

    private String getPure(String currentValue) {
        int lastIndex = currentValue.lastIndexOf(46);
        if (lastIndex != -1) {
            return currentValue.substring(lastIndex + 1);
        }
        return currentValue;
    }

    private boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            return kd.bos.util.StringUtils.isEmpty((String)((String)value));
        }
        return value instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
    }

    private String checkKitProductType() {
        IDataModel model = this.getView().getModel();
        MainEntityType mainEntityType = model.getDataEntityType();
        String entityName = mainEntityType.getName();
        Map entities = mainEntityType.getAllEntities();
        EntityType entityType = (EntityType)entities.get(this.entrykey);
        Map fields = entityType.getFields();
        Set filedKeys = fields.keySet();
        Object productType = null;
        if (filedKeys.contains("kitproducttype")) {
            productType = model.getValue("kitproducttype", this.row);
        } else if (filedKeys.contains("producttype")) {
            productType = model.getValue("producttype", this.row);
        }
        if ("kitparent".equals(productType)) {
            String tipMsg = ResManager.loadKDString((String)"\u6240\u9009\u7269\u6599\u4e3a\u5957\u4ef6\u7236\u9879\uff0c\u4e0d\u5141\u8bb8\u5e93\u5b58\u67e5\u8be2\u3002", (String)"InventoryQuery_9", (String)"bos-ext-scmc", (Object[])new Object[0]);
            this.getView().showTipNotification(tipMsg);
            return "false";
        }
        if ("kitchild".equals(productType) && ("sm_salorder".equals(entityName) || "sm_returnapply".equals(entityName) || "sm_delivernotice".equals(entityName))) {
            return ResManager.loadKDString((String)"\u6b64\u5355\u636e\u7684\u5957\u4ef6\u5b50\u9879\u7269\u6599\u4e0d\u5141\u8bb8\u5e93\u5b58\u8fd4\u56de\u3002", (String)"InventoryQuery_10", (String)"bos-ext-scmc", (Object[])new Object[0]);
        }
        return null;
    }

    public static Integer getDefaultReturnOrder(String key) {
        switch (key) {
            case "org": {
                return 100;
            }
            case "material": {
                return 95;
            }
            case "auxpty": 
            case "warehouse": 
            case "ownertype": 
            case "keepertype": 
            case "invtype": 
            case "invstatus": 
            case "baseunit": {
                return 90;
            }
            case "location": 
            case "owner": 
            case "keeper": 
            case "lotnum": 
            case "project": 
            case "tracknumber": 
            case "configuredcode": 
            case "unit": 
            case "unit2nd": {
                return 85;
            }
            case "producedate": {
                return 80;
            }
            case "expirydate": {
                return 75;
            }
            case "baseqty": 
            case "avbbaseqty": 
            case "lockbaseqty": {
                return 20;
            }
            case "qty": 
            case "avbqty": 
            case "lockqty": {
                return 15;
            }
            case "qty2nd": 
            case "avbqty2nd": 
            case "lockqty2nd": {
                return 10;
            }
        }
        return 0;
    }

    private static class MapFieldComparator
    implements Comparator<Map<String, Object>> {
        private MapFieldComparator() {
        }

        @Override
        public int compare(Map<String, Object> field1, Map<String, Object> field2) {
            int order2;
            int order1 = (Integer)field1.get(InventoryQuery.KEY_ORDER);
            if (order1 != (order2 = ((Integer)field2.get(InventoryQuery.KEY_ORDER)).intValue())) {
                return order2 - order1;
            }
            return (Integer)field1.get("row") - (Integer)field2.get("row");
        }
    }
}

