/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.expense.bizrule;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ExpenseUpdateOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(ExpenseUpdateOpAction.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        long begintime = System.currentTimeMillis();
        if (e.getOperationKey().equalsIgnoreCase("delete")) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(8);
        DynamicObject[] bills = e.getDataEntities();
        for (int i = 0; i < bills.length; ++i) {
            billIds.add(bills[i].getLong("id"));
        }
        HashMap<String, Object> mapParam = new HashMap<String, Object>(8);
        if (bills.length == 1) {
            mapParam.put("bizbills", Arrays.asList(bills));
        }
        mapParam.put("isexpsbtn", Boolean.FALSE);
        long beginmsbdtime = System.currentTimeMillis();
        Map expsResult = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"ExpenseService", (String)"updateExpense", (Object[])new Object[]{this.billEntityType.getName(), billIds, mapParam});
        long endmsbdtime = System.currentTimeMillis();
        logger.info("updateExpense,ext,msbd----UseTime: " + (endmsbdtime - beginmsbdtime) + " ms");
        if (expsResult != null) {
            Iterator it = e.getValidExtDataEntities().iterator();
            while (it.hasNext()) {
                String bizBillno;
                ExtendedDataEntity entity = (ExtendedDataEntity)it.next();
                DynamicObject bizBill = entity.getDataEntity();
                Long bizBillId = (Long)bizBill.getPkValue();
                Map expsRslt = (Map)expsResult.get(bizBillId);
                if (expsRslt == null || kd.bos.util.StringUtils.isEmpty((String)((String)expsRslt.get("message")))) continue;
                String string = bizBillno = expsRslt.get("bizbillno") == null ? "" : expsRslt.get("bizbillno").toString();
                if (billIds.size() > 1 && !kd.bos.util.StringUtils.isEmpty((String)bizBillno)) {
                    this.addErrMessage(entity, bizBillno + "\uff1a" + expsRslt.get("message").toString());
                } else if (billIds.size() > 1 && kd.bos.util.StringUtils.isEmpty((String)bizBillno)) {
                    this.addErrMessage(entity, expsRslt.get("message").toString());
                } else {
                    this.addErrMessage(entity, expsRslt.get("message").toString());
                }
                it.remove();
            }
        }
        long endtime = System.currentTimeMillis();
        logger.info("updateExpense,ext,all----UseTime: " + (endtime - begintime) + " ms");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        HashSet<Long> billIds = new HashSet<Long>(8);
        DynamicObject[] bills = e.getDataEntities();
        for (int i = 0; i < bills.length; ++i) {
            billIds.add(bills[i].getLong("id"));
        }
        if (e.getOperationKey().equalsIgnoreCase("delete")) {
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"ExpenseService", (String)"deleteExpense", (Object[])new Object[]{billIds});
        }
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsgs) {
        Object pkId = null;
        int dataIndex = 0;
        if (dataEntity != null) {
            pkId = dataEntity.getDataEntity().getPkValue();
            dataIndex = dataEntity.getDataEntityIndex();
        }
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("billno", pkId, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u8d39\u7528", (String)"ExpenseUpdateOpAction_0", (String)"bos-ext-scmc", (Object[])new Object[0]), errMsgs, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }

    private static Set<String> getExpsModelFields() {
        HashSet<String> expsModelFields = new HashSet<String>(8);
        expsModelFields.add("bizorg");
        expsModelFields.add("material");
        expsModelFields.add("currency");
        expsModelFields.add("unit");
        expsModelFields.add("qty");
        expsModelFields.add("bizbillno");
        expsModelFields.add("expensesupplier");
        expsModelFields.add("amountandtax");
        expsModelFields.add("settleorg");
        expsModelFields.add("billstatus");
        expsModelFields.add("ischargeoff");
        return expsModelFields;
    }

    private static Set<String> getSelectProps(String srcEntity, Set<String> expsModelFields) {
        HashSet<String> props = new HashSet<String>(8);
        if (kd.bos.util.StringUtils.isEmpty((String)srcEntity)) {
            return props;
        }
        Map<String, String> fldMap = ExpenseUpdateOpAction.getFieldMap(srcEntity);
        if (fldMap == null) {
            return props;
        }
        StringBuilder selectPropsBuilder = new StringBuilder("id");
        boolean isExistEntryId = false;
        for (Map.Entry<String, String> fld : fldMap.entrySet()) {
            if (fld.getKey().equals("billentry") || !expsModelFields.contains(fld.getKey().toString())) continue;
            if (fld.getValue().toString().contains(fldMap.get("billentry") + ".")) {
                String selProp = fldMap.get("billentry") + "." + ExpenseUpdateOpAction.getSplitStrs(fld.getValue().toString());
                props.add(selProp);
                continue;
            }
            if (fld.getValue().toString().contains(".")) continue;
            props.add(fld.getValue().toString());
        }
        return props;
    }

    private static Map<String, String> getFieldMap(String sourceEntity) {
        HashMap<String, String> targetColMap = new HashMap<String, String>(16);
        QFilter targetobj = new QFilter("targetobj", "=", (Object)"msbd_pricetax_expenses");
        QFilter sourcebill = new QFilter("sourcebill", "=", (Object)sourceEntity);
        QFilter enable = new QFilter("isenable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{targetobj, sourcebill, enable};
        Map fieldMapObjs = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])filters);
        if (fieldMapObjs == null || fieldMapObjs.size() == 0 || fieldMapObjs.size() > 1) {
            return targetColMap;
        }
        for (Map.Entry obj : fieldMapObjs.entrySet()) {
            if (obj.getValue() == null) continue;
            DynamicObject fldMapObj = (DynamicObject)obj.getValue();
            DynamicObjectCollection rows = fldMapObj.getDynamicObjectCollection("colsmap");
            for (DynamicObject row : rows) {
                String val = row.getString("sourcebillcol");
                if (StringUtils.isBlank((CharSequence)val) || !"0".equals(row.getString("selectvalue"))) continue;
                targetColMap.put(row.getString("targetobjcol"), val);
            }
        }
        return targetColMap;
    }

    private static String getSplitStrs(String flds) {
        String[] strs = flds.split("\\.");
        return strs[1];
    }
}

