/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.helper;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BillUnitHelper {
    private static final Log log = LogFactory.getLog(BillUnitHelper.class);

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId, Map<String, String> cacheMap) {
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            return BigDecimal.ZERO;
        }
        StringBuilder cachekeySb = new StringBuilder("unitRateCache_").append("_").append(materialId).append("_").append(srcUnitId).append("_").append(desUnitId);
        String cachekey = cachekeySb.toString();
        String rateCache = cacheMap.get(cachekey);
        if (StringUtils.isNotBlank((CharSequence)rateCache)) {
            return new BigDecimal(rateCache);
        }
        BigDecimal unitRate = BillUnitHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
        unitRate = unitRate == null ? BigDecimal.ZERO : unitRate;
        cacheMap.put(cachekey, unitRate.toString());
        return unitRate;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            try {
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("numerator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e24\u4e2a\u5355\u4f4d\u7684\u6362\u7b97\u7387\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }
}

