/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation.pricecontrol.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class PriceControlValidator
extends AbstractValidator {
    private static final String SPLIT = "\\.";
    public static final String REGEX_SPLIT = "\\$\\$";
    public static final String ISFROMLIST = "isFromList";
    private static Map<String, String> APPSERVICE = new HashMap<String, String>();
    public static final String CHECKRESULT = "checkresult";
    public static final String MSG = "msg";
    public static final String LEVEL = "level";

    public void validate() {
        String entityKey = this.entityKey;
        String entryName = ResManager.loadKDString((String)"\u201d\u7269\u6599\u660e\u7ec6\u201c", (String)"PriceControlValidator_5", (String)"bos-ext-scmc", (Object[])new Object[0]);
        HashMap<Long, List> billMap = new HashMap<Long, List>();
        HashMap<Long, List> extendedDataEntityMap = new HashMap<Long, List>();
        this.getValidateContext().getOperateMetaMap().get("mapkey");
        HashMap<String, List<String>> priceMapKey = new HashMap<String, List<String>>();
        String isFromList = this.getOption().getVariableValue(ISFROMLIST, "0");
        if (StringUtils.isNotEmpty((String)isFromList) && "1".equals(isFromList) && this.getValidateContext().getOperateMetaMap() != null && this.getValidateContext().getOperateMetaMap().get("mapkey") != null) {
            Map priceMapKeyCache = (Map)this.getValidateContext().getOperateMetaMap().get("mapkey");
            if (Boolean.TRUE.equals(priceMapKeyCache.get("success"))) {
                priceMapKey.putAll(priceMapKeyCache);
            } else {
                priceMapKey.put("header", Arrays.asList("id"));
            }
        } else {
            Map mapKey = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pms", (String)"PriceControlService", (String)"queryMapKeyIgnoreExp", (Object[])new Object[]{entityKey, null});
            if (mapKey != null && Boolean.TRUE.equals(mapKey.get("success"))) {
                List entryKeys;
                priceMapKey.putAll(mapKey);
                if (mapKey.get("entry") != null && (entryKeys = (List)mapKey.get("entry")) != null && entryKeys.size() > 0) {
                    String entrySign = ((String)entryKeys.get(0)).split(SPLIT)[0];
                    entryName = ((EntityType)EntityMetadataCache.getDataEntityType((String)entityKey).getAllEntities().get(entrySign)).getDisplayName().getLocaleValue();
                }
            } else {
                priceMapKey.put("header", Arrays.asList("id"));
            }
        }
        String entryNameX = entryName;
        QFilter registerFilter = new QFilter("bizentity", "=", (Object)entityKey);
        registerFilter.and(new QFilter("service", "in", Arrays.asList("sctl", "pctl")));
        registerFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DynamicObject registerInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_priceserviceregister", (QFilter[])new QFilter[]{registerFilter});
        if (registerInfo != null) {
            String service = registerInfo.getString("service");
            String orgField = registerInfo.getString("orgsign");
            for (int i = 0; i < this.dataEntities.length; ++i) {
                DynamicObject bill = this.dataEntities[i].getDataEntity();
                if (bill.getDynamicObject(orgField) == null) continue;
                Long orgPK = (Long)bill.getDynamicObject(orgField).getPkValue();
                List billList = billMap.computeIfAbsent(orgPK, e -> new ArrayList());
                List extendedDataEntityList = extendedDataEntityMap.computeIfAbsent(orgPK, e -> new ArrayList());
                billList.add(bill);
                extendedDataEntityList.add(this.dataEntities[i]);
            }
            HashMap propertiesMap = new HashMap();
            billMap.forEach((k, v) -> propertiesMap.put(k, this.buildMap4Entry((Map<String, Object>)priceMapKey, (List<DynamicObject>)v)));
            HashMap priceParam = new HashMap();
            Map priceMapObj = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)APPSERVICE.get(service), (String)"PriceControlService", (String)"check", (Object[])new Object[]{propertiesMap, entityKey, priceParam});
            extendedDataEntityMap.forEach((k, v) -> {
                Map priceControlResult = (Map)priceMapObj.get(k);
                if (priceControlResult != null) {
                    if (Boolean.TRUE.equals(priceControlResult.get("success"))) {
                        this.buildMsg((List<ExtendedDataEntity>)v, priceControlResult, entryNameX);
                    } else if (Boolean.FALSE.equals(priceControlResult.get("success"))) {
                        this.buildSimpleMsg((List<ExtendedDataEntity>)v, priceControlResult);
                    }
                }
            });
        }
    }

    private void buildSimpleMsg(List<ExtendedDataEntity> v, Map<String, Object> priceControlResult) {
        block5: {
            block3: {
                String level;
                String msg;
                block4: {
                    msg = priceControlResult.get(MSG) != null ? (String)priceControlResult.get(MSG) : "";
                    String string = level = priceControlResult.get(LEVEL) != null ? (String)priceControlResult.get(LEVEL) : "";
                    if (!StringUtils.isNotEmpty((String)msg) || !StringUtils.isNotEmpty((String)level)) break block3;
                    if (!PriceControlLevelEnum.WARN.getValue().equals(level)) break block4;
                    for (ExtendedDataEntity entity : v) {
                        this.addWarningMessage(entity, msg);
                    }
                    break block5;
                }
                if (!PriceControlLevelEnum.BAN.getValue().equals(level)) break block5;
                for (ExtendedDataEntity entity : v) {
                    this.addErrorMessage(entity, msg);
                }
                break block5;
            }
            String message = ResManager.loadKDString((String)"\u9650\u4ef7\u6821\u9a8c\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002", (String)"PriceControlValidator_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
            for (ExtendedDataEntity entity : v) {
                this.addErrorMessage(entity, message);
            }
        }
    }

    private void buildMsg(List<ExtendedDataEntity> v, Map<String, Object> priceControlResult, String entryName) {
        Map priceControlRecs = (Map)priceControlResult.get(CHECKRESULT);
        if (priceControlRecs != null) {
            String message_billWarn = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u4ef7\u683c\u63a7\u5236\u903b\u8f91\uff0c\u662f\u5426\u8981\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"PriceControlValidator_3", (String)"bos-ext-scmc", (Object[])new Object[0]);
            String message_billban = ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u4ef7\u683c\u63a7\u5236\u903b\u8f91\uff0c\u7981\u6b62\u4ea4\u6613\u3002", (String)"PriceControlValidator_4", (String)"bos-ext-scmc", (Object[])new Object[0]);
            for (ExtendedDataEntity entity : v) {
                DynamicObject bill = entity.getDataEntity();
                String key = String.valueOf(bill.getPkValue());
                List checkEntryRecs = (List)priceControlRecs.get(key);
                for (int i = 0; checkEntryRecs != null && i < checkEntryRecs.size(); ++i) {
                    String level;
                    String checkEntryInfo = (String)checkEntryRecs.get(i);
                    String[] checkStr = checkEntryInfo.split(REGEX_SPLIT);
                    if (checkStr.length == 4) {
                        String message;
                        level = checkStr[3];
                        String seq = checkStr[2];
                        if (PriceControlLevelEnum.WARN.getValue().equals(level)) {
                            message = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u4e0d\u7b26\u5408\u4ef7\u683c\u63a7\u5236\u903b\u8f91\uff0c\u662f\u5426\u8981\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"PriceControlValidator_1", (String)"bos-ext-scmc", (Object[])new Object[0]), entryName, seq);
                            this.addWarningMessage(entity, message);
                            continue;
                        }
                        if (!PriceControlLevelEnum.BAN.getValue().equals(level)) continue;
                        message = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u4e0d\u7b26\u5408\u4ef7\u683c\u63a7\u5236\u903b\u8f91\uff0c\u7981\u6b62\u4ea4\u6613\u3002", (String)"PriceControlValidator_2", (String)"bos-ext-scmc", (Object[])new Object[0]), entryName, seq);
                        this.addErrorMessage(entity, message);
                        continue;
                    }
                    level = checkStr[1];
                    if (PriceControlLevelEnum.WARN.getValue().equals(level)) {
                        this.addWarningMessage(entity, message_billWarn);
                        continue;
                    }
                    if (!PriceControlLevelEnum.BAN.getValue().equals(level)) continue;
                    this.addErrorMessage(entity, message_billban);
                }
            }
        }
    }

    private List<Map<String, Object>> buildMap4Entry(Map<String, Object> keyMap, List<DynamicObject> bills) {
        ArrayList<Map<String, Object>> propertiesMapList = new ArrayList<Map<String, Object>>();
        String entryName = "";
        List entryKeys = (List)keyMap.get("entry");
        if (entryKeys != null && entryKeys.size() > 0) {
            String[] fields = ((String)entryKeys.get(0)).split(SPLIT);
            entryName = fields[0];
        }
        for (int i = 0; bills != null && i < bills.size(); ++i) {
            DynamicObject bill = bills.get(i);
            HashMap headMap = new HashMap();
            if (keyMap.get("header") != null) {
                List headKeys = (List)keyMap.get("header");
                PriceControlValidator.genPKValue(bill);
                headKeys.forEach(l -> headMap.put(l, PriceControlValidator.getValue(l.split(SPLIT), 0, bill)));
            }
            if (StringUtils.isNotEmpty((String)entryName)) {
                DynamicObjectCollection col = bill.getDynamicObjectCollection(entryName);
                if (col != null && col.size() > 0) {
                    for (int j = 0; col != null && j < col.size(); ++j) {
                        HashMap map = new HashMap();
                        DynamicObject entryInfo = (DynamicObject)col.get(j);
                        PriceControlValidator.genPKValue(entryInfo);
                        entryKeys.forEach(l -> map.put(l, PriceControlValidator.getValue(l.split(SPLIT), 1, entryInfo)));
                        map.putAll(headMap);
                        propertiesMapList.add(map);
                    }
                    continue;
                }
                propertiesMapList.add(headMap);
                continue;
            }
            propertiesMapList.add(headMap);
        }
        return propertiesMapList;
    }

    private static void genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
    }

    private static Object getValue(String[] dividePropertys, int startIndex, DynamicObject source) {
        if (startIndex < dividePropertys.length) {
            try {
                if (startIndex == dividePropertys.length - 1) {
                    if (source.get(dividePropertys[startIndex]) instanceof DynamicObject) {
                        return ((DynamicObject)source.get(dividePropertys[startIndex])).getPkValue();
                    }
                    return source.get(dividePropertys[startIndex]);
                }
                source = source.getDynamicObject(dividePropertys[startIndex]);
                return PriceControlValidator.getValue(dividePropertys, ++startIndex, source);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static {
        APPSERVICE.put("sctl", "pms");
        APPSERVICE.put("pctl", "pmp");
    }

    public static enum PriceControlLevelEnum {
        WARN("warn"),
        BAN("ban");

        private String value;

        private PriceControlLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

