/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.reservation.bizrule;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.reservation.validation.ReserveOperateErrorInfo;
import kd.bos.ext.scmc.reservation.validation.ReserveValidateResult;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ReleaseReserve
extends AbstractOpBizRuleAction {
    private OperationResult result;

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (StringUtils.isBlank((CharSequence)this.result.getMessage())) {
            return;
        }
        OperationResult op = this.getOperationResult();
        if (op.getSuccessPkIds().size() == 1 && op.getAllErrorOrValidateInfo().isEmpty()) {
            op.setMessage(this.result.getMessage());
            op.setShowMessage(true);
        } else if (!op.getSuccessPkIds().isEmpty()) {
            ReserveValidateResult reserveValidateResult = new ReserveValidateResult();
            ReserveOperateErrorInfo errInfo = new ReserveOperateErrorInfo();
            errInfo.setLevel(ErrorLevel.Error);
            errInfo.setMessage(this.result.getMessage());
            reserveValidateResult.addErrorInfo(errInfo);
            op.getValidateResult().addValidateError("releaseReserve", (ValidateResult)reserveValidateResult);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Long[] ids = new Long[dataEntities.length];
        String key = e.getOperationKey();
        String op = null;
        if ("bizclose".equals(key)) {
            op = "doReleaseReserve4Close";
        } else if ("bizunclose".equals(key)) {
            op = "unDoReleaseReserve4Close";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\uff0c\u53ea\u652f\u6301bizclose/bizunclose\u64cd\u4f5c", (String)"ReleaseReserve_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        String billName = dataEntities[0].getDataEntityType().getName();
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = dataEntities[i].getLong("id");
        }
        try (TXHandle tx = TX.requiresNew((String)op);){
            try {
                this.result = (OperationResult)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sbs", (String)"ReserveService", (String)op, (Object[])new Object[]{billName, "bizclose", JSON.toJSONString((Object)ids)});
            }
            catch (Exception ex) {
                tx.markRollback();
                this.result = new OperationResult();
                this.result.setSuccess(false);
                this.result.setMessage(ReleaseReserve.getMsgReserveServiceReverseFailOp() + ex.getMessage());
            }
        }
    }

    private static String getMsgReserveServiceReverseFailOp() {
        return ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u53cd\u5411\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"ReserveServiceImpl_1", (String)"scmc-sbs-form", (Object[])new Object[0]);
    }
}

