/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class UpmOperateValidator
extends AbstractValidator {
    public void validate() {
        if (this.dataEntities.length > 0) {
            String operate = this.getOperateKey();
            Map<String, List<String>> entries = UpmOperateValidator.getBillConfigEntries(this.dataEntities[0], operate);
            if (entries.isEmpty()) {
                return;
            }
            String formid = null;
            int billsize = this.dataEntities.length;
            ArrayList<Long> billids = new ArrayList<Long>(billsize);
            boolean dirtyflag = false;
            DynamicObject billSingle = null;
            HashMap<Long, ExtendedDataEntity> billIdToDataEntityMap = new HashMap<Long, ExtendedDataEntity>(billsize);
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                if (formid == null) {
                    formid = bill.getDynamicObjectType().getName();
                    billSingle = bill;
                    if (billsize == 1) {
                        dirtyflag = UpmOperateValidator.checkDirtyFlag(bill, entries);
                    }
                }
                Long billid = (Long)bill.getPkValue();
                billids.add(billid);
                billIdToDataEntityMap.put(billid, extendedDataEntity);
            }
            Map errorMessageData = dirtyflag ? (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"upm", (String)"UpmBillValidateService", (String)"validSingleBill", (Object[])new Object[]{formid, operate, billSingle}) : (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"upm", (String)"UpmBillValidateService", (String)"validBills", (Object[])new Object[]{formid, operate, billids});
            for (Map.Entry errorMessageEntry : errorMessageData.entrySet()) {
                Long billId = (Long)errorMessageEntry.getKey();
                ExtendedDataEntity errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(billId);
                if (errorDataEntity == null) {
                    errorDataEntity = (ExtendedDataEntity)billIdToDataEntityMap.get(0L);
                }
                if (errorDataEntity == null) continue;
                List errorMessages = (List)errorMessageEntry.getValue();
                for (String errorMessage : errorMessages) {
                    this.addErrorMessage(errorDataEntity, errorMessage);
                }
            }
        }
    }

    private static Map<String, List<String>> getBillConfigEntries(ExtendedDataEntity extendedDataEntity, String operate) {
        HashMap<String, List<String>> entries = new HashMap<String, List<String>>(4);
        DynamicObject bill = extendedDataEntity.getDataEntity();
        MainEntityType mainEntityType = (MainEntityType)bill.getDataEntityType();
        String formid = mainEntityType.getName();
        mainEntityType = EntityMetadataCache.getDataEntityType((String)formid);
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)"upm_billconf", (String)"srcbillentry", (QFilter[])new QFilter("srcbillobj", "=", (Object)formid).and("operate", "=", (Object)operate).and("enable", "=", (Object)Boolean.TRUE).toArray());
        for (DynamicObject cfg : cfgs.values()) {
            String entry = cfg.getString("srcbillentry");
            String parentEntry = UpmOperateValidator.getParentEntry(mainEntityType, entry);
            if (parentEntry == null) {
                entries.putIfAbsent(entry, new ArrayList(4));
                continue;
            }
            List childEntries = entries.getOrDefault(parentEntry, new ArrayList(4));
            childEntries.add(entry);
            if (entries.containsKey(parentEntry)) continue;
            entries.put(parentEntry, childEntries);
        }
        return entries;
    }

    private static String getParentEntry(MainEntityType mainEntityType, String entrytype) {
        EntityType entry = (EntityType)mainEntityType.getAllEntities().get(entrytype);
        if (entry == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u4e0d\u9002\u5408\u914d\u7f6e\u5355\u4ef6\u4e3b\u6863\u521b\u5efa\u6216\u66f4\u65b0\u670d\u52a1\u3002", (String)"UpmOperateValidator_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        IDataEntityType parent = entry.getParent();
        if (parent instanceof MainEntityType) {
            return null;
        }
        return parent.getName();
    }

    private static boolean checkDirtyFlag(DynamicObject bill, Map<String, List<String>> entries) {
        DataEntityState state = bill.getDataEntityState();
        if (!state.getFromDatabase() || state.getRemovedItems().booleanValue()) {
            return true;
        }
        for (Map.Entry<String, List<String>> entryList : entries.entrySet()) {
            String entry = entryList.getKey();
            List<String> subEntries = entryList.getValue();
            if (!bill.containsProperty(entry)) continue;
            DynamicObjectCollection billentries = bill.getDynamicObjectCollection(entry);
            for (DynamicObject billentry : billentries) {
                DataEntityState entryState = billentry.getDataEntityState();
                if (!entryState.getFromDatabase() || entryState.getRemovedItems().booleanValue() || entryState.isBizChanged()) {
                    return true;
                }
                for (String subEntry : subEntries) {
                    if (!billentry.containsProperty(subEntry)) continue;
                    DynamicObjectCollection subbillentries = billentry.getDynamicObjectCollection(subEntry);
                    for (DynamicObject subbillentry : subbillentries) {
                        DataEntityState subentryState = subbillentry.getDataEntityState();
                        if (subentryState.getFromDatabase() && !subentryState.isBizChanged()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

