/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff.bizrule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.util.WriteOffServiceHelper;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.sdk.context.DtxContext;
import kd.bos.kdtx.sdk.session.ec.ECGlobalSession;
import kd.bos.kdtx.sdk.session.ec.ECSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BackWriteOffOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(BackWriteOffOpAction.class);
    private boolean isAsync = false;

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        try {
            logger.info("\u8c03\u7528\u53cd\u6838\u9500info");
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length <= 0) {
                return;
            }
            String billType = this.billEntityType.getName();
            ArrayList<Object> billIds = new ArrayList<Object>(16);
            for (DynamicObject data : dataEntities) {
                billIds.add(data.getPkValue());
            }
            String operationKey = e.getOperationKey();
            boolean bl = this.isAsync = TX.inTX() || WriteOffServiceHelper.isAsyncUnWf(billType);
            if (this.isAsync) {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"UnWriteOffCheckService", (String)"batchCheck", (Object[])new Object[]{billType, billIds, operationKey});
            } else {
                DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"backWriteOff", (Object[])new Object[]{billIds, billType, operationKey});
            }
        }
        catch (Exception ex) {
            logger.error("\u53cd\u6838\u9500\u5f02\u5e38", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (!this.isAsync) {
            return;
        }
        try {
            logger.info("\u53cd\u6838\u9500\u5f02\u6b65\u6267\u884c");
            DynamicObject[] dataEntities = e.getDataEntities();
            if (dataEntities.length <= 0) {
                return;
            }
            String billType = this.billEntityType.getName();
            String dbRouteKey = this.billEntityType.getDBRouteKey();
            ArrayList<String> bussinesInfos = new ArrayList<String>(dataEntities.length);
            ArrayList<Object> list = new ArrayList<Object>(16);
            for (DynamicObject data : dataEntities) {
                list.add(data.getPkValue());
                bussinesInfos.add(billType + "#" + data.getPkValue());
            }
            String operationKey = e.getOperationKey();
            this.kdtxUnWf(bussinesInfos, list, billType, operationKey, dbRouteKey);
        }
        catch (Exception ex) {
            logger.error("\u53cd\u6838\u9500\u5f02\u5e38", (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private void kdtxUnWf(List<String> bussinesInfos, List<Object> list, String billType, String operationKey, String dbRouteKey) throws Exception {
        CommonParam param = new CommonParam();
        String ids = JSONObject.toJSONString(list);
        param.put((Object)"entitytype", (Object)billType);
        param.put((Object)"ids", (Object)ids);
        param.put((Object)"operationKey", (Object)operationKey);
        logger.info("\u4f20\u9012\u53c2\u6570\u4e3a: id :" + ids + "entryTypeName :" + billType + "operationKey :" + operationKey);
        BackWriteOffOpAction.execute("msmod_backwriteoff", null, "mpscmm", "mscommon", dbRouteKey, "UnWriteOffServiceImpl", bussinesInfos, (Param)param, null);
    }

    private static void execute(String scenesCode, String branchScenesCode, String cloudId, String appId, String dbRoute, String serviceName, List<String> businessInfo, Param param, String bizId) throws Exception {
        ECSession session = (ECSession)DtxContext.getDtxSession();
        if (session == null || StringUtils.isEmpty((CharSequence)KdtxRequestContext.get().getXid())) {
            ECGlobalSession.begin((String)scenesCode, (DBRoute)DBRoute.of((String)dbRoute));
            ECGlobalSession.setBusinessType((String)"UnWriteOffOpAction");
            ECGlobalSession.setBusinessInfo(businessInfo);
        }
        ECGlobalSession.register((String)cloudId, (String)appId, (String)serviceName, (Param)param, (String)branchScenesCode, (String)bizId);
    }
}

