/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff.wfmanual;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.scmc.wirteoff.util.WfPluginFactory;
import kd.bos.ext.scmc.wirteoff.wfmanual.IWfManualExtService;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.CreateEntryUtil;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.FilterGridControlUtils;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.WfManualPluginHelper;
import kd.bos.ext.scmc.wirteoff.wfmanual.common.WfManualUtil;
import kd.bos.ext.scmc.wirteoff.wfmanual.consts.CommonConst;
import kd.bos.ext.scmc.wirteoff.wfmanual.consts.WfBillListField;
import kd.bos.ext.scmc.wirteoff.wfmanual.consts.WfManualConst;
import kd.bos.ext.scmc.wirteoff.wfmanual.searcher.WfManualDataReader;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.isv.ISVService;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class WfManualPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IWfManualExtService {
    private static final Log log = LogFactory.getLog(WfManualPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("writeofftype", (Object)this.getWfType());
        this.setDefaultScheme();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        log.info("\u5f00\u59cb\u521d\u59cb\u5316" + new Date());
        this.init();
        log.info("\u5b8c\u6210\u521d\u59cb\u5316" + new Date());
        List<WfBillListField> fieldsList = WfManualUtil.getBillListFields(this.getView());
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            for (Map<String, Object> field : billListField.getFields()) {
                String billField = (String)field.get("fieldInitName");
                list.add(billField);
            }
        }
    }

    public void initialize() {
        super.initialize();
        List<WfBillListField> fieldsList = WfManualUtil.getBillListFields(this.getView());
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            EntryAp dynamicEntryAp = CreateEntryUtil.createDynamicEntryAp(CommonConst.ENTRY_KEYS[i], billListField);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(CommonConst.ENTRY_KEYS[i]);
            List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
            this.getView().createControlIndex(fieldEdits);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, "wfscheme", "writeofftype");
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"formconf"});
        this.addItemClickListeners(new String[]{"toolbarap_a"});
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btnhistorywf".equals(itemKey)) {
            this.viewHistory();
        } else if ("btncurwf".equals(itemKey)) {
            this.viewCurrent();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        String key = event.getOperateKey();
        if ("query".equals(key)) {
            long start = System.currentTimeMillis();
            OperationResult result = event.getOperationResult();
            if (!result.isSuccess()) {
                return;
            }
            this.init();
            Container queryPanel = (Container)this.getControl("querypanel");
            queryPanel.setCollapse(true);
            this.bindEntryData();
            long end = System.currentTimeMillis();
            log.info("\u67e5\u8be2\u65f6\u95f4:" + (end - start) + "ms");
        } else if ("wfmanual".equals(key)) {
            this.startWfManual(event.getOperationResult());
        } else if ("wfauto".equals(key)) {
            this.startAutoManual();
            if (event.getOperationResult().isSuccess()) {
                this.bindEntryData();
                this.getView().setVisible(Boolean.TRUE, new String[]{"btncurwf"});
            }
        } else if ("btnrefresh".equals(key)) {
            this.init();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("wfscheme".equals(fieldKey)) {
            QFilter wfTypef = new QFilter("writeofftype", "=", (Object)this.getWfTypeByForm());
            showParameter.getListFilterParameter().getQFilters().add(wfTypef);
        } else if ("writeofftype".equals(fieldKey)) {
            this.beforeF7WfType(e);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        this.calcWfFieldCur(e);
        this.writeOffMethodChanged(name);
        if ("single".equals(name)) {
            if (((Boolean)this.getModel().getValue("single")).booleanValue()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnautowf"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btnautowf"});
            }
        } else if ("writeofftype".equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null) {
                model.beginInit();
                model.setValue("writeofftype", oldValue);
                model.endInit();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("wfscheme", null);
            this.setDefaultScheme();
            this.init();
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        Object source = e.getSource();
        FormShowParameter source1 = (FormShowParameter)source;
        Map customParams = ((FormShowParameter)source).getCustomParams();
        String wftypenumber = (String)customParams.get("wftypenumber");
        if (wftypenumber == null) {
            String wfGroupNum = (String)customParams.get("wfGroupNum");
            if (wfGroupNum == null) {
                throw new KDBizException(ResManager.LoadKDString((String)"\u8bf7\u5148\u5728\u754c\u9762\u7ed1\u5b9a\u7684\u83dc\u5355\u4e2d\u7ef4\u62a4\u6838\u9500\u7c7b\u522b\u5206\u7ec4\u53c2\u6570", (String)"bos-ext-scmc"));
            }
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            if (wfTypes.isEmpty()) {
                throw new KDBizException(ResManager.LoadKDString((String)"\u672a\u627e\u5230\u754c\u9762\u914d\u7f6e\u7684\u6838\u9500\u7c7b\u522b\u5206\u7ec4", (String)"bos-ext-scmc"));
            }
            wftypenumber = ((DynamicObject)wfTypes.get(0)).getString("entryentity.wftype.number");
        }
        WfManualPluginHelper helper = new WfManualPluginHelper(this.getView());
        List<WfBillListField> fieldsList = helper.init(wftypenumber, source1);
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            EntryAp entryAp = CreateEntryUtil.createDynamicEntryAp(CommonConst.ENTRY_KEYS[i], billListField);
            HashMap<String, String> mapEntry = new HashMap<String, String>(16);
            mapEntry.put("id", CommonConst.ENTRY_KEYS[i]);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        WfManualPluginHelper helper = new WfManualPluginHelper(this.getView());
        helper.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void beforeBindData(EventObject e) {
        List<WfBillListField> fieldsList = WfManualUtil.getBillListFields(this.getView());
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = fieldsList.get(i);
            EntryAp dynamicEntryAp = CreateEntryUtil.createDynamicEntryAp(CommonConst.ENTRY_KEYS[i], billListField);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(CommonConst.ENTRY_KEYS[i]);
            List fieldEdits = ((Container)dynamicEntryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
            this.getView().createControlIndex(fieldEdits);
        }
        log.info("\u52a0\u8f7d\u5b57\u6bb5\u6210\u529f");
    }

    public void onGetControl(OnGetControlArgs e) {
        WfManualPluginHelper helper = new WfManualPluginHelper(this.getView());
        String billListFields = (String)this.getView().getFormShowParameter().getCustomParam("billListFields");
        if (StringUtils.isEmpty((String)billListFields)) {
            return;
        }
        List fieldsList = JSONObject.parseArray((String)billListFields, WfBillListField.class);
        for (int i = 0; i < fieldsList.size(); ++i) {
            WfBillListField billListField = (WfBillListField)fieldsList.get(i);
            for (Map<String, Object> field : billListField.getFields()) {
                helper.buildPropTwo(CommonConst.ENTRY_KEYS[i], field, e);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object fieldValue = e.getValue();
        String key = ((Control)e.getSource()).getKey();
        MainEntityType dataEntityType = (MainEntityType)this.getView().getModel().getDataEntity().getDataEntityType();
        Map properties = dataEntityType.getAllFields();
        IDataEntityProperty fieldProp = (IDataEntityProperty)properties.get(key);
        if (fieldProp == null) {
            return;
        }
        String proName = fieldProp.getName();
        String wfMainField = proName.replace("_cur", "");
        IDataEntityProperty property = (IDataEntityProperty)fieldProp.getParent().getProperties().get((Object)wfMainField);
        if (property != null && fieldValue != null && property instanceof DecimalProp) {
            boolean judge;
            BigDecimal curMainWfFieldNewValue = new BigDecimal((String)fieldValue);
            BigDecimal wfMainValue = (BigDecimal)this.getModel().getValue(wfMainField, e.getRowIndex());
            boolean bl = judge = wfMainValue.multiply(curMainWfFieldNewValue).compareTo(BigDecimal.ZERO) < 0;
            if (judge) {
                e.setCancel(true);
                this.getView().updateView(proName, e.getRowIndex());
                this.getView().showErrorNotification(fieldProp.getDisplayName().getLocaleValue() + "," + property.getDisplayName().getLocaleValue() + ResManager.loadKDString((String)"\u9700\u4fdd\u6301\u7b26\u53f7\u4e00\u81f4", (String)"WfManualPlugin_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            if (curMainWfFieldNewValue.abs().compareTo(wfMainValue.abs()) > 0) {
                e.setCancel(true);
                this.getView().updateView(proName, e.getRowIndex());
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u8d85\u8fc7%s\u3002", (String)"WfManualPlugin_1", (String)"bos-ext-scmc", (Object[])new Object[0]), fieldProp.getDisplayName().getLocaleValue_zh_CN(), property.getDisplayName().getLocaleValue()));
            }
        }
    }

    @Override
    public List<Map<String, Object>> addFilterGrid(String entityNumber) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            List<Map<String, Object>> results;
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getPlugin(className)) == null || CollectionUtils.isEmpty(results = pagePlugin.addFilterGrid(entityNumber))) continue;
            list.addAll(results);
        }
        return list;
    }

    @Override
    public String wfManualConfirmMessage() {
        String message = ResManager.loadKDString((String)"\u5b58\u5728\u4e3b\u65b9\u8f85\u65b9%s\u4e0d\u4e00\u81f4\u7684\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WfManualPlugin_4", (String)"bos-ext-scmc", (Object[])new Object[0]);
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getPlugin(className)) == null) continue;
            message = pagePlugin.wfManualConfirmMessage();
        }
        return message;
    }

    @Override
    public void addBillFilter(String curEntryKey, String entityNumber, List<QFilter> billFilters) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getPlugin(className)) == null) continue;
            pagePlugin.addBillFilter(curEntryKey, entityNumber, billFilters);
        }
    }

    @Override
    public void dealFieldsValueByBiz(TableValueSetter tableValueSetter, String curEntryKey) {
        List plugins = this.getView().getFormShowParameter().getFormConfig().getPlugins();
        for (Plugin plugin : plugins) {
            IWfManualExtService pagePlugin;
            String className = plugin.getClassName();
            if (!plugin.isEnabled() || this.getClass().getName().equals(className) || (pagePlugin = WfPluginFactory.getPlugin(className)) == null) continue;
            pagePlugin.dealFieldsValueByBiz(tableValueSetter, curEntryKey);
        }
    }

    private void beforeF7WfType(BeforeF7SelectEvent e) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter wfTypeQ = null;
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wftypenumber");
        if (wfType == null) {
            String wfGroupNum = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            HashSet<Long> wfTypeIdSet = new HashSet<Long>(16);
            for (DynamicObject type : wfTypes) {
                wfTypeIdSet.add(type.getLong("entryentity.wftype"));
            }
            wfTypeQ = new QFilter("id", "in", wfTypeIdSet);
        } else {
            wfTypeQ = new QFilter("number", "=", (Object)wfType);
        }
        showParameter.getListFilterParameter().getQFilters().add(wfTypeQ);
    }

    private Map<String, String> getCacheValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private Map<String, String> getCacheMainFieldValue(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        HashMap<String, String> mainFiled = new HashMap<String, String>(16);
        for (Map.Entry entry : cacheValueMap.entrySet()) {
            String value = (String)entry.getValue();
            String[] split = value.split("@@");
            if ("B".equals(split[1])) {
                mainFiled.put((String)entry.getKey(), "curwfdata");
                continue;
            }
            if (!"A".equals(split[1])) continue;
            mainFiled.put((String)entry.getKey(), split[0]);
        }
        return mainFiled;
    }

    private Map<String, List<String>> getCacheValueList(String cacheKey) {
        String cacheValueStr = this.getPageCache().get(cacheKey);
        Map cacheValueMap = (Map)SerializationUtils.fromJsonString((String)cacheValueStr, Map.class);
        return cacheValueMap;
    }

    private void init() {
        Long wfTypeId = this.getWfTypeByForm();
        DynamicObject wfTypeDyc = BusinessDataServiceHelper.loadSingle((Object)wfTypeId, (String)"msmod_writeofftype");
        DynamicObjectCollection writeOffBillEntities = wfTypeDyc.getDynamicObjectCollection("writeoffbillentry");
        HashMap<String, String> entryBillMap = new HashMap<String, String>(16);
        HashMap<String, String> entryWfMainFieldMap = new HashMap<String, String>(16);
        HashMap entryWfFieldMap = new HashMap(16);
        HashMap entryWfFieldPreMap = new HashMap(16);
        HashMap<String, String> entryFilterStrMap = new HashMap<String, String>(16);
        Collections.sort(writeOffBillEntities, Comparator.comparingInt(o -> o.getInt("seq")));
        int i = 0;
        for (DynamicObject writeOffBillEntry : writeOffBillEntities) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            if (writeOffBillEntry.getBoolean("isautogenerate") || !writeOffBillEntry.getBoolean("isinvolved")) continue;
            String entityNum = writeOffBillEntry.getDynamicObject("writeoffbilltype").getString("number");
            entryBillMap.put(curEntryKey, entityNum);
            DynamicObjectCollection subEntries = writeOffBillEntry.getDynamicObjectCollection("wffieldsubentry");
            for (DynamicObject writeOffColumnEntry : subEntries) {
                Object wfFieldKey = writeOffColumnEntry.getString("writeofffieldkey");
                String valueMethod = writeOffColumnEntry.getString("valuemethod");
                String formula = writeOffColumnEntry.getString("calformuladesc_tag");
                if (writeOffColumnEntry.getBoolean("writeoffcalcfield")) {
                    if ("C".equals(valueMethod) || "B".equals(valueMethod)) {
                        entryWfMainFieldMap.put(curEntryKey, formula + "@@" + "B");
                        wfFieldKey = "curwfdata";
                    } else {
                        entryWfMainFieldMap.put(curEntryKey, (String)wfFieldKey + "@@" + "A");
                    }
                }
                entryWfFieldMap.putIfAbsent(curEntryKey, new ArrayList(16));
                ((List)entryWfFieldMap.get(curEntryKey)).add(wfFieldKey);
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(curEntryKey);
            DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
            entryWfFieldPreMap.putIfAbsent(curEntryKey, new ArrayList(16));
            for (IDataEntityProperty item : properties) {
                String keyName = item.getName();
                int prefixIndex = keyName.indexOf(suffix);
                if (prefixIndex == -1) continue;
                boolean containsWfField = properties.containsKey((Object)item.getName().replace("_cur", ""));
                keyName = keyName.substring(prefixIndex);
                if (!containsWfField || !keyName.startsWith(suffix) || !keyName.endsWith("_cur")) continue;
                ((List)entryWfFieldPreMap.get(curEntryKey)).add(item.getName());
            }
            this.initFilterGrid(entityNum, suffix);
            String billFilterStr = writeOffBillEntry.getString("filterconditiondesc_tag");
            entryFilterStrMap.put(curEntryKey, billFilterStr);
            ++i;
        }
        this.getPageCache().put("entrybillmap", SerializationUtils.toJsonString(entryBillMap));
        this.getPageCache().put("wfcount", String.valueOf(i));
        this.getPageCache().put("entrywfmainfieldmap", SerializationUtils.toJsonString(entryWfMainFieldMap));
        this.getPageCache().put("entrywffieldmap", SerializationUtils.toJsonString(entryWfFieldMap));
        this.getPageCache().put("entrywffieldpremap", SerializationUtils.toJsonString(entryWfFieldPreMap));
        this.getPageCache().put("entryfilterstrmap", SerializationUtils.toJsonString(entryFilterStrMap));
        this.getPageCache().put("recordentity", wfTypeDyc.getDynamicObject("writeoffrecordbill").getString("number"));
    }

    private Long getWfType() {
        String wfType = (String)this.getView().getFormShowParameter().getCustomParam("wftypenumber");
        if (wfType == null) {
            String wfGroupNum = (String)this.getView().getFormShowParameter().getCustomParam("wfGroupNum");
            DynamicObjectCollection wfTypes = QueryServiceHelper.query((String)"msmod_recordtypegroup", (String)"entryentity.wftype.number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfGroupNum)}, (String)"entryentity.seq");
            wfType = ((DynamicObject)wfTypes.get(0)).getString("entryentity.wftype.number");
        }
        List wfTypeId = QueryServiceHelper.queryPrimaryKeys((String)"msmod_writeofftype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)wfType)}, null, (int)1);
        return (Long)wfTypeId.get(0);
    }

    private Long getWfTypeByForm() {
        DynamicObject wfType = (DynamicObject)this.getModel().getValue("writeofftype");
        if (wfType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfManualPlugin_8", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        return wfType.getLong("id");
    }

    private String getSuffix(int index) {
        return "_" + (char)(WfManualConst.MIN_SUFFIX.charValue() + index);
    }

    private void initFilterGrid(String entityNumber, String suffix) {
        String filterCtl = "filter" + suffix;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterCtl);
        if (filterGrid == null) {
            filterGrid = (FilterGrid)this.getView().getControl(ISVService.getISVInfo().getId() + filterCtl);
        }
        FilterGridControlUtils.setFilterControlType(filterGrid, entityNumber);
        List<Map<String, Object>> maps = this.addFilterGrid(entityNumber);
        List filterColumns = filterGrid.getFilterColumns();
        filterColumns.addAll(maps);
        String billNameCtl = "filtername" + suffix;
        Label billNameLab = (Label)this.getControl(billNameCtl);
        if (billNameLab == null) {
            billNameLab = (Label)this.getView().getControl(ISVService.getISVInfo().getId() + billNameCtl);
        }
        billNameLab.setText(EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue());
        this.getView().setEnable(Boolean.TRUE, new String[]{filterCtl});
        this.getView().updateView(filterCtl);
    }

    private List<QFilter> buildQfilter(String billType, String suffix) {
        String curEntryKey = "entry" + suffix;
        curEntryKey = this.getEntryKey(curEntryKey);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filter" + suffix);
        String entityNumber = filterGrid.getEntityNumber();
        ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
        Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
        String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
        QFilter wfCfgs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgFilter);
        billFilters.add(wfCfgs);
        String filterText = FilterGridControlUtils.getFilterTextByControl(filterGrid);
        QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter(entityNumber, filterText);
        billFilters.add(curBillFilter);
        this.addBillFilter(curEntryKey, entityNumber, billFilters);
        return billFilters;
    }

    private void bindEntryData() {
        String wfCount = this.getView().getPageCache().get("wfcount");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            this.getModel().deleteEntryData(curEntryKey);
            FilterGrid filterGrid = (FilterGrid)this.getControl("filter" + suffix);
            String entityNumber = filterGrid.getEntityNumber();
            ArrayList<QFilter> billFilters = new ArrayList<QFilter>(16);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            QFilter wfCfgs = FilterGridControlUtils.crFilterTextToQfilter(entityNumber, wfCfgFilter);
            billFilters.add(wfCfgs);
            String filterText = FilterGridControlUtils.getFilterTextByControl(filterGrid);
            QFilter curBillFilter = FilterGridControlUtils.filterTextToQfilter(entityNumber, filterText);
            billFilters.add(curBillFilter);
            this.addBillFilter(curEntryKey, entityNumber, billFilters);
            this.checkOrgAndDateFilter(entityNumber, billFilters);
            HashMap<String, String> billFormFieldMap = new HashMap<String, String>(16);
            List<String> formFields = this.getBillFields(suffix, curEntryKey, entityNumber, billFormFieldMap);
            Map<String, List<String>> entryWfMap = this.getCacheValueList("entrywffieldmap");
            List<String> wfFields = entryWfMap.get(curEntryKey);
            if (wfFields == null) {
                wfFields = new ArrayList<String>(16);
            }
            Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
            String wfMainField = entryWfMainFieldMap.get(curEntryKey);
            Map<String, String> wfFieldAssistField = this.getWfFieldAssistFieldMap(curEntryKey, billFormFieldMap, wfFields);
            WfManualDataReader wfManualDataReader = new WfManualDataReader(entityNumber, wfMainField, wfCfgFilter, curEntryKey);
            wfManualDataReader.setBillFilters(billFilters);
            TableValueSetter tableValueSetter = wfManualDataReader.createTableValueSetter(formFields, billFormFieldMap, wfFieldAssistField);
            this.getModel().beginInit();
            int rowCount = tableValueSetter.getCount();
            if (rowCount != 0) {
                this.dealFieldsValueByBiz(tableValueSetter, curEntryKey);
                ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(curEntryKey, tableValueSetter);
            }
            this.getModel().endInit();
            this.getView().updateView(curEntryKey);
        }
    }

    private void checkOrgAndDateFilter(String entityNumber, List<QFilter> billFilters) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        for (QFilter filter : billFilters) {
            qFilter.and(filter);
        }
        BOSExpression bosExpression = new BOSExpression(qFilter.toString());
        Set vars = bosExpression.getVars();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allEntities = dataEntityType.getAllEntities();
        Map<String, IDataEntityProperty> fieldMap = this.getEntityPropertyMap(entityNumber, allEntities);
        Set entryNames = allEntities.keySet();
        boolean isOrg = false;
        boolean isDate = false;
        for (String field : vars) {
            String[] spitFields = field.split("\\.");
            String spitField = spitFields[0];
            String fieldName = spitFields.length > 1 && entryNames.contains(spitField) ? spitField + "." + spitFields[1] : spitField;
            IDataEntityProperty property = fieldMap.get(fieldName);
            if (property instanceof OrgProp) {
                isOrg = true;
            }
            if (!(property instanceof DateTimeProp)) continue;
            isDate = true;
        }
        if (!isOrg || !isDate) {
            String name = dataEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e(%s)\u9700\u8981\u589e\u52a0\u7ec4\u7ec7\u548c\u65e5\u671f\u8fc7\u6ee4\u6761\u4ef6\u3002", (String)"WfManualPlugin_9", (String)"bos-ext-scmc", (Object[])new Object[0]), name));
        }
    }

    private Map<String, IDataEntityProperty> getEntityPropertyMap(String entityNumber, Map<String, EntityType> allEntities) {
        HashMap<String, IDataEntityProperty> fieldMap = new HashMap<String, IDataEntityProperty>(16);
        for (Map.Entry<String, EntityType> entry : allEntities.entrySet()) {
            String entryKey = entry.getKey();
            EntityType value = entry.getValue();
            Map fields = value.getFields();
            for (Map.Entry fieldEntry : fields.entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                IDataEntityProperty property = (IDataEntityProperty)fieldEntry.getValue();
                if (entityNumber.equals(entryKey)) {
                    fieldMap.put(fieldKey, property);
                    continue;
                }
                String keyResult = entryKey + "." + fieldKey;
                fieldMap.put(keyResult, property);
            }
        }
        return fieldMap;
    }

    private QFilter getOrgFilter(String entityNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String mainOrg = dataEntityType.getMainOrg();
        List orgsUserJoinOrg = UserServiceHelper.getOrgsUserJoin((long)UserServiceHelper.getCurrentUserId());
        return new QFilter(mainOrg, "in", (Object)orgsUserJoinOrg);
    }

    private List<String> getBillFields(String suffix, String curEntryKey, String entityNumber, Map<String, String> billFormFieldMap) {
        ArrayList<String> formFields = new ArrayList<String>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(curEntryKey);
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        for (IDataEntityProperty item : properties) {
            String isvKey;
            String keyName = item.getName();
            if (!keyName.endsWith(suffix) && !keyName.endsWith("_x")) continue;
            if ((keyName = keyName.endsWith("_x") ? keyName.substring(0, keyName.lastIndexOf(suffix + "_x")) : keyName.substring(0, keyName.lastIndexOf(suffix))).startsWith(isvKey = ISVService.getISVInfo().getId() + "_")) {
                String newKeyName = keyName.substring(isvKey.length());
                if (dataEntityType.getProperties().containsKey((Object)newKeyName)) {
                    keyName = newKeyName;
                }
            }
            if (!formFields.contains(keyName)) {
                formFields.add(keyName);
            }
            billFormFieldMap.put(keyName, item.getName());
        }
        Map billAllFields = dataEntityType.getAllFields();
        formFields.retainAll(billAllFields.keySet());
        return formFields;
    }

    private String getFieldEntry(MainEntityType dataEntityType, String field) {
        IDataEntityProperty property = dataEntityType.findProperty(field);
        if (property == null) {
            return null;
        }
        IDataEntityType parent = property.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getName();
    }

    private Map<String, String> getWfFieldAssistFieldMap(String curEntryKey, Map<String, String> billFormFieldMap, List<String> wfFields) {
        HashMap<String, String> wfFieldAssistField = new HashMap<String, String>(16);
        for (String wfField : wfFields) {
            String[] splits = wfField.split("\\.");
            wfField = splits[splits.length - 1];
            String formField = billFormFieldMap.get(wfField);
            String mainField = billFormFieldMap.get(wfField + "_cur");
            if (formField == null && mainField == null) continue;
            String assistWfField = formField != null ? formField.substring(0, formField.length() - 2) + "_cur" + formField.substring(formField.length() - 2) : mainField.substring(0, mainField.length() - 2) + mainField.substring(mainField.length() - 2);
            DynamicObjectType curEntryType = this.getModel().getEntryEntity(curEntryKey).getDynamicObjectType();
            boolean containsAssistField = curEntryType.getProperties().containsKey((Object)assistWfField);
            if (!containsAssistField) continue;
            wfFieldAssistField.put(wfField, assistWfField);
        }
        return wfFieldAssistField;
    }

    private void calcWfFieldCur(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        String curEntryKey = e.getProperty().getParent().getName();
        Map<String, List<String>> entryWfPreMap = this.getCacheValueList("entrywffieldpremap");
        List<String> curWfFields = entryWfPreMap.get(curEntryKey);
        if (curWfFields == null) {
            return;
        }
        String wfMainField = proName.replace("_cur", "");
        IDataEntityProperty property = (IDataEntityProperty)e.getProperty().getParent().getProperties().get((Object)wfMainField);
        Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
        String[] splitWfMainFields = entryWfMainFieldMap.get(curEntryKey).split("\\.");
        String splitWfMainField = splitWfMainFields[splitWfMainFields.length - 1];
        if (property != null && wfMainField.contains(splitWfMainField)) {
            ChangeData[] valueSet = e.getChangeSet();
            for (int i = 0; i < valueSet.length; ++i) {
                int rowIndex = valueSet[i].getRowIndex();
                Object newValue = valueSet[i].getNewValue();
                if (!(newValue instanceof BigDecimal)) continue;
                BigDecimal curMainWfFieldNewValue = (BigDecimal)newValue;
                BigDecimal wfMainFieldValue = (BigDecimal)this.getModel().getValue(wfMainField, rowIndex);
                for (String item : curWfFields) {
                    if (proName.equals(item)) continue;
                    BigDecimal wfFieldValue = (BigDecimal)this.getModel().getValue(item.replace("_cur", ""), rowIndex);
                    BigDecimal curWfFieldValue = BigDecimal.ZERO;
                    if (wfMainFieldValue.compareTo(BigDecimal.ZERO) != 0) {
                        int scale = 10;
                        curWfFieldValue = curMainWfFieldNewValue.multiply(wfFieldValue).setScale(scale, RoundingMode.HALF_UP).divide(wfMainFieldValue, scale, RoundingMode.HALF_UP);
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue(item, (Object)curWfFieldValue);
                    this.getModel().endInit();
                    this.getView().updateView(item, rowIndex);
                }
            }
        }
    }

    private void startAutoManual() {
        Map<String, Object> schemaMap = this.buildSchemaSortTypeConfigMap();
        Date wfDate = new Date();
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startAutoManualWriteOff", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, this.getConditionsMap(), null});
    }

    private void startWfManual(OperationResult result) {
        String wfCount = this.getPageCache().get("wfcount");
        int count = 0;
        Boolean single = (Boolean)this.getModel().getValue("single");
        Boolean whole = (Boolean)this.getModel().getValue("whole");
        BigDecimal allCountTwo = null;
        Boolean isShowConfirm = Boolean.FALSE;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String entryKey = this.getEntryKey("entry" + suffix);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            int[] rows = entryGrid.getSelectRows();
            count += rows.length;
            if (i == 0 && rows.length < 1 && !single.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4e3b\u65b9\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u4e3b\u65b9\u5355\u636e\u3002", (String)"WfManualPlugin_2", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            if (i > 0 && rows.length < 1 && !single.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u5404\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WfManualPlugin_3", (String)"bos-ext-scmc", (Object[])new Object[0]));
            }
            BigDecimal allCount = this.getWfCount(suffix, entryKey, rows, builder, i);
            if (allCountTwo != null && allCountTwo.abs().compareTo(allCount.abs()) != 0) {
                isShowConfirm = Boolean.TRUE;
                continue;
            }
            allCountTwo = allCount;
        }
        if (single.booleanValue() && count < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u6709\u53c2\u4e0e\u65b9\u5355\u636e\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"WfManualPlugin_7", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        if (!single.booleanValue() && !whole.booleanValue() && isShowConfirm.booleanValue()) {
            String message = this.wfManualConfirmMessage();
            String format = String.format(message, builder.toString());
            this.getView().showConfirm(format, MessageBoxOptions.None, new ConfirmCallBackListener("wfmanual", (IFormPlugin)this));
            result.setSuccess(false);
            result.setShowMessage(false);
        } else {
            this.wfManualDeal();
            this.bindEntryData();
            this.getView().setVisible(Boolean.TRUE, new String[]{"btncurwf"});
        }
    }

    private BigDecimal getWfCount(String suffix, String entryKey, int[] rows, StringBuilder builder, int line) {
        Map<String, String> entryMainFieldMap = this.getCacheMainFieldValue("entrywfmainfieldmap");
        String[] splits = entryMainFieldMap.get(entryKey).split("\\.");
        String formField = splits[splits.length - 1] + "_cur" + suffix;
        String curMainFieldKey = this.getFormField(formField);
        IDataEntityProperty property = this.getModel().getProperty(curMainFieldKey);
        if (property != null && line == 0) {
            String localeValue = property.getDisplayName().getLocaleValue();
            builder.append(localeValue);
        }
        BigDecimal allCount = BigDecimal.ZERO;
        for (int j = 0; j < rows.length; ++j) {
            Object value = this.getModel().getValue(curMainFieldKey, rows[j]);
            BigDecimal curMainFieldValue = value == null ? BigDecimal.ZERO : (BigDecimal)value;
            allCount = allCount.add(curMainFieldValue);
        }
        return allCount;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callbackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callbackId) {
            case "wfmanual": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                long startTime = System.currentTimeMillis();
                this.wfManualDeal();
                long endTime1 = System.currentTimeMillis();
                log.info("\u624b\u5de5\u6838\u9500\u5904\u7406\u65f6\u95f4" + (endTime1 - startTime) + "ms");
                this.bindEntryData();
                this.getView().setVisible(Boolean.TRUE, new String[]{"btncurwf"});
                long endTime = System.currentTimeMillis();
                log.info("\u624b\u5de5\u6838\u9500\u5904\u7406\u65f6\u95f42" + (endTime - startTime) + "ms");
                break;
            }
        }
    }

    private void wfManualDeal() {
        Map<String, Object> schemaMap = this.buildSchemaSortTypeConfigMap();
        Date wfDate = new Date();
        List<Map<Object, BigDecimal>> curMainFieldValueMaps = this.getEntryIdCurMainFieldValueMaps();
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        Map<String, String> entryWfMainFieldMap = this.getCacheValue("entrywfmainfieldmap");
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>(16);
        params.put("entrybillmap", entryBillMap);
        params.put("entrywfmainfieldmap", entryWfMainFieldMap);
        HashMap<Integer, String> indexEntryKeyMap = new HashMap<Integer, String>(16);
        for (int i = 0; i < curMainFieldValueMaps.size(); ++i) {
            String entryKey = "entry" + this.getSuffix(i);
            entryKey = this.getEntryKey(entryKey);
            indexEntryKeyMap.put(i, entryKey);
        }
        params.put("entry", indexEntryKeyMap);
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"startManualWriteOff", (Object[])new Object[]{this.getWfTypeByForm(), schemaMap, wfDate, curMainFieldValueMaps, params});
    }

    private DynamicObject buildSchemaSortTypeConfig() {
        EntityType sortType = (EntityType)EntityMetadataCache.getDataEntityType((String)"msmod_schemeset").getAllEntities().get("msmod_scheme_sort");
        DynamicObject sortTypeDyc = new DynamicObject((DynamicObjectType)sortType);
        Object scheme = this.getModel().getValue("wfscheme");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u586b\u5199\u6838\u9500\u65b9\u6848\u3002", (String)"WfManualPlugin_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        sortTypeDyc.set("writeoffscheme", scheme);
        sortTypeDyc.set("priority", (Object)0);
        sortTypeDyc.set("unilateral", this.getModel().getValue("single"));
        sortTypeDyc.set("rbpriority", this.getModel().getValue("redbluefirst"));
        sortTypeDyc.set("equalsfirst", this.getModel().getValue("equalsfirst"));
        sortTypeDyc.set("onlyequals", this.getModel().getValue("onlyequals"));
        sortTypeDyc.set("whole", this.getModel().getValue("whole"));
        return sortTypeDyc;
    }

    private Map<String, Object> buildSchemaSortTypeConfigMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Object scheme = this.getModel().getValue("wfscheme");
        if (scheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u9500\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a, \u8bf7\u586b\u5199\u6838\u9500\u65b9\u6848\u3002", (String)"WfManualPlugin_0", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        map.put("writeoffscheme", ((DynamicObject)scheme).getPkValue());
        map.put("priority", 0);
        map.put("unilateral", this.getModel().getValue("single"));
        map.put("rbpriority", this.getModel().getValue("redbluefirst"));
        map.put("equalsfirst", this.getModel().getValue("equalsfirst"));
        map.put("onlyequals", this.getModel().getValue("onlyequals"));
        map.put("whole", this.getModel().getValue("whole"));
        return map;
    }

    private List<Map<Object, BigDecimal>> getEntryIdCurMainFieldValueMaps() {
        ArrayList<Map<Object, BigDecimal>> entryIdCurMainFieldValueMaps = new ArrayList<Map<Object, BigDecimal>>(16);
        String wfCount = this.getPageCache().get("wfcount");
        Map<String, String> entryMainFieldOneMap = this.getCacheValue("entrywfmainfieldmap");
        Map<String, String> entryMainFieldMap = this.getCacheMainFieldValue("entrywfmainfieldmap");
        Map<String, String> entryBillMap = this.getCacheValue("entrybillmap");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String entryKey = this.getEntryKey("entry" + suffix);
            String[] splits = entryMainFieldMap.get(entryKey).split("\\.");
            String formField = splits[splits.length - 1] + "_cur" + suffix;
            String mainField = splits[splits.length - 1] + suffix;
            String mainFieldAll = entryMainFieldOneMap.get(entryKey);
            String curMainFieldKey = this.getFormField(formField);
            String mainFieldKey = this.getFormField(mainField);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryKey);
            int[] rows = entryGrid.getSelectRows();
            String billType = entryBillMap.get(entryKey);
            HashMap<Object, BigDecimal> entryIdCurMainFieldValueMap = new HashMap<Object, BigDecimal>(rows.length);
            HashMap<Object, BigDecimal> entryIdMainFieldValueMap = new HashMap<Object, BigDecimal>(rows.length);
            for (int j = 0; j < rows.length; ++j) {
                Object value = this.getModel().getValue(curMainFieldKey, rows[j]);
                BigDecimal curMainFieldValue = value == null ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(curMainFieldKey, rows[j]);
                String entryIdKey = "billentryid" + suffix;
                entryIdKey = this.getFormField(entryIdKey);
                Object entryId = this.getModel().getValue(entryIdKey, rows[j]);
                entryIdCurMainFieldValueMap.put(entryId, curMainFieldValue);
                IDataEntityProperty property = this.getModel().getDataEntityType().findProperty(mainFieldKey);
                if (property != null) {
                    Object mainFieldValue = this.getModel().getValue(mainFieldKey, rows[j]);
                    entryIdMainFieldValueMap.put(entryId, mainFieldValue == null ? BigDecimal.ZERO : (BigDecimal)mainFieldValue);
                    continue;
                }
                entryIdMainFieldValueMap.put(entryId, value == null ? BigDecimal.ZERO : (BigDecimal)value);
            }
            this.checkBillIsUpdate(splits, mainFieldAll, billType, entryIdMainFieldValueMap);
            this.checkSelectDataQfilter(entryIdCurMainFieldValueMap.keySet(), billType, mainFieldAll, suffix);
            entryIdCurMainFieldValueMaps.add(entryIdCurMainFieldValueMap);
        }
        return entryIdCurMainFieldValueMaps;
    }

    private void checkSelectDataQfilter(Set<Object> ids, String entityNumber, String wfMainField, String suffix) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entryKey = this.getMainFieldKeyId(dataEntityType, wfMainField);
        if ("B".equals(wfMainField.split("@@")[1])) {
            entryKey = WfManualUtil.getEntryKey(entityNumber, wfMainField);
        }
        QFilter qFilter = new QFilter(entryKey, "in", ids);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        qFilters.add(qFilter);
        qFilters.addAll(this.buildQfilter(entityNumber, suffix));
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityNumber, (String)entryKey, (QFilter[])this.getFilters(qFilters));
        if (query.size() != ids.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private QFilter[] getFilters(List<QFilter> billFilters) {
        QFilter[] billfs = null;
        if (billFilters.size() > 0) {
            billfs = billFilters.toArray(new QFilter[0]);
        }
        return billfs;
    }

    private String getMainFieldKeyId(MainEntityType dataEntityType, String wfMainField) {
        int lastPointIndex;
        String entryId = null;
        entryId = wfMainField != null ? ((lastPointIndex = wfMainField.lastIndexOf(".")) == -1 ? dataEntityType.getPrimaryKey().getName() : wfMainField.substring(0, lastPointIndex) + ".id") : dataEntityType.getPrimaryKey().getName();
        return entryId;
    }

    private void checkBillIsUpdate(String[] splits, String mainFieldAll, String billType, Map<Object, BigDecimal> entryIdMainFieldValueMap) {
        String idKey = splits.length > 1 ? splits[0] + ".id" : "id";
        Boolean isFormula = Boolean.FALSE;
        String mainField = mainFieldAll;
        String expression = "";
        String[] mainFields = mainFieldAll.split("@@");
        if (mainFields.length > 1) {
            if ("B".equals(mainFields[1])) {
                String join;
                String mainFieldExpress = mainFields[0];
                Set<String> expressionField = WfManualUtil.getExpressionField(billType, mainFieldAll);
                mainField = join = String.join((CharSequence)",", expressionField);
                isFormula = Boolean.TRUE;
                expression = this.getExpression(mainFieldExpress);
                idKey = WfManualUtil.getEntryKey(billType, mainFieldAll);
            } else if ("A".equals(mainFields[1])) {
                mainField = mainFields[0];
            }
        } else {
            mainField = mainFieldAll;
        }
        QFilter qFilter = new QFilter(idKey, "in", entryIdMainFieldValueMap.keySet());
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)billType, (String)(idKey + "," + mainField), (QFilter[])qFilter.toArray());
        if (entryIdMainFieldValueMap.size() != queryList.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
        for (DynamicObject query : queryList) {
            BigDecimal o1;
            BigDecimal value = BigDecimal.ZERO;
            if (isFormula.booleanValue()) {
                HashMap<String, Object> args = new HashMap<String, Object>(16);
                Set<String> expressionField = WfManualUtil.getExpressionField(billType, mainFieldAll);
                for (String field : expressionField) {
                    Object fieldValue = query.get(field);
                    String[] spit = field.split("\\.");
                    args.put(spit[spit.length - 1], fieldValue);
                }
                Object result = FormulaEngine.execExcelFormula((String)expression, args);
                value = result == null ? BigDecimal.ZERO : (BigDecimal)result;
            } else {
                BigDecimal result = query.getBigDecimal(mainField);
                BigDecimal bigDecimal = value = result == null ? BigDecimal.ZERO : result;
            }
            if (value.compareTo(o1 = entryIdMainFieldValueMap.get(query.get(idKey))) == 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u67e5\u5230\u5355\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u754c\u9762\u3002", (String)"WfManualPlugin_5", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private Map<String, String> getConditionsMap() {
        LinkedHashMap<String, String> billConditionsMap = new LinkedHashMap<String, String>(16);
        String wfCount = this.getPageCache().get("wfcount");
        for (int i = 0; i < Integer.parseInt(wfCount); ++i) {
            String suffix = this.getSuffix(i);
            String curEntryKey = "entry" + suffix;
            curEntryKey = this.getEntryKey(curEntryKey);
            Map<String, String> entryFilterStrMap = this.getCacheValue("entryfilterstrmap");
            String wfCfgFilter = entryFilterStrMap.get(curEntryKey);
            FilterGrid filterGrid = (FilterGrid)this.getControl("filter" + this.getSuffix(i));
            String filterText = FilterGridControlUtils.getFilterTextByControl(filterGrid);
            String entityNumber = filterGrid.getEntityNumber();
            QFilter qFilter = this.getOrgFilter(entityNumber);
            String filter = filterText + "&@&" + wfCfgFilter + "&@&" + qFilter.toString();
            billConditionsMap.put(entityNumber + "&@&" + this.getSuffix(i), filter);
        }
        return billConditionsMap;
    }

    private String getExpression(String wfMainField) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        return condition.getExpression();
    }

    private String getFormField(String formField) {
        String isvKey;
        String newFormField;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Map allFields = dataEntityType.getAllEntities();
        if (!allFields.containsKey(formField) && allFields.containsKey(newFormField = (isvKey = ISVService.getISVInfo().getId()) + "_" + formField)) {
            formField = newFormField;
        }
        return formField;
    }

    private String getEntryKey(String entryKey) {
        String isvKey;
        String newEntryKey;
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        Map allEntities = dataEntityType.getAllEntities();
        if (!allEntities.containsKey(entryKey) && allEntities.containsKey(newEntryKey = (isvKey = ISVService.getISVInfo().getId()) + "_" + entryKey)) {
            entryKey = newEntryKey;
        }
        return entryKey;
    }

    private void writeOffMethodChanged(String method) {
        if ("whole".equals(method) && ((Boolean)this.getModel().getValue("whole")).booleanValue()) {
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("redbluefirst", (Object)false);
            this.getModel().setValue("equalsfirst", (Object)false);
        } else if ("equalsfirst".equals(method) && ((Boolean)this.getModel().getValue("equalsfirst")).booleanValue()) {
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("whole", (Object)false);
        } else if ("onlyequals".equals(method) && ((Boolean)this.getModel().getValue("onlyequals")).booleanValue()) {
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("single", (Object)false);
        } else if ("single".equals(method) && ((Boolean)this.getModel().getValue("single")).booleanValue()) {
            this.getModel().setValue("whole", (Object)false);
            this.getModel().setValue("equalsfirst", (Object)false);
            this.getModel().setValue("onlyequals", (Object)false);
            this.getModel().setValue("redbluefirst", (Object)false);
        } else if ("redbluefirst".equals(method) && ((Boolean)this.getModel().getValue("redbluefirst")).booleanValue()) {
            this.getModel().setValue("single", (Object)false);
            this.getModel().setValue("whole", (Object)false);
        }
    }

    private void setDefaultScheme() {
        QFilter wfTypef = new QFilter("writeofftype", "=", (Object)this.getWfTypeByForm());
        QFilter enablef = new QFilter("enable", "=", (Object)Boolean.TRUE);
        List shemeIds = QueryServiceHelper.queryPrimaryKeys((String)this.getClass().getName(), (String)"msmod_scheme", (QFilter[])new QFilter[]{wfTypef, enablef}, (String)"number", (int)1);
        if (shemeIds.size() > 0) {
            this.getModel().setValue("wfscheme", shemeIds.get(0));
        }
    }

    private void viewCurrent() {
        String entityName = this.getPageCache().get("recordentity");
        QFilter creatorf = new QFilter("creator", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        DynamicObjectCollection wfRecordDycs = QueryServiceHelper.query((String)entityName, (String)"wfseq", (QFilter[])new QFilter[]{creatorf}, (String)"wfseq desc", (int)1);
        if (wfRecordDycs.isEmpty()) {
            return;
        }
        QFilter wfSeqf = new QFilter("wfseq", "=", ((DynamicObject)wfRecordDycs.get(0)).get("wfseq"));
        QFilter[] filters = new QFilter[]{creatorf, wfSeqf};
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])filters, null, (int)-1);
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        for (Object id : ids) {
            linkQueryPkIdCollection.addLinkQueryPkId(id);
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId(entityName);
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(creatorf));
        showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void viewHistory() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(this.getPageCache().get("recordentity"));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

