/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.wirteoff.wfmanual.common;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.ext.scmc.wirteoff.wfmanual.consts.WfBillListField;
import kd.bos.form.IFormView;
import kd.bos.formula.FormulaEngine;
import kd.bos.util.StringUtils;

public class WfManualUtil {
    public static Object getForMualValue(String expression, Map<String, Object> args) {
        return FormulaEngine.execExcelFormula((String)expression, args);
    }

    public static Set<String> getExpressionField(String billType, String wfMainField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        HashSet<String> fieldSet = new HashSet<String>(12);
        for (String column : columns) {
            IDataEntityProperty property = dataEntityType.findProperty(column);
            String parent = property.getParent().getName();
            if (billType.equals(parent)) {
                fieldSet.add(column);
                continue;
            }
            fieldSet.add(parent + "." + column);
        }
        return fieldSet;
    }

    public static String getEntryKey(String entityNumber, String wfMainField) {
        String[] split = wfMainField.split("@@");
        if ("B".equals(split[1])) {
            return WfManualUtil.getFormulaEntryKey(entityNumber, wfMainField);
        }
        return WfManualUtil.getFieldEntryKey(entityNumber, wfMainField);
    }

    private static String getFormulaEntryKey(String entityNumber, String wfMainField) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)wfMainField, CRCondition.class);
        String[] columns = FormulaEngine.extractVariables((String)condition.getExpression());
        IDataEntityProperty property = dataEntityType.findProperty(columns[0]);
        String entryName = property.getParent().getName();
        if (!dataEntityType.getName().equals(entryName)) {
            return entryName + ".id";
        }
        return "id";
    }

    public static String getFieldEntryKey(String entityNumber, String wfMainField) {
        int lastPointIndex;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String entryId = null;
        entryId = wfMainField != null ? ((lastPointIndex = wfMainField.lastIndexOf(46)) == -1 ? dataEntityType.getPrimaryKey().getName() : wfMainField.substring(0, lastPointIndex) + ".id") : dataEntityType.getPrimaryKey().getName();
        return entryId;
    }

    public static List<WfBillListField> getBillListFields(IFormView view) {
        String billListFields = (String)view.getFormShowParameter().getCustomParam("billListFields");
        if (StringUtils.isEmpty((String)billListFields)) {
            return new ArrayList<WfBillListField>(1);
        }
        List fieldsList = JSONObject.parseArray((String)billListFields, WfBillListField.class);
        return fieldsList;
    }
}

