/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.data.idi.model.AttachmentHighLight;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.ext.data.idi.model.InvoiceHighLight;
import kd.bos.ext.data.idi.model.KeyWordHighLight;
import kd.bos.ext.data.idi.model.LinkUpBillHighLight;
import kd.bos.ext.data.idi.model.RowBaseHighLight;
import kd.bos.form.AbstractFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class IDIHighLightFormPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(IDIHighLightFormPlugin.class);
    private static final String HOVERCONTENT_HIGHLIGHTKEY = "highLightKey";
    private static final String MATCHTYPE_LINKUP = "linkup_bill";
    private static final String MATCHTYPE_KEYWORD = "keyword";
    private static final String MATCHTYPE_INVOICE = "invoice";
    private static final String MATCHTYPE_ATTACHMENT = "attachment";
    private static final String KEY_BILLPAGEID = "pageId";
    private static final String KEY_HIGHLIGHTDECISION = "highLightDecision";
    private static final String KEY_RIGHTSWITCH = "rightSwitch";
    private static final String KEY_LEFTSWITCH = "leftSwitch";
    private static final String KEY_CANELHIGHLIGHT = "canelHighLight";
    protected static final String KEY_LINKBILLHEIGHTVISIBLE = "linkBillHeightVisible";

    public void highLightCustomEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if (KEY_HIGHLIGHTDECISION.equalsIgnoreCase(eventName)) {
            String highLightVal = e.getEventArgs();
            this.highLightDecisionResult(highLightVal);
        } else if (KEY_RIGHTSWITCH.equalsIgnoreCase(eventName)) {
            String highLightVal = e.getEventArgs();
            this.switchHighLightCursor(highLightVal, KeyWordHighLight::nextCursor, AttachmentHighLight::nextCursor, RowBaseHighLight::nextCursor, RowBaseHighLight::nextCursor);
        } else if (KEY_LEFTSWITCH.equalsIgnoreCase(eventName)) {
            String highLightVal = e.getEventArgs();
            this.switchHighLightCursor(highLightVal, KeyWordHighLight::previousCursor, AttachmentHighLight::previousCursor, RowBaseHighLight::previousCursor, RowBaseHighLight::previousCursor);
        } else if (KEY_CANELHIGHLIGHT.equals(eventName)) {
            this.cancelHighLight();
        } else if (KEY_LINKBILLHEIGHTVISIBLE.equals(eventName)) {
            String linkHighLightParamStr = e.getEventArgs();
            this.linkBillHighLight(linkHighLightParamStr);
        }
    }

    private void linkBillHighLight(String linkHighLightParamStr) {
        if (StringUtils.isNotEmpty((String)linkHighLightParamStr)) {
            Map argMap = this.cast(linkHighLightParamStr, Map.class);
            String linkBillPageId = (String)argMap.get(KEY_BILLPAGEID);
            String highLightVal = (String)argMap.get(HOVERCONTENT_HIGHLIGHTKEY);
            String linkBillEntityType = (String)argMap.get("billType");
            String linkBillId = (String)argMap.get("billId");
            if (StringUtils.isNotEmpty((String)linkBillPageId) && StringUtils.isNotEmpty((String)highLightVal) && StringUtils.isNotEmpty((String)linkBillEntityType) && StringUtils.isNotEmpty((String)linkBillId)) {
                String matchType;
                String highLight;
                String[] flags = highLightVal.split("_");
                String areaPk = flags[0];
                String decisionPk = flags[1];
                String sourceBillPageId = this.getBillPageId();
                if (highLightVal.equals(this.getCacheHighLightKey())) {
                    highLight = this.getCacheHighLight();
                    matchType = this.getCacheHighLightMatchType();
                } else {
                    Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaResultQueryService", (String)"querySchemaResultByPkAndPageId", (Object[])new Object[]{sourceBillPageId, areaPk, decisionPk});
                    if (resultMap == null || resultMap.isEmpty()) {
                        return;
                    }
                    Map.Entry messageEntry = resultMap.entrySet().iterator().next();
                    matchType = (String)messageEntry.getKey();
                    highLight = (String)messageEntry.getValue();
                    logger.info(ResManager.loadKDString((String)"\u5f53\u524d\u8df3\u8f6c\u7684\u76ee\u6807\u5355\u6240\u5728\u7684\u68c0\u67e5\u9879\u7ed3\u679c\u672a\u89e6\u53d1\u9ad8\u4eae\uff0c\u4e0d\u4f1a\u5bf9\u76ee\u6807\u5355\u8fdb\u884c\u9ad8\u4eae", (String)"IDIHighLightFormPlugin_0", (String)"bos-ext-data", (Object[])new Object[0]));
                }
                AbstractFormView linkBillView = (AbstractFormView)this.getView().getViewNoPlugin(linkBillPageId);
                if (MATCHTYPE_LINKUP.equals(matchType)) {
                    List<LinkUpBillHighLight> highLightList = this.jsonCastToList(highLight, LinkUpBillHighLight.class);
                    int ruleIndex = Integer.parseInt(flags[2]);
                    Optional<LinkUpBillHighLight> linkupHighLightOptional = highLightList.stream().filter(lubr -> !lubr.isSource() && lubr.getBillType().equals(linkBillEntityType) && lubr.getBillId().equals(linkBillId) && lubr.getRuleIndex() == ruleIndex).findFirst();
                    if (linkupHighLightOptional.isPresent()) {
                        LinkUpBillHighLight linkUpBillHighLight = linkupHighLightOptional.get();
                        linkUpBillHighLight.createHighLightCommand(linkBillView, null);
                        this.sendAction(linkBillView, linkBillPageId);
                    }
                }
            }
        }
    }

    private void cancelHighLight() {
        String oldHighLightVal = this.getCacheHighLightKey();
        if (StringUtils.isEmpty((String)oldHighLightVal)) {
            return;
        }
        String highLight = this.getCacheHighLight();
        if (StringUtils.isEmpty((String)highLight)) {
            return;
        }
        String matchType = this.getCacheHighLightMatchType();
        String billPageId = this.getBillPageId();
        String[] flags = oldHighLightVal.split("_");
        AbstractFormView billView = (AbstractFormView)this.getView().getViewNoPlugin(billPageId);
        switch (matchType) {
            case "linkup_bill": {
                this.cancelLinkupHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            case "keyword": {
                this.cancelKeyWordHighLight(highLight, billView, billPageId);
                break;
            }
            case "attachment": {
                this.cancelAttachmentHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            case "invoice": {
                this.cancelInvoiceHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            default: {
                logger.info("cancelHighLight unknown matchType : " + matchType);
            }
        }
        this.deleteCacheHighLightKey();
        this.deleteCacheHighLightCursor();
    }

    private void cancelInvoiceHighLight(String highLight, String ruleNo, AbstractFormView billView, String billPageId) {
        List<InvoiceHighLight> highLightList = this.jsonCastToList(highLight, InvoiceHighLight.class);
        Optional<InvoiceHighLight> invoiceHighLightOptional = highLightList.stream().filter(ih -> ih.getRuleNo().equals(ruleNo)).findFirst();
        if (invoiceHighLightOptional.isPresent()) {
            InvoiceHighLight invoiceBillHighLight = invoiceHighLightOptional.get();
            invoiceBillHighLight.createCommandToCancel(billView);
            this.sendAction(billView, billPageId);
        }
    }

    private void cancelAttachmentHighLight(String highLight, String ruleIndexStr, AbstractFormView billView, String billPageId) {
        List<AttachmentHighLight> highLightList = this.jsonCastToList(highLight, AttachmentHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<AttachmentHighLight> attachmentHighLightOptional = highLightList.stream().filter(ahl -> ahl.getRuleIndex() == ruleIndex).findFirst();
        if (attachmentHighLightOptional.isPresent()) {
            AttachmentHighLight attachmentBillHighLight = attachmentHighLightOptional.get();
            attachmentBillHighLight.createCommandToCancel(billView);
            this.sendAction(billView, billPageId);
        }
    }

    private void cancelKeyWordHighLight(String highLight, AbstractFormView billView, String billPageId) {
        List<KeyWordHighLight> highLightList = this.jsonCastToList(highLight, KeyWordHighLight.class);
        if (CollectionUtils.isNotEmpty(highLightList)) {
            KeyWordHighLight keyWordBillHighLight = highLightList.get(0);
            keyWordBillHighLight.createCommandToCancel(billView);
            this.sendAction(billView, billPageId);
        }
    }

    private void cancelLinkupHighLight(String highLight, String ruleIndexStr, AbstractFormView billView, String billPageId) {
        List<LinkUpBillHighLight> highLightList = this.jsonCastToList(highLight, LinkUpBillHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<LinkUpBillHighLight> linkupHighLightOptional = highLightList.stream().filter(lubr -> lubr.isSource() && lubr.getRuleIndex() == ruleIndex).findFirst();
        if (linkupHighLightOptional.isPresent()) {
            LinkUpBillHighLight linkUpBillHighLight = linkupHighLightOptional.get();
            linkUpBillHighLight.createCommandToCancel(billView);
            this.sendAction(billView, billPageId);
        }
    }

    private void switchHighLightCursor(String highLightVal, BiFunction<KeyWordHighLight, HighLightCursor, HighLightCursor> keywordNewCursorFunction, BiFunction<AttachmentHighLight, HighLightCursor, HighLightCursor> attachmentNewCursorFunction, BiFunction<InvoiceHighLight, HighLightCursor, HighLightCursor> invoiceNewCursorFunction, BiFunction<LinkUpBillHighLight, HighLightCursor, HighLightCursor> linkipNewCursorFunction) {
        if (StringUtils.isEmpty((String)highLightVal)) {
            logger.info(ResManager.loadKDString((String)"\u5149\u6807\u5207\u6362\u65e0\u9ad8\u4eae\u7d22\u5f15\u4fe1\u606f", (String)"IDIHighLightFormPlugin_1", (String)"bos-ext-data", (Object[])new Object[0]));
            return;
        }
        String oldHighLightVal = this.getCacheHighLightKey();
        if (!highLightVal.equals(oldHighLightVal)) {
            this.highLightDecisionResult(highLightVal);
            return;
        }
        String highLight = this.getCacheHighLight();
        if (StringUtils.isEmpty((String)highLight)) {
            logger.info(ResManager.loadKDString((String)"\u5f53\u524d\u68c0\u67e5\u9879\u65e0\u9ad8\u4eae\u6574\u4f53\u4fe1\u606f", (String)"IDIHighLightFormPlugin_2", (String)"bos-ext-data", (Object[])new Object[0]));
            return;
        }
        String matchType = this.getCacheHighLightMatchType();
        String cursorStr = this.getCacheHighLightCursor();
        HighLightCursor cursor = this.cast(cursorStr, HighLightCursor.class);
        String billPageId = this.getBillPageId();
        String[] flags = highLightVal.split("_");
        AbstractFormView billView = (AbstractFormView)this.getView().getViewNoPlugin(billPageId);
        switch (matchType) {
            case "linkup_bill": {
                this.switchLinkupHighLightCursor(highLight, flags[2], cursor, billView, billPageId, linkipNewCursorFunction);
                break;
            }
            case "keyword": {
                this.switchKeyWordHighLightCursor(highLight, billView, billPageId, cursor, keywordNewCursorFunction);
                break;
            }
            case "attachment": {
                this.switchAttachmentHighLightCursor(highLight, flags[2], billView, billPageId, cursor, attachmentNewCursorFunction);
                break;
            }
            case "invoice": {
                this.switchInvoiceHighLightCursor(highLight, flags[2], billView, billPageId, cursor, invoiceNewCursorFunction);
                break;
            }
            default: {
                logger.info("switchHighLightCursor unknown matchType : " + matchType);
            }
        }
    }

    private void switchKeyWordHighLightCursor(String highLight, AbstractFormView billView, String billPageId, HighLightCursor oldCursor, BiFunction<KeyWordHighLight, HighLightCursor, HighLightCursor> newCursorFunction) {
        if (oldCursor == null) {
            return;
        }
        List<KeyWordHighLight> highLightList = this.jsonCastToList(highLight, KeyWordHighLight.class);
        if (CollectionUtils.isNotEmpty(highLightList)) {
            KeyWordHighLight keyWordBillHighLight = highLightList.get(0);
            HighLightCursor newCursor = newCursorFunction.apply(keyWordBillHighLight, oldCursor);
            if (newCursor != null) {
                newCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(newCursor == null ? null : this.toJsonString(newCursor));
            oldCursor.createHighLightCommandRollback(billView);
            keyWordBillHighLight.createHighLightCommandToNewCursor(billView, newCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void switchAttachmentHighLightCursor(String highLight, String ruleIndexStr, AbstractFormView billView, String billPageId, HighLightCursor oldCursor, BiFunction<AttachmentHighLight, HighLightCursor, HighLightCursor> newCursorFunction) {
        if (oldCursor == null) {
            return;
        }
        List<AttachmentHighLight> highLightList = this.jsonCastToList(highLight, AttachmentHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<AttachmentHighLight> attachmentHighLightOptional = highLightList.stream().filter(ahl -> ahl.getRuleIndex() == ruleIndex).findFirst();
        if (attachmentHighLightOptional.isPresent()) {
            AttachmentHighLight attachmentBillHighLight = attachmentHighLightOptional.get();
            HighLightCursor newCursor = newCursorFunction.apply(attachmentBillHighLight, oldCursor);
            if (newCursor != null) {
                newCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(newCursor == null ? null : this.toJsonString(newCursor));
            oldCursor.createHighLightCommandRollback(billView);
            attachmentBillHighLight.createHighLightCommandToNewCursor(billView, newCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void switchInvoiceHighLightCursor(String highLight, String ruleNo, AbstractFormView billView, String billPageId, HighLightCursor oldCursor, BiFunction<InvoiceHighLight, HighLightCursor, HighLightCursor> newCursorFunction) {
        if (oldCursor == null) {
            return;
        }
        List<InvoiceHighLight> highLightList = this.jsonCastToList(highLight, InvoiceHighLight.class);
        Optional<InvoiceHighLight> invoiceHighLightOptional = highLightList.stream().filter(ih -> ih.getRuleNo().equals(ruleNo)).findFirst();
        if (invoiceHighLightOptional.isPresent()) {
            InvoiceHighLight invoiceBillHighLight = invoiceHighLightOptional.get();
            HighLightCursor newCursor = newCursorFunction.apply(invoiceBillHighLight, oldCursor);
            this.setCacheHighLightCursor(newCursor == null ? null : this.toJsonString(newCursor));
            if (newCursor != null) {
                newCursor.setFocus(!this.isFloat());
            }
            oldCursor.createHighLightCommandRollback(billView);
            invoiceBillHighLight.createHighLightCommandToNewCursor(billView, newCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void switchLinkupHighLightCursor(String highLight, String ruleIndexStr, HighLightCursor oldCursor, AbstractFormView billView, String billPageId, BiFunction<LinkUpBillHighLight, HighLightCursor, HighLightCursor> newCursorFunction) {
        if (oldCursor == null) {
            return;
        }
        List<LinkUpBillHighLight> highLightList = this.jsonCastToList(highLight, LinkUpBillHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<LinkUpBillHighLight> linkupHighLightOptional = highLightList.stream().filter(lubr -> lubr.isSource() && lubr.getRuleIndex() == ruleIndex).findFirst();
        if (linkupHighLightOptional.isPresent()) {
            LinkUpBillHighLight linkUpBillHighLight = linkupHighLightOptional.get();
            HighLightCursor newCursor = newCursorFunction.apply(linkUpBillHighLight, oldCursor);
            if (newCursor != null) {
                newCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(newCursor == null ? null : this.toJsonString(newCursor));
            oldCursor.createHighLightCommandRollback(billView);
            linkUpBillHighLight.createHighLightCommandToNewCursor(billView, newCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void highLightDecisionResult(String highLightVal) {
        if (StringUtils.isEmpty((String)highLightVal)) {
            return;
        }
        String oldHighLightVal = this.getCacheHighLightKey();
        String[] flags = highLightVal.split("_");
        String areaPk = flags[0];
        String decisionPk = flags[1];
        boolean needChange = true;
        if (StringUtils.isNotEmpty((String)oldHighLightVal)) {
            String[] oldFlags = oldHighLightVal.split("_");
            String oldAreaPk = oldFlags[0];
            String oldDecisionPk = oldFlags[1];
            needChange = !areaPk.equals(oldAreaPk) || !decisionPk.equals(oldDecisionPk);
            this.cancelHighLight();
        }
        this.setCacheHighLightKey(highLightVal);
        String matchType = this.getCacheHighLightMatchType();
        String highLight = this.getCacheHighLight();
        String billPageId = this.getBillPageId();
        if (needChange) {
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaResultQueryService", (String)"querySchemaResultByPkAndPageId", (Object[])new Object[]{billPageId, areaPk, decisionPk});
            if (resultMap == null || resultMap.isEmpty()) {
                return;
            }
            Map.Entry messageEntry = resultMap.entrySet().iterator().next();
            matchType = (String)messageEntry.getKey();
            highLight = (String)messageEntry.getValue();
            this.setCacheHighLight(highLight);
            this.setCacheHighLightMatchType(matchType);
        }
        if (StringUtils.isEmpty((String)highLight)) {
            String logStr = ResManager.loadKDString((String)"\u672a\u5b9a\u4f4d\u5230\u9ad8\u4eae\u4fe1\u606f pageid:{%1$s}, areaid:%2$s, itemId:%3$s", (String)"IDIHighLightFormPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]);
            String mesg = String.format(logStr, billPageId, areaPk, decisionPk);
            logger.info(mesg);
            return;
        }
        AbstractFormView billView = (AbstractFormView)this.getView().getViewNoPlugin(billPageId);
        switch (matchType) {
            case "linkup_bill": {
                this.processLinkUpHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            case "keyword": {
                this.processKeyWordHighLight(highLight, billView, billPageId);
                break;
            }
            case "attachment": {
                this.processAttachmentHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            case "invoice": {
                this.processInvoiceHighLight(highLight, flags[2], billView, billPageId);
                break;
            }
            default: {
                logger.info("switchHighLightCursor unknown matchType : " + matchType);
            }
        }
    }

    private void processKeyWordHighLight(String highLight, AbstractFormView billView, String billPageId) {
        List<KeyWordHighLight> highLightList = this.jsonCastToList(highLight, KeyWordHighLight.class);
        if (CollectionUtils.isNotEmpty(highLightList)) {
            KeyWordHighLight keyWordBillHighLight = highLightList.get(0);
            HighLightCursor defaultCursor = keyWordBillHighLight.findFirstCursor();
            if (defaultCursor != null) {
                defaultCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(defaultCursor == null ? null : this.toJsonString(defaultCursor));
            keyWordBillHighLight.createHighLightCommand(billView, defaultCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void processAttachmentHighLight(String highLight, String ruleIndexStr, AbstractFormView billView, String billPageId) {
        List<AttachmentHighLight> highLightList = this.jsonCastToList(highLight, AttachmentHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<AttachmentHighLight> attachmentHighLightOptional = highLightList.stream().filter(ahl -> ahl.getRuleIndex() == ruleIndex).findFirst();
        if (attachmentHighLightOptional.isPresent()) {
            AttachmentHighLight attachmentBillHighLight = attachmentHighLightOptional.get();
            HighLightCursor defaultCursor = attachmentBillHighLight.findFirstCursor();
            if (defaultCursor != null) {
                defaultCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(defaultCursor == null ? null : this.toJsonString(defaultCursor));
            attachmentBillHighLight.createHighLightCommand(billView, defaultCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void processInvoiceHighLight(String highLight, String ruleNo, AbstractFormView billView, String billPageId) {
        List<InvoiceHighLight> highLightList = this.jsonCastToList(highLight, InvoiceHighLight.class);
        Optional<InvoiceHighLight> invoiceHighLightOptional = highLightList.stream().filter(ih -> ih.getRuleNo().equals(ruleNo)).findFirst();
        if (invoiceHighLightOptional.isPresent()) {
            InvoiceHighLight invoiceBillHighLight = invoiceHighLightOptional.get();
            HighLightCursor defaultCursor = invoiceBillHighLight.findFirstCursor();
            if (defaultCursor != null) {
                defaultCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(defaultCursor == null ? null : this.toJsonString(defaultCursor));
            invoiceBillHighLight.createHighLightCommand(billView, defaultCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void processLinkUpHighLight(String highLight, String ruleIndexStr, AbstractFormView billView, String billPageId) {
        List<LinkUpBillHighLight> highLightList = this.jsonCastToList(highLight, LinkUpBillHighLight.class);
        int ruleIndex = Integer.parseInt(ruleIndexStr);
        Optional<LinkUpBillHighLight> linkupHighLightOptional = highLightList.stream().filter(lubr -> lubr.isSource() && lubr.getRuleIndex() == ruleIndex).findFirst();
        if (linkupHighLightOptional.isPresent()) {
            LinkUpBillHighLight linkUpBillHighLight = linkupHighLightOptional.get();
            HighLightCursor defaultCursor = linkUpBillHighLight.findFirstCursor();
            if (defaultCursor != null) {
                defaultCursor.setFocus(!this.isFloat());
            }
            this.setCacheHighLightCursor(defaultCursor == null ? null : this.toJsonString(defaultCursor));
            linkUpBillHighLight.createHighLightCommand(billView, defaultCursor);
            this.sendAction(billView, billPageId);
        }
    }

    private void sendAction(AbstractFormView billView, String billPageId) {
        if (billView == null) {
            return;
        }
        List acts = billView.getActionResult();
        HashMap<String, Object> arg = new HashMap<String, Object>(3);
        arg.put(KEY_BILLPAGEID, billPageId);
        arg.put("actions", acts);
        ((AbstractFormView)this.getView()).getClientProxy().addAction("sendDynamicFormAction", arg);
    }

    private String getCacheHighLight() {
        return this.getPageCache().get("currentDecisionHighLight");
    }

    private String getCacheHighLightKey() {
        return this.getPageCache().get("currentDecisionHighLight_key");
    }

    private String getCacheHighLightMatchType() {
        return this.getPageCache().get("currentDecisionHighLight_matchType");
    }

    private String getCacheHighLightCursor() {
        return this.getPageCache().get("currentDecisionHighLight_cursor");
    }

    private void setCacheHighLight(String highLightStr) {
        this.getPageCache().put("currentDecisionHighLight", highLightStr);
    }

    private void setCacheHighLightKey(String key) {
        this.getPageCache().put("currentDecisionHighLight_key", key);
    }

    private void setCacheHighLightMatchType(String matchType) {
        this.getPageCache().put("currentDecisionHighLight_matchType", matchType);
    }

    private void setCacheHighLightCursor(String cursorStr) {
        this.getPageCache().put("currentDecisionHighLight_cursor", cursorStr);
    }

    private void deleteCacheHighLight() {
        this.getPageCache().remove("currentDecisionHighLight");
    }

    private void deleteCacheHighLightKey() {
        this.getPageCache().remove("currentDecisionHighLight_key");
    }

    private void deleteCacheHighLightMatchType() {
        this.getPageCache().remove("currentDecisionHighLight_matchType");
    }

    private void deleteCacheHighLightCursor() {
        this.getPageCache().remove("currentDecisionHighLight_cursor");
    }

    private <T> T cast(String json, Class<T> clazz) {
        return (T)JSON.parseObject((String)json, clazz);
    }

    private <T> List<T> jsonCastToList(String json, Class<T> clazz) {
        return JSON.parseArray((String)json, clazz);
    }

    private String toJsonString(Object data) {
        return JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    public String getBillPageId() {
        return this.getView().getPageId();
    }

    public boolean isFloat() {
        return false;
    }

    public boolean hasChild() {
        return true;
    }
}

