/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.operation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.DispatchServiceHelper;

public class VirtualOperation
extends DefaultEntityOperate {
    private Map<String, Object> opParameter = new HashMap<String, Object>(16);

    public void initialize(Map<String, Object> opMeta) {
        String parameterString;
        Map jsonMap;
        super.initialize(opMeta);
        Map parameters = (Map)opMeta.get("parameter");
        parameters.put("checkpermission", false);
        if (!parameters.isEmpty() && (jsonMap = (Map)SerializationUtils.fromJsonString((String)(parameterString = (String)parameters.get("parameter")), Map.class)) != null && !jsonMap.isEmpty()) {
            Object checkPermission;
            Object realOperation = jsonMap.get("realoperation");
            if (realOperation != null) {
                this.opParameter.put("realoperation", realOperation);
            }
            if ((checkPermission = jsonMap.get("checkpermission")) != null) {
                this.opParameter.put("checkpermission", checkPermission);
            }
        }
    }

    public OperationResult invokeOperation() {
        OperationResult operationResult;
        String realOperationKey = this.opParameter.get("realoperation").toString();
        OperateOption option = this.getOption();
        if (((Boolean)this.opParameter.get("checkpermission")).booleanValue() && !this.hasRight()) {
            this.getView().showTipNotification(String.format("\u60a8\u6ca1\u6709%s\u64cd\u4f5c\u7684\u6743\u9650,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f00\u901a\u6743\u9650.", this.getOperateName().getLocaleValue()));
            OperationResult operationResult2 = new OperationResult();
            operationResult2.setSuccess(false);
            return operationResult2;
        }
        boolean isDelete = "delete".equalsIgnoreCase(realOperationKey);
        boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
        if (isDelete && isConfirm) {
            OperationResult operationResult3 = this.getView().invokeOperation(realOperationKey, this.getOption());
            return operationResult3;
        }
        if (this.getView() instanceof IListView && ("cp_new".equalsIgnoreCase(this.getOperateKey()) || "cp_copy".equalsIgnoreCase(this.getOperateKey()))) {
            operationResult = new OperationResult();
            operationResult.setSuccess(true);
            operationResult.setShowMessage(false);
        } else {
            if (!this.isFromERP()) {
                this.getView().getPageCache().put("hasRight", "true");
                this.getOption().setVariableValue("isOnlyValidator", "true");
                option.setVariableValue("ishasright", "true");
            }
            if (isDelete) {
                OperationResult operationResult4 = this.beforeDelete();
                return operationResult4;
            }
            operationResult = this.getView().invokeOperation(realOperationKey, option);
        }
        if (operationResult == null) {
            operationResult = new OperationResult();
            operationResult.setShowMessage(false);
        }
        operationResult.setInteractionContext(null);
        return operationResult;
    }

    public boolean needSelectData() {
        return this.isDelete();
    }

    private boolean isDelete() {
        String realOperationKey = this.opParameter.get("realoperation").toString();
        return realOperationKey.equals("delete");
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (this.isDelete()) {
            this.getOption().setVariableValue("batchop_batchsize", "10000");
        }
        return super.beforeInvokeOperation(result);
    }

    private FormInfo getFormId() {
        FormInfo formInfo = new FormInfo();
        formInfo.setFormId(this.getView().getFormShowParameter().getFormId());
        formInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        if (this.isFromPortal()) {
            Object type = this.getView().getFormShowParameter().getCustomParams().get("type");
            if (type != null && type.toString().equalsIgnoreCase("list")) {
                formInfo.setFormId(((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                formInfo.setAppId("ocbmall");
            }
        } else if (this.getView().getFormShowParameter().getFormConfig().getModelType().indexOf("mobile") >= 0) {
            formInfo.setFormId(this.getView().getFormShowParameter().getFormConfig().getEntityTypeId());
            formInfo.setAppId(this.getRootView(this.getView()).getFormShowParameter().getFormConfig().getAppId());
        }
        return formInfo;
    }

    private boolean hasRight() {
        if (this.isFromERP()) {
            return true;
        }
        FormInfo formInfo = this.getFormId();
        return (Boolean)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"PermService", (String)"isAuthorized", (Object[])new Object[]{RequestContext.get().getCurrUserId(), formInfo.getAppId(), formInfo.getFormId(), this.getOperateKey()});
    }

    protected boolean isShowMessage(OperationResult operationResult) {
        Boolean showMessage = super.isShowMessage(operationResult);
        if (!showMessage.booleanValue()) {
            return false;
        }
        if (operationResult == null) {
            return false;
        }
        return this.getSuccessMsg() != null && !StringUtils.isBlank((CharSequence)this.getSuccessMsg().toString());
    }

    private IFormView getRootView(IFormView view) {
        return view.getViewNoPlugin(this.getView().getFormShowParameter().getRootPageId());
    }

    private boolean isFromPortal() {
        String queryString = RequestContext.get().getQueryString();
        String mainViewId = this.getView().getMainView() != null ? this.getView().getMainView().getEntityId() : "";
        return queryString != null && !queryString.trim().equals("") && queryString.indexOf("_p=occ") >= 0 || mainViewId.equalsIgnoreCase("b2b_main");
    }

    private boolean isFromMall() {
        String mainViewId = this.getView().getMainView() != null ? this.getView().getMainView().getEntityId() : "";
        return mainViewId.equalsIgnoreCase("b2b_mall");
    }

    private boolean isFromERP() {
        return !this.isFromMall() && !this.isFromPortal();
    }

    private OperationResult beforeDelete() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String message = MessageFormat.format("\u5220\u9664\u9009\u4e2d\u7684{0}\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\r\n\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", billList != null ? billList.getSelectedRows().size() : 0);
        this.setConfirmMessage(message);
        this.setConfirmTypes(ConfirmTypes.Delete);
        OperationResult operationResult = new OperationResult();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("contentChange", (AbstractOperate)this);
        String confirmTip = this.getConfirmMessage() + "";
        confirmCallBacks.getOperateOption().put("ishasright", "true");
        this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, this.getConfirmTypes(), confirmCallBacks);
        operationResult.setSuccess(false);
        return operationResult;
    }

    private class FormInfo {
        private String appId;
        private String formId;

        private FormInfo() {
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getFormId() {
            return this.formId;
        }

        public void setFormId(String formId) {
            this.formId = formId;
        }
    }
}

